/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.batch.DeleteBatchTranslator;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.DeleteBatchQuery;

public class SoftDeleteBatchTranslator
extends DeleteBatchTranslator {
    private String deletedFieldName;

    public SoftDeleteBatchTranslator(DeleteBatchQuery query, DbAdapter adapter, String trimFunction, String deletedFieldName) {
        super(query, adapter, trimFunction);
        this.deletedFieldName = deletedFieldName;
    }

    @Override
    protected String createSql() {
        QuotingStrategy strategy = this.adapter.getQuotingStrategy();
        StringBuilder buffer = new StringBuilder("UPDATE ");
        buffer.append(strategy.quotedFullyQualifiedName(this.query.getDbEntity()));
        buffer.append(" SET ").append(strategy.quotedIdentifier(this.query.getDbEntity(), this.deletedFieldName)).append(" = ?");
        this.applyQualifier(buffer);
        return buffer.toString();
    }

    @Override
    protected DbAttributeBinding[] createBindings() {
        DbAttributeBinding[] superBindings = super.createBindings();
        int slen = superBindings.length;
        DbAttributeBinding[] bindings = new DbAttributeBinding[slen + 1];
        DbAttribute deleteAttribute = this.query.getDbEntity().getAttribute(this.deletedFieldName);
        String typeName = TypesMapping.getJavaBySqlType(deleteAttribute.getType());
        ExtendedType extendedType = this.adapter.getExtendedTypes().getRegisteredType(typeName);
        bindings[0] = new DbAttributeBinding(deleteAttribute);
        bindings[0].include(1, true, extendedType);
        System.arraycopy(superBindings, 0, bindings, 1, slen);
        return bindings;
    }

    @Override
    protected DbAttributeBinding[] doUpdateBindings(BatchQueryRow row) {
        int len = this.bindings.length;
        DeleteBatchQuery deleteBatch = (DeleteBatchQuery)this.query;
        int j = 2;
        for (int i = 1; i < len; ++i) {
            DbAttributeBinding b = this.bindings[i];
            if (deleteBatch.isNull(b.getAttribute())) {
                b.exclude();
                continue;
            }
            Object value = row.getValue(i - 1);
            ExtendedType extendedType = value != null ? this.adapter.getExtendedTypes().getRegisteredType(value.getClass()) : this.adapter.getExtendedTypes().getDefaultType();
            b.include(j++, value, extendedType);
        }
        return this.bindings;
    }
}

