/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.db2;

import java.sql.PreparedStatement;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.types.BooleanType;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.db2.DB2ActionBuilder;
import org.apache.cayenne.dba.db2.DB2EJBQLTranslatorFactory;
import org.apache.cayenne.dba.db2.DB2PkGenerator;
import org.apache.cayenne.dba.db2.DB2QualifierTranslator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.resource.ResourceLocator;

public class DB2Adapter
extends JdbcAdapter {
    private static final String FOR_BIT_DATA_SUFFIX = " FOR BIT DATA";
    private static final String TRIM_FUNCTION = "RTRIM";

    public DB2Adapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator, @Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator, valueObjectTypeRegistry);
        this.setSupportsGeneratedKeys(true);
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new DB2PkGenerator(this);
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, true));
        map.registerType(new DB2BooleanType());
        map.registerType(new ByteArrayType(false, false));
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        String[] types = this.externalTypesForJdbcType(column.getType());
        if (types == null || types.length == 0) {
            String entityName = column.getEntity() != null ? column.getEntity().getFullyQualifiedName() : "<null>";
            throw new CayenneRuntimeException("Undefined type for attribute '%s.%s': %s", entityName, column.getName(), column.getType());
        }
        String type = types[0];
        sqlBuffer.append(this.quotingStrategy.quotedName(column)).append(' ');
        int maxLength = column.getMaxLength();
        if (column.getType() == -15) {
            column.setMaxLength(maxLength / 2);
        }
        String length = DB2Adapter.sizeAndPrecision(this, column);
        column.setMaxLength(maxLength);
        int suffixIndex = type.indexOf(FOR_BIT_DATA_SUFFIX);
        if (!length.isEmpty() && suffixIndex > 0) {
            sqlBuffer.append(type.substring(0, suffixIndex)).append(length).append(FOR_BIT_DATA_SUFFIX);
        } else {
            sqlBuffer.append(type).append(" ").append(length);
        }
        if (column.isMandatory()) {
            sqlBuffer.append(" NOT NULL");
        }
        if (column.isGenerated()) {
            sqlBuffer.append(" GENERATED BY DEFAULT AS IDENTITY");
        }
    }

    @Override
    public boolean typeSupportsLength(int type) {
        return type == -1 || type == -4 || super.typeSupportsLength(type);
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        DB2QualifierTranslator translator = new DB2QualifierTranslator(queryAssembler, TRIM_FUNCTION);
        translator.setCaseInsensitive(this.caseInsensitiveCollations);
        return translator;
    }

    @Override
    public EJBQLTranslatorFactory getEjbqlTranslatorFactory() {
        DB2EJBQLTranslatorFactory translatorFactory = new DB2EJBQLTranslatorFactory();
        translatorFactory.setCaseInsensitive(this.caseInsensitiveCollations);
        return translatorFactory;
    }

    @Override
    public void bindParameter(PreparedStatement statement, ParameterBinding binding) throws Exception {
        if (binding.getValue() == null && (binding.getJdbcType() == 0 || binding.getJdbcType() == 16)) {
            statement.setNull(binding.getStatementPosition(), 12);
        } else {
            binding.setJdbcType(this.convertNTypes(binding.getJdbcType()));
            super.bindParameter(statement, binding);
        }
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new DB2ActionBuilder(node));
    }

    private int convertNTypes(int sqlType) {
        switch (sqlType) {
            case -15: {
                return 1;
            }
            case -9: {
                return 12;
            }
            case -16: {
                return -1;
            }
            case 2011: {
                return 2005;
            }
        }
        return sqlType;
    }

    final class DB2BooleanType
    extends BooleanType {
        DB2BooleanType() {
        }

        @Override
        public void setJdbcObject(PreparedStatement st, Boolean val, int pos, int type, int precision) throws Exception {
            if (val != null) {
                st.setInt(pos, val != false ? 1 : 0);
            } else {
                st.setNull(pos, type);
            }
        }
    }
}

