/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.util.XMLEncoder;

public class ProcedureQueryDescriptor
extends QueryDescriptor {
    protected String resultEntityName;

    public ProcedureQueryDescriptor() {
        super("ProcedureQuery");
    }

    public String getResultEntityName() {
        return this.resultEntityName;
    }

    public void setResultEntityName(String resultEntityName) {
        this.resultEntityName = resultEntityName;
    }

    @Override
    public ProcedureQuery buildQuery() {
        ProcedureQuery procedureQuery = new ProcedureQuery();
        if (this.root != null) {
            procedureQuery.setRoot(this.root);
        }
        procedureQuery.setName(this.getName());
        procedureQuery.setDataMap(this.dataMap);
        procedureQuery.setResultEntityName(this.getResultEntityName());
        procedureQuery.initWithProperties(this.getProperties());
        return procedureQuery;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<query name=\"");
        encoder.print(this.getName());
        encoder.print("\" type=\"");
        encoder.print(this.type);
        encoder.print("\" root=\"");
        encoder.print("procedure");
        String rootString = null;
        if (this.root instanceof String) {
            rootString = this.root.toString();
        } else if (this.root instanceof Procedure) {
            rootString = ((Procedure)this.root).getName();
        }
        if (rootString != null) {
            encoder.print("\" root-name=\"");
            encoder.print(rootString);
        }
        if (this.resultEntityName != null) {
            encoder.print("\" result-entity=\"");
            encoder.print(this.resultEntityName);
        }
        encoder.println("\">");
        encoder.indent(1);
        this.encodeProperties(encoder);
        encoder.indent(-1);
        encoder.println("</query>");
    }
}

