/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EJBQLQueryDescriptor;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureQueryDescriptor;
import org.apache.cayenne.map.SQLTemplateDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class QueryDescriptor
implements Serializable,
ConfigurationNode,
XMLSerializable {
    public static final String SELECT_QUERY = "SelectQuery";
    public static final String SQL_TEMPLATE = "SQLTemplate";
    public static final String EJBQL_QUERY = "EJBQLQuery";
    public static final String PROCEDURE_QUERY = "ProcedureQuery";
    protected String name;
    protected String type;
    protected DataMap dataMap;
    protected Object root;
    protected Map<String, String> properties = new HashMap<String, String>();

    public static SelectQueryDescriptor selectQueryDescriptor() {
        return new SelectQueryDescriptor();
    }

    public static SQLTemplateDescriptor sqlTemplateDescriptor() {
        return new SQLTemplateDescriptor();
    }

    public static ProcedureQueryDescriptor procedureQueryDescriptor() {
        return new ProcedureQueryDescriptor();
    }

    public static EJBQLQueryDescriptor ejbqlQueryDescriptor() {
        return new EJBQLQueryDescriptor();
    }

    public static QueryDescriptor descriptor(String type) {
        switch (type) {
            case "SelectQuery": {
                return QueryDescriptor.selectQueryDescriptor();
            }
            case "SQLTemplate": {
                return QueryDescriptor.sqlTemplateDescriptor();
            }
            case "EJBQLQuery": {
                return QueryDescriptor.ejbqlQueryDescriptor();
            }
            case "ProcedureQuery": {
                return QueryDescriptor.procedureQueryDescriptor();
            }
        }
        return new QueryDescriptor(type);
    }

    protected QueryDescriptor(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        this.root = root;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Query buildQuery() {
        throw new CayenneRuntimeException("Unable to build query object of this type.", new Object[0]);
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitQuery(this);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<query name=\"");
        encoder.print(this.getName());
        encoder.print("\" type=\"");
        encoder.print(this.type);
        String rootString = null;
        String rootType = null;
        if (this.root instanceof String) {
            rootType = "obj-entity";
            rootString = this.root.toString();
        } else if (this.root instanceof ObjEntity) {
            rootType = "obj-entity";
            rootString = ((ObjEntity)this.root).getName();
        } else if (this.root instanceof DbEntity) {
            rootType = "db-entity";
            rootString = ((DbEntity)this.root).getName();
        } else if (this.root instanceof Procedure) {
            rootType = "procedure";
            rootString = ((Procedure)this.root).getName();
        } else if (this.root instanceof Class) {
            rootType = "java-class";
            rootString = ((Class)this.root).getName();
        }
        if (rootType != null) {
            encoder.print("\" root=\"");
            encoder.print(rootType);
            encoder.print("\" root-name=\"");
            encoder.print(rootString);
        }
        encoder.println("\">");
        encoder.indent(1);
        this.encodeProperties(encoder);
        encoder.indent(-1);
        encoder.println("</query>");
    }

    void encodeProperties(XMLEncoder encoder) {
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            String value = property.getValue();
            if (value == null || value.isEmpty()) continue;
            encoder.printProperty(property.getKey(), value);
        }
    }
}

