/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.rop.server;

import java.util.Map;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.remote.RemoteService;
import org.apache.cayenne.rop.ROPSerializationService;
import org.apache.cayenne.rop.ServerHessianSerializationServiceProvider;
import org.apache.cayenne.rop.ServerHttpRemoteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROPServerModule
implements Module {
    private static final Logger logger = LoggerFactory.getLogger(ROPServerModule.class);
    protected Map<String, String> eventBridgeProperties;

    public static MapBuilder<String> contributeROPBridgeProperties(Binder binder) {
        return binder.bindMap(String.class, "cayenne.server.rop_event_bridge_properties");
    }

    public static ListBuilder<String> contributeSerializationWhitelist(Binder binder) {
        return binder.bindList(String.class, "serialization_whitelist");
    }

    public ROPServerModule() {
    }

    @Deprecated
    public ROPServerModule(Map<String, String> eventBridgeProperties) {
        this.eventBridgeProperties = eventBridgeProperties;
    }

    public void configure(Binder binder) {
        logger.warn("Since 4.2 cayenne-rop-server module was deprecated.");
        ROPServerModule.contributeSerializationWhitelist(binder);
        MapBuilder<String> mapBuilder = ROPServerModule.contributeROPBridgeProperties(binder);
        if (this.eventBridgeProperties != null) {
            mapBuilder.putAll(this.eventBridgeProperties);
        }
        binder.bind(RemoteService.class).to(ServerHttpRemoteService.class);
        binder.bind(ROPSerializationService.class).toProvider(ServerHessianSerializationServiceProvider.class);
    }
}

