/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.util.ToStringBuilder;

public class RemoteSession
implements Serializable {
    static final Collection<EventSubject> SUBJECTS = Arrays.asList(DataChannel.GRAPH_CHANGED_SUBJECT, DataChannel.GRAPH_FLUSHED_SUBJECT, DataChannel.GRAPH_ROLLEDBACK_SUBJECT);
    protected String name;
    protected String sessionId;
    protected String eventBridgeFactory;
    protected Map<String, String> eventBridgeParameters;

    private RemoteSession() {
    }

    public RemoteSession(String sessionId) {
        this(sessionId, null, null);
    }

    public RemoteSession(String sessionId, String eventBridgeFactory, Map<String, String> eventBridgeParameters) {
        if (sessionId == null) {
            throw new IllegalArgumentException("Null sessionId");
        }
        this.sessionId = sessionId;
        this.eventBridgeFactory = eventBridgeFactory;
        this.eventBridgeParameters = eventBridgeParameters;
    }

    public int hashCode() {
        return Objects.hash(this.sessionId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteSession that = (RemoteSession)o;
        return Objects.equals(this.sessionId, that.sessionId);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isServerEventsEnabled() {
        return this.eventBridgeFactory != null;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this).append("sessionId", (Object)this.sessionId);
        if (this.eventBridgeFactory != null) {
            builder.append("eventBridgeFactory", (Object)this.eventBridgeFactory);
        }
        if (this.name != null) {
            builder.append("name", (Object)this.name);
        }
        return builder.toString();
    }

    public static Collection<EventSubject> getSubjects() {
        return SUBJECTS;
    }

    public String getEventBridgeFactory() {
        return this.eventBridgeFactory;
    }

    public Map<String, String> getEventBridgeParameters() {
        return this.eventBridgeParameters != null ? this.eventBridgeParameters : Collections.emptyMap();
    }
}

