/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.Collection;
import java.util.List;
import org.apache.cayenne.dbsync.merge.AbstractMerger;
import org.apache.cayenne.dbsync.merge.MergerDictionaryDiff;
import org.apache.cayenne.dbsync.merge.MergerDiffPair;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;

class ChainMerger<T, M>
extends AbstractMerger<T, M> {
    private final AbstractMerger<T, M> merger;
    private final AbstractMerger<?, T> parentMerger;

    ChainMerger(MergerTokenFactory tokenFactory, AbstractMerger<T, M> merger, AbstractMerger<?, T> parentMerger) {
        super(tokenFactory);
        this.merger = merger;
        this.parentMerger = parentMerger;
    }

    @Override
    public List<MergerToken> createMergeTokens() {
        return this.createMergeTokens(null, null);
    }

    @Override
    MergerDictionaryDiff<M> createDiff(T unused1, T unused2) {
        MergerDictionaryDiff<M> diff = new MergerDictionaryDiff<M>();
        MergerDictionaryDiff<T> parentDiff = this.parentMerger.getDiff();
        this.merger.setOriginalDictionary(this.parentMerger.getOriginalDictionary());
        for (MergerDiffPair<T> pair : parentDiff.getSame()) {
            diff.addAll(this.merger.createDiff(pair.getOriginal(), pair.getImported()));
        }
        return diff;
    }

    @Override
    Collection<MergerToken> createTokensForMissingOriginal(M imported) {
        return this.merger.createTokensForMissingOriginal(imported);
    }

    @Override
    Collection<MergerToken> createTokensForMissingImported(M original) {
        return this.merger.createTokensForMissingImported(original);
    }

    @Override
    Collection<MergerToken> createTokensForSame(MergerDiffPair<M> same) {
        return this.merger.createTokensForSame(same);
    }
}

