/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EJBQLQueryDescriptor;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureQueryDescriptor;
import org.apache.cayenne.map.SQLTemplateDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class QueryDescriptor
implements Serializable,
ConfigurationNode,
XMLSerializable {
    public static final String SELECT_QUERY = "SelectQuery";
    public static final String SQL_TEMPLATE = "SQLTemplate";
    public static final String EJBQL_QUERY = "EJBQLQuery";
    public static final String PROCEDURE_QUERY = "ProcedureQuery";
    public static final String OBJ_ENTITY_ROOT = "obj-entity";
    public static final String DB_ENTITY_ROOT = "db-entity";
    public static final String PROCEDURE_ROOT = "procedure";
    public static final String DATA_MAP_ROOT = "data-map";
    public static final String JAVA_CLASS_ROOT = "java-class";
    protected String name;
    protected String type;
    protected DataMap dataMap;
    protected Object root;
    protected Map<String, String> properties = new HashMap<String, String>();

    public static SelectQueryDescriptor selectQueryDescriptor() {
        return new SelectQueryDescriptor();
    }

    public static SQLTemplateDescriptor sqlTemplateDescriptor() {
        return new SQLTemplateDescriptor();
    }

    public static ProcedureQueryDescriptor procedureQueryDescriptor() {
        return new ProcedureQueryDescriptor();
    }

    public static EJBQLQueryDescriptor ejbqlQueryDescriptor() {
        return new EJBQLQueryDescriptor();
    }

    public static QueryDescriptor descriptor(String type) {
        switch (type) {
            case "SelectQuery": {
                return QueryDescriptor.selectQueryDescriptor();
            }
            case "SQLTemplate": {
                return QueryDescriptor.sqlTemplateDescriptor();
            }
            case "EJBQLQuery": {
                return QueryDescriptor.ejbqlQueryDescriptor();
            }
            case "ProcedureQuery": {
                return QueryDescriptor.procedureQueryDescriptor();
            }
        }
        return new QueryDescriptor(type);
    }

    protected QueryDescriptor(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        this.root = root;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Query buildQuery() {
        throw new CayenneRuntimeException("Unable to build query object of this type.", new Object[0]);
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitQuery(this);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("query").attribute("name", this.getName()).attribute("type", this.type);
        String rootString = null;
        String rootType = null;
        if (this.root instanceof String) {
            rootType = OBJ_ENTITY_ROOT;
            rootString = this.root.toString();
        } else if (this.root instanceof ObjEntity) {
            rootType = OBJ_ENTITY_ROOT;
            rootString = ((ObjEntity)this.root).getName();
        } else if (this.root instanceof DbEntity) {
            rootType = DB_ENTITY_ROOT;
            rootString = ((DbEntity)this.root).getName();
        } else if (this.root instanceof Procedure) {
            rootType = PROCEDURE_ROOT;
            rootString = ((Procedure)this.root).getName();
        } else if (this.root instanceof Class) {
            rootType = JAVA_CLASS_ROOT;
            rootString = ((Class)this.root).getName();
        }
        if (rootType != null) {
            encoder.attribute("root", rootType).attribute("root-name", rootString);
        }
        this.encodeProperties(encoder);
        delegate.visitQuery(this);
        encoder.end();
    }

    void encodeProperties(XMLEncoder encoder) {
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            String value = property.getValue();
            if (value == null || value.isEmpty()) continue;
            encoder.property(property.getKey(), value);
        }
    }
}

