/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.state;

import java.util.ArrayList;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayEvent;
import org.apache.cayenne.modeler.util.state.ProcedureDisplayEventType;

class ProcedureParameterDisplayEventType
extends ProcedureDisplayEventType {
    public ProcedureParameterDisplayEventType(ProjectController controller) {
        super(controller);
    }

    @Override
    public void fireLastDisplayEvent() {
        DataChannelDescriptor dataChannel = (DataChannelDescriptor)this.controller.getProject().getRootNode();
        if (!dataChannel.getName().equals(this.preferences.getDomain())) {
            return;
        }
        DataMap dataMap = dataChannel.getDataMap(this.preferences.getDataMap());
        if (dataMap == null) {
            return;
        }
        Procedure procedure = dataMap.getProcedure(this.preferences.getProcedure());
        if (procedure == null) {
            return;
        }
        ProcedureDisplayEvent procedureDisplayEvent = new ProcedureDisplayEvent((Object)this, procedure, dataMap, dataChannel);
        this.controller.fireProcedureDisplayEvent(procedureDisplayEvent);
        ProcedureParameter[] procedureParameters = this.getLastProcedureParameters(procedure);
        ProcedureParameterDisplayEvent procedureParameterDisplayEvent = new ProcedureParameterDisplayEvent((Object)this, procedureParameters, procedure, dataMap, dataChannel);
        this.controller.fireProcedureParameterDisplayEvent(procedureParameterDisplayEvent);
    }

    @Override
    public void saveLastDisplayEvent() {
        this.preferences.setEvent(ProcedureParameterDisplayEvent.class.getSimpleName());
        this.preferences.setDomain(this.controller.getCurrentDataChanel().getName());
        this.preferences.setDataMap(this.controller.getCurrentDataMap().getName());
        this.preferences.setProcedure(this.controller.getCurrentProcedure().getName());
        this.preferences.setProcedureParams(this.parseToString(this.controller.getCurrentProcedureParameters()));
    }

    protected ProcedureParameter[] getLastProcedureParameters(Procedure procedure) {
        ArrayList<ProcedureParameter> procedureParameterList = new ArrayList<ProcedureParameter>();
        ProcedureParameter[] parameters = new ProcedureParameter[]{};
        String procedureParams = this.preferences.getProcedureParams();
        if (procedureParams.isEmpty()) {
            return procedureParameterList.toArray(parameters);
        }
        for (String procedureParamName : procedureParams.split(",")) {
            for (ProcedureParameter procedureParameter : procedure.getCallParameters()) {
                if (!procedureParameter.getName().equals(procedureParamName)) continue;
                procedureParameterList.add(procedureParameter);
            }
        }
        return procedureParameterList.toArray(parameters);
    }
}

