/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.BatchAction;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;

public class PostgresBatchAction
extends BatchAction {
    public PostgresBatchAction(BatchQuery query, DataNode dataNode, boolean runningAsBatch) {
        super(query, dataNode, runningAsBatch);
    }

    @Override
    protected PreparedStatement prepareStatement(Connection connection, String queryStr, DbAdapter adapter, boolean generatedKeys) throws SQLException {
        if (generatedKeys) {
            Collection<DbAttribute> generatedAttributes = this.query.getDbEntity().getGeneratedAttributes();
            String[] generatedPKColumns = new String[generatedAttributes.size()];
            int i = 0;
            for (DbAttribute generatedAttribute : generatedAttributes) {
                if (!generatedAttribute.isPrimaryKey()) continue;
                generatedPKColumns[i++] = generatedAttribute.getName().toLowerCase();
            }
            return connection.prepareStatement(queryStr, Arrays.copyOf(generatedPKColumns, i));
        }
        return connection.prepareStatement(queryStr);
    }
}

