/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.cayenne.access.sqlbuilder.sqltree.ChildProcessor;
import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;
import org.apache.cayenne.access.sqlbuilder.sqltree.PerAttributeChildProcessor;
import org.apache.cayenne.access.sqlbuilder.sqltree.SQLTreeProcessor;
import org.apache.cayenne.access.sqlbuilder.sqltree.SimpleNodeTreeVisitor;
import org.apache.cayenne.access.sqlbuilder.sqltree.ValueNode;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;

public class TypeAwareSQLTreeProcessor
extends SimpleNodeTreeVisitor
implements SQLTreeProcessor {
    protected static final Class<?> DEFAULT_TYPE = DefaultColumnTypeMarker.class;
    protected static final String DEFAULT_TYPE_NAME = DEFAULT_TYPE.getName();
    protected final Map<String, ChildProcessor<ColumnNode>> byColumnTypeProcessors = new HashMap<String, ChildProcessor<ColumnNode>>();
    protected final Map<String, ChildProcessor<ValueNode>> byValueTypeProcessors = new HashMap<String, ChildProcessor<ValueNode>>();
    protected final Map<NodeType, ChildProcessor<Node>> byNodeTypeProcessors = new EnumMap<NodeType, ChildProcessor<Node>>(NodeType.class);

    public TypeAwareSQLTreeProcessor() {
        this.registerProcessor(NodeType.COLUMN, new PerAttributeChildProcessor<ColumnNode>(this::getColumnAttribute, this::getColumnProcessor));
        this.registerProcessor(NodeType.VALUE, new PerAttributeChildProcessor<ValueNode>(this::getValueAttribute, this::getValueProcessor));
    }

    @Override
    public Node process(Node node) {
        node.visit(this);
        return node;
    }

    protected void registerProcessor(NodeType nodeType, ChildProcessor childProcessor) {
        this.byNodeTypeProcessors.put(nodeType, childProcessor);
    }

    protected void registerColumnProcessor(Class<?> columnType, ChildProcessor childProcessor) {
        this.byColumnTypeProcessors.put(columnType.getName(), childProcessor);
    }

    protected void registerValueProcessor(Class<?> columnType, ChildProcessor childProcessor) {
        this.byValueTypeProcessors.put(columnType.getName(), childProcessor);
    }

    protected Optional<Node> defaultProcess(Node parent, Node child, int index) {
        return Optional.empty();
    }

    @Override
    public boolean onChildNodeStart(Node parent, Node child, int index, boolean hasMore) {
        this.byNodeTypeProcessors.getOrDefault((Object)child.getType(), this::defaultProcess).process(parent, child, index).ifPresent(node -> TypeAwareSQLTreeProcessor.replaceChild(parent, index, node));
        return true;
    }

    protected DbAttribute getColumnAttribute(ColumnNode node) {
        DbAttribute attribute = node.getAttribute();
        if (attribute != null && attribute.getType() == 1111 && node.getParent() != null && node.getParent().getType() == NodeType.RESULT) {
            return attribute;
        }
        return null;
    }

    protected ChildProcessor<ColumnNode> getColumnProcessor(DbAttribute attr) {
        String type = TypeAwareSQLTreeProcessor.getObjAttributeFor(attr).map(ObjAttribute::getType).orElse(DEFAULT_TYPE_NAME);
        return this.byColumnTypeProcessors.getOrDefault(type, this::defaultProcess);
    }

    protected DbAttribute getValueAttribute(ValueNode node) {
        DbAttribute attribute = node.getAttribute();
        if (attribute == null) {
            return null;
        }
        if (attribute.getType() == 1111 && node.getParent() != null && (node.getParent().getType() == NodeType.EQUALITY || node.getParent().getType() == NodeType.INSERT_VALUES)) {
            return attribute;
        }
        return null;
    }

    protected ChildProcessor<ValueNode> getValueProcessor(DbAttribute attr) {
        String type = TypeAwareSQLTreeProcessor.getObjAttributeFor(attr).map(ObjAttribute::getType).orElse(DEFAULT_TYPE_NAME);
        return this.byValueTypeProcessors.getOrDefault(type, this::defaultProcess);
    }

    protected static void replaceChild(Node parent, int index, Node newChild) {
        Node oldChild = parent.getChild(index);
        for (int i = 0; i < oldChild.getChildrenCount(); ++i) {
            newChild.addChild(oldChild.getChild(i));
        }
        parent.replaceChild(index, newChild);
    }

    protected static Node wrapInFunction(Node node, String function) {
        FunctionNode functionNode = new FunctionNode(function, null);
        functionNode.addChild(node);
        return functionNode;
    }

    protected static Optional<ObjAttribute> getObjAttributeFor(DbAttribute dbAttribute) {
        if (dbAttribute == null) {
            return Optional.empty();
        }
        DbEntity dbEntity = dbAttribute.getEntity();
        for (ObjEntity objEntity : dbEntity.getDataMap().getObjEntities()) {
            ObjAttribute objAttribute = objEntity.getAttributeForDbAttribute(dbAttribute);
            if (objAttribute == null) continue;
            return Optional.of(objAttribute);
        }
        return Optional.empty();
    }

    private static class DefaultColumnTypeMarker {
        private DefaultColumnTypeMarker() {
        }
    }
}

