/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.exp.parser.SimpleNode;

public class ASTCustomOperator
extends SimpleNode {
    private String operator;

    public ASTCustomOperator(int id) {
        super(id);
    }

    public ASTCustomOperator(String operator) {
        super(36);
        this.operator = operator;
    }

    public ASTCustomOperator(String operator, Object[] nodes) {
        super(36);
        this.operator = operator;
        int len = nodes.length;
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild(this.wrapChild(nodes[i]), i);
        }
        this.connectChildren();
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.operator == null && i == 0) {
            if (!(n instanceof ASTScalar)) {
                throw new IllegalArgumentException("ASTScalar expected, got " + n);
            }
            this.operator = ((ASTScalar)n).getValue().toString();
            return;
        }
        super.jjtAddChild(n, this.operator != null ? i : --i);
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        throw new UnsupportedOperationException("Can't evaluate custom operator in memory");
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        out.append("op(\"").append(this.operator).append("\"");
        if (this.children != null && this.children.length > 0) {
            for (Node child : this.children) {
                out.append(", ");
                if (child == null) {
                    out.append("null");
                    continue;
                }
                ((SimpleNode)child).appendAsString(out);
            }
        }
        out.append(")");
    }

    @Override
    public int getType() {
        return 53;
    }

    public String getOperator() {
        return this.operator;
    }

    @Override
    protected String getExpressionOperator(int index) {
        return this.operator;
    }

    @Override
    public Expression shallowCopy() {
        return new ASTCustomOperator(this.operator);
    }
}

