/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.ProjectTreeFactory;
import org.apache.cayenne.project.Project;

public class ProjectTreeModel
extends DefaultTreeModel {
    private final Filter filter = new Filter();

    public ProjectTreeModel(Project project) {
        super(ProjectTreeFactory.wrapProjectNode(project.getRootNode()));
    }

    public void positionNode(MutableTreeNode parent, DefaultMutableTreeNode treeNode, Comparator<ConfigurationNode> comparator) {
        if (treeNode == null) {
            return;
        }
        if (parent == null && treeNode != this.getRoot() && (parent = (MutableTreeNode)treeNode.getParent()) == null) {
            parent = this.getRootNode();
        }
        ConfigurationNode object = (ConfigurationNode)treeNode.getUserObject();
        if (parent != null) {
            int len = parent.getChildCount();
            int ins = -1;
            int rm = -1;
            for (int i = 0; i < len; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (node == treeNode) {
                    rm = i;
                    continue;
                }
                if (ins >= 0 || comparator.compare(object, (ConfigurationNode)node.getUserObject()) > 0) continue;
                ins = i;
            }
            if (ins < 0) {
                ins = len;
            }
            if (rm == ins) {
                return;
            }
            if (rm >= 0) {
                this.removeNodeFromParent(treeNode);
                if (rm < ins) {
                    --ins;
                }
            }
            try {
                this.insertNodeInto(treeNode, parent, ins);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        parent.insert(newChild, index);
        int[] newIndexs = new int[1];
        if (this.filter.pass((DefaultMutableTreeNode)newChild)) {
            newIndexs[0] = this.getPositionInTreeView(parent, newChild);
            this.nodesWereInserted(parent, newIndexs);
        }
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)super.getRoot();
    }

    public DefaultMutableTreeNode getNodeForObjectPath(Object[] path) {
        if (path == null || path.length == 0) {
            return null;
        }
        DefaultMutableTreeNode currentNode = this.getRootNode();
        int start = 0;
        if (currentNode.getUserObject() == path[0]) {
            start = 1;
        }
        for (int i = start; i < path.length; ++i) {
            DefaultMutableTreeNode foundNode = null;
            Enumeration<TreeNode> children = currentNode.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                if (child.getUserObject() != path[i]) continue;
                foundNode = child;
                break;
            }
            if (foundNode == null) {
                return null;
            }
            currentNode = foundNode;
        }
        return currentNode;
    }

    public void setFiltered(Map<String, Boolean> filterMap) {
        this.filter.setFilterMap(filterMap);
    }

    @Override
    public int getChildCount(Object parent) {
        int filterCount = 0;
        int realCount = super.getChildCount(parent);
        for (int i = 0; i < realCount; ++i) {
            if (!this.filter.pass((DefaultMutableTreeNode)super.getChild(parent, i))) continue;
            ++filterCount;
        }
        return filterCount;
    }

    @Override
    public Object getChild(Object parent, int index) {
        int cnt = -1;
        for (int i = 0; i < super.getChildCount(parent); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)super.getChild(parent, i);
            if (this.filter.pass(child)) {
                ++cnt;
            }
            if (cnt != index) continue;
            return child;
        }
        return null;
    }

    private int getPositionInTreeView(Object parent, Object item) {
        int cnt = -1;
        for (int i = 0; i < super.getChildCount(parent); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)super.getChild(parent, i);
            if (this.filter.pass(child)) {
                ++cnt;
            }
            if (child != item) continue;
            return cnt;
        }
        return cnt;
    }

    @Override
    public void removeNodeFromParent(MutableTreeNode node) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] childIndex = new int[1];
        Object[] removedArray = new Object[1];
        childIndex[0] = this.getPositionInTreeView(parent, node);
        parent.remove(parent.getIndex(node));
        removedArray[0] = node;
        this.nodesWereRemoved(parent, childIndex, removedArray);
    }

    static class Filter {
        private Map<String, Boolean> filterMap;
        boolean pass = true;

        Filter() {
        }

        public void setFilterMap(Map<String, Boolean> filterMap) {
            this.filterMap = filterMap;
            this.pass = false;
        }

        public boolean pass(DefaultMutableTreeNode obj) {
            Object root = obj.getUserObject();
            Object firstLeaf = obj.getFirstLeaf().getUserObject();
            return this.pass || root instanceof DataMap || root instanceof DataNodeDescriptor || firstLeaf instanceof DbEntity && this.filterMap.get("dbEntity") != false || firstLeaf instanceof ObjEntity && this.filterMap.get("objEntity") != false || firstLeaf instanceof Embeddable && this.filterMap.get("embeddable") != false || firstLeaf instanceof QueryDescriptor && this.filterMap.get("query") != false || firstLeaf instanceof Procedure && this.filterMap.get("procedure") != false;
        }
    }
}

