/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph;

import java.io.Serializable;
import java.util.Objects;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.graph.GraphBuilder;

abstract class EntityCellMetadata<E extends Entity<E, A, R>, A extends Attribute<E, A, R>, R extends Relationship<E, A, R>>
implements Serializable {
    final GraphBuilder<E, A, R> builder;
    final String entityName;
    final String label;

    EntityCellMetadata(GraphBuilder<E, A, R> builder, Entity<E, A, R> entity) {
        this.builder = Objects.requireNonNull(builder);
        this.entityName = Objects.requireNonNull(entity).getName();
        this.label = this.createLabel(entity);
    }

    public abstract Entity<E, A, R> fetchEntity();

    public String toString() {
        return this.label;
    }

    String createLabel(Entity<E, A, R> entity) {
        StringBuilder label = new StringBuilder("<html><center><u><b>").append(entity.getName()).append("</b></u></center>");
        for (Attribute attr : entity.getAttributes()) {
            if (!this.isPrimary(attr)) continue;
            label.append("<br><i>").append(attr.getName()).append("</i>");
        }
        for (Attribute attr : entity.getAttributes()) {
            if (this.isPrimary(attr)) continue;
            label.append("<br>").append(attr.getName());
        }
        return label.append("</html>").toString();
    }

    protected abstract boolean isPrimary(A var1);
}

