/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.documentation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.rat.api.Document;
import org.apache.rat.api.RatException;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.document.FileDocument;
import org.apache.rat.documentation.velocity.RatTool;
import org.apache.rat.report.RatReport;
import org.apache.rat.walker.DirectoryWalker;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.apache.velocity.tools.generic.EscapeTool;

public class Exporter {
    public String toString() {
        return "Documentation exporter";
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, RatException {
        String templateDir = args[0];
        String outputDir = args[1];
        File sourceDir = new File(templateDir);
        DocumentName sourceName = DocumentName.builder(sourceDir).build();
        OrFileFilter fileFilter = new OrFileFilter((IOFileFilter)new SuffixFileFilter(".vm"), DirectoryFileFilter.INSTANCE);
        FileDocument document = new FileDocument(sourceName, sourceDir, new DocumentNameMatcher(fileFilter));
        DirectoryWalker walker = new DirectoryWalker(document);
        DocumentName targetDir = DocumentName.builder(new File(outputDir)).build();
        walker.run(new Cleaner(targetDir));
        walker.run(new Rewriter(targetDir));
    }

    private static class Cleaner
    implements RatReport {
        private final DocumentName targetDir;

        Cleaner(DocumentName targetDir) {
            this.targetDir = targetDir;
        }

        @Override
        public void report(Document document) {
            String localized = document.getName().localized();
            DocumentName outputFile = this.targetDir.resolve(localized.substring(0, localized.length() - 3));
            try {
                File file = outputFile.asFile();
                if (file.exists()) {
                    Files.delete(file.toPath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class Rewriter
    implements RatReport {
        private final DocumentName targetDir;
        private final DocumentName rootDir;
        private final VelocityEngine velocityEngine;
        private final VelocityContext context;

        Rewriter(DocumentName targetDir) {
            this.targetDir = targetDir;
            this.rootDir = DocumentName.builder(new File(".")).build();
            this.velocityEngine = new VelocityEngine();
            this.velocityEngine.setProperty("resource.loader", "file");
            this.velocityEngine.setProperty("file.resource.loader.class", FileResourceLoader.class.getName());
            this.velocityEngine.init();
            this.context = new VelocityContext();
            this.context.put("esc", new EscapeTool());
            this.context.put("rat", new RatTool());
        }

        @Override
        public void report(Document document) {
            String localized = document.getName().localized();
            DocumentName outputFile = this.targetDir.resolve(localized.substring(0, localized.length() - 3));
            DocumentName relativeFile = DocumentName.builder(document.getName()).setBaseName(this.rootDir).build();
            try {
                File file = outputFile.asFile();
                if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    throw new IOException("Unable to create directory: " + file.getParentFile());
                }
                Template template = this.velocityEngine.getTemplate(relativeFile.localized());
                try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                    template.merge(this.context, writer);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

