/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.license;

import java.util.Objects;
import java.util.SortedSet;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.SimpleLicense;

public interface ILicense
extends IHeaderMatcher,
Comparable<ILicense> {
    public ILicenseFamily getLicenseFamily();

    public String getNote();

    public String getName();

    default public String getFamilyName() {
        return this.getLicenseFamily().getFamilyName();
    }

    public IHeaderMatcher getMatcher();

    @Override
    default public int compareTo(ILicense other) {
        int result = this.getLicenseFamily().compareTo(other.getLicenseFamily());
        return result == 0 ? this.getId().compareTo(other.getId()) : result;
    }

    public static int hash(ILicense license) {
        return Objects.hash(license.getLicenseFamily(), license.getId());
    }

    public static boolean equals(ILicense license1, Object o) {
        if (license1 == o) {
            return true;
        }
        if (!(o instanceof ILicense)) {
            return false;
        }
        ILicense that = (ILicense)o;
        return license1.compareTo(that) == 0;
    }

    public static Builder builder() {
        return new SimpleLicense.Builder();
    }

    public static interface Builder
    extends IHeaderMatcher.Builder {
        public Builder setMatcher(IHeaderMatcher.Builder var1);

        public Builder setMatcher(IHeaderMatcher var1);

        public Builder setNote(String var1);

        public Builder setId(String var1);

        public Builder setFamily(String var1);

        public Builder setName(String var1);

        public Builder setLicenseFamilies(SortedSet<ILicenseFamily> var1);

        @Override
        public ILicense build();
    }
}

