/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jca.core.resourceadapter.ResourceAdapterInternalException;
import org.apache.cxf.jca.core.resourceadapter.UriHandlerInit;
import org.apache.cxf.jca.cxf.CXFWorkAdapter;
import org.apache.cxf.jca.cxf.ManagedConnectionFactoryImpl;
import org.apache.cxf.jca.servant.EJBEndpoint;
import org.apache.cxf.jca.servant.EJBServantConfig;

public class JCABusFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(JCABusFactory.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JCABusFactory.class);
    private Bus bus;
    private List<Server> servantsCache = new ArrayList<Server>();
    private ClassLoader appserverClassLoader;
    private ManagedConnectionFactoryImpl mcf;
    private Object raBootstrapContext;

    public JCABusFactory(ManagedConnectionFactoryImpl aMcf) {
        this.mcf = aMcf;
    }

    protected synchronized void init() throws ResourceException {
        LOG.info("Initializing the CXF Bus ...");
        new UriHandlerInit();
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            BusFactory bf = BusFactory.newInstance();
            this.bus = bf.createBus();
            this.initializeServants();
        }
        catch (ResourceAdapterInternalException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ResourceAdapterInternalException(new Message("FAIL_TO_INITIALIZE_JCABUSFACTORY", BUNDLE, new Object[0]).toString(), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected void initializeServants() throws ResourceException {
        if (this.isMonitorEJBServicePropertiesEnabled()) {
            LOG.info("Ejb service properties auto-detect enabled. ");
            this.startPropertiesMonitorWorker();
        } else {
            URL propsUrl = this.mcf.getEJBServicePropertiesURLInstance();
            if (propsUrl != null) {
                this.initializeServantsFromProperties(this.loadProperties(propsUrl));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeServantsFromProperties(Properties ejbServants) throws ResourceException {
        this.deregisterServants(this.bus);
        LOG.info("Initializing EJB endpoints from properties file...");
        try {
            Enumeration<Object> keys = ejbServants.keys();
            while (keys.hasMoreElements()) {
                String theJNDIName = (String)keys.nextElement();
                String value = (String)ejbServants.get(theJNDIName);
                EJBServantConfig config = new EJBServantConfig(theJNDIName, value);
                EJBEndpoint ejbEndpoint = new EJBEndpoint(config);
                ejbEndpoint.setEjbServantBaseURL(this.mcf.getEJBServantBaseURL());
                ejbEndpoint.setWorkManager(this.getWorkManager());
                Server servant = ejbEndpoint.publish();
                List<Server> list = this.servantsCache;
                synchronized (list) {
                    if (servant != null) {
                        this.servantsCache.add(servant);
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceException(new Message("FAIL_TO_START_EJB_SERVANTS", BUNDLE, new Object[0]).toString(), (Throwable)e);
        }
    }

    private void startPropertiesMonitorWorker() throws ResourceException {
        Integer pollIntervalInteger = this.mcf.getEJBServicePropertiesPollInterval();
        int pollInterval = pollIntervalInteger;
        LOG.info("Ejb service properties poll interval is: [" + pollInterval + " seconds]");
        EJBServicePropertiesMonitorWorker worker = new EJBServicePropertiesMonitorWorker(pollInterval);
        if (this.getWorkManager() != null) {
            this.getWorkManager().startWork((Work)worker, 60000L, null, (WorkListener)worker);
        } else {
            Thread t = new Thread((Runnable)((Object)worker));
            t.setDaemon(true);
            t.start();
        }
    }

    private boolean isMonitorEJBServicePropertiesEnabled() throws ResourceException {
        boolean retVal = false;
        if (this.mcf.getMonitorEJBServiceProperties().booleanValue()) {
            URL url = this.mcf.getEJBServicePropertiesURLInstance();
            if (url == null) {
                throw new ResourceAdapterInternalException(new Message("EJB_SERVANT_PROPERTIES_IS_NULL", BUNDLE, new Object[0]).toString());
            }
            retVal = this.isFileURL(url);
        }
        return retVal;
    }

    boolean isFileURL(URL url) {
        return url != null && "file".equals(url.getProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterServants(Bus aBus) {
        List<Server> list = this.servantsCache;
        synchronized (list) {
            for (Server servant : this.servantsCache) {
                servant.destroy();
                LOG.info("Shutdown the EJB Endpoint: " + servant.getEndpoint().getEndpointInfo().getName());
            }
            this.servantsCache.clear();
        }
    }

    protected Properties loadProperties(URL propsUrl) throws ResourceException {
        Properties props = new Properties();
        LOG.info("loadProperties, url=" + propsUrl);
        try (InputStream istream = propsUrl.openStream();){
            props.load(istream);
        }
        catch (IOException e) {
            throw new ResourceAdapterInternalException(new Message("FAIL_TO_LOAD_EJB_SERVANT_PROPERTIES", BUNDLE, new Object[]{propsUrl}).toString(), e);
        }
        return props;
    }

    protected List<Server> getRegisteredServants() {
        return this.servantsCache;
    }

    public ClassLoader getAppserverClassLoader() {
        return this.appserverClassLoader;
    }

    public void setAppserverClassLoader(ClassLoader classLoader) {
        this.appserverClassLoader = classLoader;
    }

    public Object getBootstrapContext() {
        return this.raBootstrapContext;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus b) {
        this.bus = b;
    }

    public void create(ClassLoader classLoader, Object context) throws ResourceException {
        this.appserverClassLoader = classLoader;
        this.raBootstrapContext = context;
        this.init();
    }

    protected void setBootstrapContext(Object ctx) {
        this.raBootstrapContext = ctx;
    }

    public WorkManager getWorkManager() {
        if (this.getBootstrapContext() instanceof BootstrapContext) {
            BootstrapContext context = (BootstrapContext)this.getBootstrapContext();
            return context.getWorkManager();
        }
        return null;
    }

    private class EJBServicePropertiesMonitorWorker
    extends CXFWorkAdapter
    implements Work {
        private long previousModificationTime;
        private final int pollIntervalSeconds;
        private final File propsFile;
        private volatile boolean continuing = true;

        EJBServicePropertiesMonitorWorker(int pollInterval) throws ResourceException {
            this.pollIntervalSeconds = pollInterval;
            this.propsFile = new File(JCABusFactory.this.mcf.getEJBServicePropertiesURLInstance().getPath());
        }

        public void run() {
            do {
                try {
                    if (this.isPropertiesFileModified()) {
                        LOG.info("ejbServicePropertiesFile modified, initializing/updating servants");
                        JCABusFactory.this.initializeServantsFromProperties(JCABusFactory.this.loadProperties(this.propsFile.toURI().toURL()));
                    }
                    Thread.sleep((long)this.pollIntervalSeconds * 1000L);
                }
                catch (Exception e) {
                    LOG.info("MonitorThread: failed to initialiseServantsFromProperties with properties absolute path=" + this.propsFile.getAbsolutePath());
                }
            } while (this.continuing);
        }

        public void release() {
            this.continuing = false;
        }

        protected boolean isPropertiesFileModified() {
            long currentModificationTime;
            boolean fileModified = false;
            if (this.propsFile.exists() && (currentModificationTime = this.propsFile.lastModified()) > this.previousModificationTime) {
                this.previousModificationTime = currentModificationTime;
                fileModified = true;
            }
            return fileModified;
        }
    }
}

