/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.spi.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ServiceUtils {
    private ServiceUtils() {
    }

    private static <T> Stream<T> findStreamAmongst(Class<T> clazz, Collection<?> instances) {
        return instances.stream().filter(clazz::isInstance).map(clazz::cast);
    }

    public static <T> Collection<T> findAmongst(Class<T> clazz, Collection<?> instances) {
        return ServiceUtils.findStreamAmongst(clazz, instances).collect(Collectors.toList());
    }

    public static <T> Collection<T> findAmongst(Class<T> clazz, Object ... instances) {
        return ServiceUtils.findAmongst(clazz, Arrays.asList(instances));
    }

    public static <T> T findSingletonAmongst(Class<T> clazz, Collection<?> instances) {
        return ServiceUtils.findOptionalAmongst(clazz, instances).orElse(null);
    }

    public static <T> Optional<T> findOptionalAmongst(Class<T> clazz, Collection<?> instances) {
        return ServiceUtils.findStreamAmongst(clazz, instances).reduce((i1, i2) -> {
            throw new IllegalArgumentException("More than one " + clazz.getName() + " found");
        });
    }

    public static <T> T findSingletonAmongst(Class<T> clazz, Object ... instances) {
        return ServiceUtils.findSingletonAmongst(clazz, Arrays.asList(instances));
    }

    public static <T> Optional<T> findOptionalAmongst(Class<T> clazz, Object ... instances) {
        return ServiceUtils.findOptionalAmongst(clazz, Arrays.asList(instances));
    }
}

