/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.theta.DataToSketchUDAFTest;
import org.apache.datasketches.hive.theta.UnionSketchUDAF;
import org.apache.datasketches.hive.theta.UnionState;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionSketchUDAFTest {
    static final ObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
    static final ObjectInspector longInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG);
    static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", "seed", "sketch"), Arrays.asList(intInspector, longInspector, binaryInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void initTooFewArgs() throws SemanticException {
        UnionSketchUDAF udf = new UnionSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[0], false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void initTooManyArgs() throws SemanticException {
        UnionSketchUDAF udf = new UnionSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{binaryInspector, intInspector, longInspector, longInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initIvalidCategoryArg1() throws SemanticException {
        UnionSketchUDAF udf = new UnionSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{structInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initInvalidTypeArg1() throws SemanticException {
        UnionSketchUDAF udf = new UnionSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{intInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initIvalidCategoryArg2() throws SemanticException {
        UnionSketchUDAF udf = new UnionSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{binaryInspector, structInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initInvalidTypeArg2() throws SemanticException {
        UnionSketchUDAF udf = new UnionSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{binaryInspector, binaryInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initIvalidCategoryArg3() throws SemanticException {
        UnionSketchUDAF udf = new UnionSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{binaryInspector, intInspector, structInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initInvalidTypeArg3() throws SemanticException {
        UnionSketchUDAF udf = new UnionSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{binaryInspector, intInspector, binaryInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test
    public void partial1ModeDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            UnionState state = (UnionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().build();
            sketch1.update(1L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray())});
            UpdateSketch sketch2 = UpdateSketch.builder().build();
            sketch2.update(2L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray())});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)4096);
            Assert.assertEquals((long)((LongWritable)r.get(1)).get(), (long)9001L);
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))));
            Assert.assertFalse((boolean)resultSketch.isEstimationMode());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void partial1ModeExplicitParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, longInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            int nomEntries = 16;
            long seed = 1L;
            UnionState state = (UnionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().setSeed(1L).build();
            sketch1.update(1L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray()), new IntWritable(16), new LongWritable(1L)});
            UpdateSketch sketch2 = UpdateSketch.builder().setSeed(1L).build();
            sketch2.update(2L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray()), new IntWritable(16), new LongWritable(1L)});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)16);
            Assert.assertEquals((long)((LongWritable)r.get(1)).get(), (long)1L);
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))), (long)1L);
            Assert.assertFalse((boolean)resultSketch.isEstimationMode());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void partial2Mode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, new ObjectInspector[]{structInspector});
            DataToSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            UnionState state = (UnionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().build();
            sketch1.update(1L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new LongWritable(9001L), new BytesWritable(sketch1.compact().toByteArray())));
            UpdateSketch sketch2 = UpdateSketch.builder().build();
            sketch2.update(2L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new LongWritable(9001L), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)4096);
            Assert.assertEquals((long)((LongWritable)r.get(1)).get(), (long)9001L);
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void finalMode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{structInspector});
            DataToSketchUDAFTest.checkFinalResultInspector(resultInspector);
            UnionState state = (UnionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().build();
            sketch1.update(1L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new LongWritable(9001L), new BytesWritable(sketch1.compact().toByteArray())));
            UpdateSketch sketch2 = UpdateSketch.builder().build();
            sketch2.update(2L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new LongWritable(9001L), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void completeModeDefaultSizeAndSeed() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToSketchUDAFTest.checkFinalResultInspector(resultInspector);
            UnionState state = (UnionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().build();
            sketch1.update(1L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray())});
            UpdateSketch sketch2 = UpdateSketch.builder().build();
            sketch2.update(2L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray())});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void completeModeExplicitSizeAndSeed() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, longInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToSketchUDAFTest.checkFinalResultInspector(resultInspector);
            int nomEntries = 16;
            long seed = 1L;
            UnionState state = (UnionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().setSeed(1L).build();
            sketch1.update(1L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray()), new IntWritable(16), new LongWritable(1L)});
            UpdateSketch sketch2 = UpdateSketch.builder().setSeed(1L).build();
            sketch2.update(2L);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray()), new IntWritable(16), new LongWritable(1L)});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)), (long)1L);
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }
}

