/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import java.util.Arrays;
import org.apache.datasketches.hive.theta.ObjectInspectorValidator;
import org.apache.datasketches.hive.theta.UnionEvaluator;
import org.apache.datasketches.hive.theta.UnionState;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="unionSketch", value="_FUNC_(sketch, size, seed) - Compute the union of sketches of given size and seed", extended="Example:\n> SELECT UnionSketch(sketch, 16384) FROM src;\nThe return value is a binary blob that contains a compact sketch, which can be operated on by the other sketch-related functions. The optional size must be a power of 2, and controls the relative error of the expected result. A size of 16384 can be expected to yeild errors of roughly +-1.5% in the estimation of uniques with 95% confidence. The default size is defined in the sketches-core library and at the time of this writing was 4096 (about 3% error). The seed is optional, and using it is not recommended unless you really know why you need it")
public class UnionSketchUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] parameters = info.getParameterObjectInspectors();
        if (parameters.length < 1) {
            throw new UDFArgumentException("Please specify at least 1 argument");
        }
        if (parameters.length > 3) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Please specify no more than 3 arguments");
        }
        ObjectInspectorValidator.validateGivenPrimitiveCategory(parameters[0], 0, PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        if (parameters.length > 1) {
            ObjectInspectorValidator.validateIntegralParameter(parameters[1], 1);
        }
        if (parameters.length > 2) {
            ObjectInspectorValidator.validateIntegralParameter(parameters[2], 2);
        }
        return new UnionSketchUDAFEvaluator();
    }

    public static class UnionSketchUDAFEvaluator
    extends UnionEvaluator {
        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
            super.init(mode, parameters);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputObjectInspector = (PrimitiveObjectInspector)parameters[0];
                if (parameters.length > 1) {
                    this.nominalEntriesObjectInspector = (PrimitiveObjectInspector)parameters[1];
                }
                if (parameters.length > 2) {
                    this.seedObjectInspector = (PrimitiveObjectInspector)parameters[2];
                }
            } else {
                this.intermediateObjectInspector = (StandardStructObjectInspector)parameters[0];
            }
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", "seed", "sketch"), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY)));
            }
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            byte[] serializedSketch;
            if (parameters[0] == null) {
                return;
            }
            UnionState state = (UnionState)agg;
            if (!state.isInitialized()) {
                this.initializeState(state, parameters);
            }
            if ((serializedSketch = (byte[])this.inputObjectInspector.getPrimitiveJavaObject(parameters[0])) == null) {
                return;
            }
            state.update(Memory.wrap((byte[])serializedSketch));
        }

        private void initializeState(UnionState state, Object[] parameters) {
            int nominalEntries = 4096;
            if (this.nominalEntriesObjectInspector != null) {
                nominalEntries = PrimitiveObjectInspectorUtils.getInt((Object)parameters[1], (PrimitiveObjectInspector)this.nominalEntriesObjectInspector);
            }
            long seed = 9001L;
            if (this.seedObjectInspector != null) {
                seed = PrimitiveObjectInspectorUtils.getLong((Object)parameters[2], (PrimitiveObjectInspector)this.seedObjectInspector);
            }
            state.init(nominalEntries, seed);
        }
    }
}

