/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import jdk.incubator.foreign.ResourceScope;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CommonBufferTest {
    private final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;

    @Test
    public void checkSetGet() throws Exception {
        int memCapacity = 60;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.memReqSvr);
            WritableBuffer buf = mem.asWritableBuffer();
            Assert.assertEquals((long)buf.getCapacity(), (long)memCapacity);
            CommonBufferTest.setGetTests(buf);
            CommonBufferTest.setGetTests2(buf);
        }
    }

    public static void setGetTests(WritableBuffer buf) {
        buf.putBoolean(true);
        buf.putBoolean(false);
        buf.putByte((byte)-1);
        buf.putByte((byte)0);
        buf.putChar('A');
        buf.putChar('Z');
        buf.putShort((short)Short.MAX_VALUE);
        buf.putShort((short)Short.MIN_VALUE);
        buf.putInt(Integer.MAX_VALUE);
        buf.putInt(Integer.MIN_VALUE);
        buf.putFloat(Float.MAX_VALUE);
        buf.putFloat(Float.MIN_VALUE);
        buf.putLong(Long.MAX_VALUE);
        buf.putLong(Long.MIN_VALUE);
        buf.putDouble(Double.MAX_VALUE);
        buf.putDouble(Double.MIN_VALUE);
        buf.resetPosition();
        Assert.assertEquals((boolean)buf.getBoolean(buf.getPosition()), (boolean)true);
        Assert.assertEquals((boolean)buf.getBoolean(), (boolean)true);
        Assert.assertEquals((boolean)buf.getBoolean(buf.getPosition()), (boolean)false);
        Assert.assertEquals((boolean)buf.getBoolean(), (boolean)false);
        Assert.assertEquals((byte)buf.getByte(buf.getPosition()), (byte)-1);
        Assert.assertEquals((byte)buf.getByte(), (byte)-1);
        Assert.assertEquals((byte)buf.getByte(buf.getPosition()), (byte)0);
        Assert.assertEquals((byte)buf.getByte(), (byte)0);
        Assert.assertEquals((char)buf.getChar(buf.getPosition()), (char)'A');
        Assert.assertEquals((char)buf.getChar(), (char)'A');
        Assert.assertEquals((char)buf.getChar(buf.getPosition()), (char)'Z');
        Assert.assertEquals((char)buf.getChar(), (char)'Z');
        Assert.assertEquals((short)buf.getShort(buf.getPosition()), (short)Short.MAX_VALUE);
        Assert.assertEquals((short)buf.getShort(), (short)Short.MAX_VALUE);
        Assert.assertEquals((short)buf.getShort(buf.getPosition()), (short)Short.MIN_VALUE);
        Assert.assertEquals((short)buf.getShort(), (short)Short.MIN_VALUE);
        Assert.assertEquals((int)buf.getInt(buf.getPosition()), (int)Integer.MAX_VALUE);
        Assert.assertEquals((int)buf.getInt(), (int)Integer.MAX_VALUE);
        Assert.assertEquals((int)buf.getInt(buf.getPosition()), (int)Integer.MIN_VALUE);
        Assert.assertEquals((int)buf.getInt(), (int)Integer.MIN_VALUE);
        Assert.assertEquals((float)buf.getFloat(buf.getPosition()), (float)Float.MAX_VALUE);
        Assert.assertEquals((float)buf.getFloat(), (float)Float.MAX_VALUE);
        Assert.assertEquals((float)buf.getFloat(buf.getPosition()), (float)Float.MIN_VALUE);
        Assert.assertEquals((float)buf.getFloat(), (float)Float.MIN_VALUE);
        Assert.assertEquals((long)buf.getLong(buf.getPosition()), (long)Long.MAX_VALUE);
        Assert.assertEquals((long)buf.getLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((long)buf.getLong(buf.getPosition()), (long)Long.MIN_VALUE);
        Assert.assertEquals((long)buf.getLong(), (long)Long.MIN_VALUE);
        Assert.assertEquals((double)buf.getDouble(buf.getPosition()), (double)Double.MAX_VALUE);
        Assert.assertEquals((double)buf.getDouble(), (double)Double.MAX_VALUE);
        Assert.assertEquals((double)buf.getDouble(buf.getPosition()), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)buf.getDouble(), (double)Double.MIN_VALUE);
    }

    public static void setGetTests2(WritableBuffer buf) {
        buf.putBoolean(0L, true);
        buf.putBoolean(1L, false);
        buf.putByte(2L, (byte)-1);
        buf.putByte(3L, (byte)0);
        buf.putChar(4L, 'A');
        buf.putChar(6L, 'Z');
        buf.putShort(8L, (short)Short.MAX_VALUE);
        buf.putShort(10L, (short)Short.MIN_VALUE);
        buf.putInt(12L, Integer.MAX_VALUE);
        buf.putInt(16L, Integer.MIN_VALUE);
        buf.putFloat(20L, Float.MAX_VALUE);
        buf.putFloat(24L, Float.MIN_VALUE);
        buf.putLong(28L, Long.MAX_VALUE);
        buf.putLong(36L, Long.MIN_VALUE);
        buf.putDouble(44L, Double.MAX_VALUE);
        buf.putDouble(52L, Double.MIN_VALUE);
        Assert.assertEquals((boolean)buf.getBoolean(0L), (boolean)true);
        Assert.assertEquals((boolean)buf.getBoolean(1L), (boolean)false);
        Assert.assertEquals((byte)buf.getByte(2L), (byte)-1);
        Assert.assertEquals((byte)buf.getByte(3L), (byte)0);
        Assert.assertEquals((char)buf.getChar(4L), (char)'A');
        Assert.assertEquals((char)buf.getChar(6L), (char)'Z');
        Assert.assertEquals((short)buf.getShort(8L), (short)Short.MAX_VALUE);
        Assert.assertEquals((short)buf.getShort(10L), (short)Short.MIN_VALUE);
        Assert.assertEquals((int)buf.getInt(12L), (int)Integer.MAX_VALUE);
        Assert.assertEquals((int)buf.getInt(16L), (int)Integer.MIN_VALUE);
        Assert.assertEquals((float)buf.getFloat(20L), (float)Float.MAX_VALUE);
        Assert.assertEquals((float)buf.getFloat(24L), (float)Float.MIN_VALUE);
        Assert.assertEquals((long)buf.getLong(28L), (long)Long.MAX_VALUE);
        Assert.assertEquals((long)buf.getLong(36L), (long)Long.MIN_VALUE);
        Assert.assertEquals((double)buf.getDouble(44L), (double)Double.MAX_VALUE);
        Assert.assertEquals((double)buf.getDouble(52L), (double)Double.MIN_VALUE);
    }

    @Test
    public void checkSetGetArrays() throws Exception {
        int memCapacity = 32;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.memReqSvr);
            WritableBuffer buf = mem.asWritableBuffer();
            Assert.assertEquals((long)buf.getCapacity(), (long)memCapacity);
            CommonBufferTest.setGetArraysTests(buf);
        }
    }

    public static void setGetArraysTests(WritableBuffer buf) {
        int words = 4;
        byte[] srcArray2 = new byte[]{1, -2, 3, -4};
        byte[] dstArray2 = new byte[4];
        buf.resetPosition();
        buf.putByteArray(srcArray2, 0, words);
        buf.resetPosition();
        buf.getByteArray(dstArray2, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((byte)dstArray2[i], (byte)srcArray2[i]);
        }
        char[] srcArray3 = new char[]{'A', 'B', 'C', 'D'};
        char[] dstArray3 = new char[words];
        buf.resetPosition();
        buf.putCharArray(srcArray3, 0, words);
        buf.resetPosition();
        buf.getCharArray(dstArray3, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((char)dstArray3[i], (char)srcArray3[i]);
        }
        double[] srcArray4 = new double[]{1.0, -2.0, 3.0, -4.0};
        double[] dstArray4 = new double[words];
        buf.resetPosition();
        buf.putDoubleArray(srcArray4, 0, words);
        buf.resetPosition();
        buf.getDoubleArray(dstArray4, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((double)dstArray4[i], (double)srcArray4[i], (double)0.0);
        }
        float[] srcArray5 = new float[]{1.0f, -2.0f, 3.0f, -4.0f};
        float[] dstArray5 = new float[words];
        buf.resetPosition();
        buf.putFloatArray(srcArray5, 0, words);
        buf.resetPosition();
        buf.getFloatArray(dstArray5, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((double)dstArray5[i], (double)srcArray5[i], (double)0.0);
        }
        int[] srcArray6 = new int[]{1, -2, 3, -4};
        int[] dstArray6 = new int[words];
        buf.resetPosition();
        buf.putIntArray(srcArray6, 0, words);
        buf.resetPosition();
        buf.getIntArray(dstArray6, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((int)dstArray6[i], (int)srcArray6[i]);
        }
        long[] srcArray7 = new long[]{1L, -2L, 3L, -4L};
        long[] dstArray7 = new long[words];
        buf.resetPosition();
        buf.putLongArray(srcArray7, 0, words);
        buf.resetPosition();
        buf.getLongArray(dstArray7, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((long)dstArray7[i], (long)srcArray7[i]);
        }
        short[] srcArray8 = new short[]{1, -2, 3, -4};
        short[] dstArray8 = new short[words];
        buf.resetPosition();
        buf.putShortArray(srcArray8, 0, words);
        buf.resetPosition();
        buf.getShortArray(dstArray8, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((short)dstArray8[i], (short)srcArray8[i]);
        }
    }

    @Test
    public void checkSetGetPartialArraysWithOffset() throws Exception {
        int memCapacity = 32;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.memReqSvr);
            WritableBuffer buf = mem.asWritableBuffer();
            Assert.assertEquals((long)buf.getCapacity(), (long)memCapacity);
            CommonBufferTest.setGetPartialArraysWithOffsetTests(buf);
        }
    }

    public static void setGetPartialArraysWithOffsetTests(WritableBuffer buf) {
        int items = 4;
        byte[] srcArray2 = new byte[]{1, -2, 3, -4};
        byte[] dstArray2 = new byte[items];
        buf.resetPosition();
        buf.putByteArray(srcArray2, 2, items / 2);
        buf.resetPosition();
        buf.getByteArray(dstArray2, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((byte)dstArray2[i], (byte)srcArray2[i]);
        }
        char[] srcArray3 = new char[]{'A', 'B', 'C', 'D'};
        char[] dstArray3 = new char[items];
        buf.resetPosition();
        buf.putCharArray(srcArray3, 2, items / 2);
        buf.resetPosition();
        buf.getCharArray(dstArray3, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((char)dstArray3[i], (char)srcArray3[i]);
        }
        double[] srcArray4 = new double[]{1.0, -2.0, 3.0, -4.0};
        double[] dstArray4 = new double[items];
        buf.resetPosition();
        buf.putDoubleArray(srcArray4, 2, items / 2);
        buf.resetPosition();
        buf.getDoubleArray(dstArray4, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((double)dstArray4[i], (double)srcArray4[i], (double)0.0);
        }
        float[] srcArray5 = new float[]{1.0f, -2.0f, 3.0f, -4.0f};
        float[] dstArray5 = new float[items];
        buf.resetPosition();
        buf.putFloatArray(srcArray5, 2, items / 2);
        buf.resetPosition();
        buf.getFloatArray(dstArray5, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((double)dstArray5[i], (double)srcArray5[i], (double)0.0);
        }
        int[] srcArray6 = new int[]{1, -2, 3, -4};
        int[] dstArray6 = new int[items];
        buf.resetPosition();
        buf.putIntArray(srcArray6, 2, items / 2);
        buf.resetPosition();
        buf.getIntArray(dstArray6, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((int)dstArray6[i], (int)srcArray6[i]);
        }
        long[] srcArray7 = new long[]{1L, -2L, 3L, -4L};
        long[] dstArray7 = new long[items];
        buf.resetPosition();
        buf.putLongArray(srcArray7, 2, items / 2);
        buf.resetPosition();
        buf.getLongArray(dstArray7, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((long)dstArray7[i], (long)srcArray7[i]);
        }
        short[] srcArray8 = new short[]{1, -2, 3, -4};
        short[] dstArray8 = new short[items];
        buf.resetPosition();
        buf.putShortArray(srcArray8, 2, items / 2);
        buf.resetPosition();
        buf.getShortArray(dstArray8, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((short)dstArray8[i], (short)srcArray8[i]);
        }
    }

    @Test
    public void checkSetClearMemoryRegions() throws Exception {
        int memCapacity = 64;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.memReqSvr);
            WritableBuffer buf = mem.asWritableBuffer();
            Assert.assertEquals((long)buf.getCapacity(), (long)memCapacity);
            CommonBufferTest.setClearMemoryRegionsTests(buf);
            buf.resetPosition();
            for (int i = 0; i < memCapacity; ++i) {
                Assert.assertEquals((int)mem.getByte((long)i), (int)0);
            }
        }
    }

    public static void setClearMemoryRegionsTests(WritableBuffer buf) {
        int i;
        int i2;
        int accessCapacity = (int)buf.getCapacity();
        int reg1Start = 0;
        int reg1Len = 28;
        int reg2Start = 28;
        int reg2Len = 32;
        byte b1 = 5;
        buf.setStartPositionEnd((long)reg1Start, (long)reg1Start, (long)reg1Len);
        buf.fill(b1);
        buf.resetPosition();
        for (int i3 = reg1Start; i3 < reg1Len + reg1Start; ++i3) {
            Assert.assertEquals((byte)buf.getByte(), (byte)b1);
        }
        byte b2 = 7;
        buf.setStartPositionEnd((long)reg2Start, (long)reg2Start, (long)(reg2Start + reg2Len));
        buf.fill(b2);
        buf.resetPosition();
        for (int i4 = reg2Start; i4 < reg2Start + reg2Len; ++i4) {
            Assert.assertEquals((byte)buf.getByte(), (byte)b2);
        }
        byte zeroByte = 0;
        buf.setStartPositionEnd((long)reg1Start, (long)reg1Start, (long)reg2Len);
        buf.resetPosition();
        buf.clear();
        buf.resetPosition();
        for (i2 = reg1Start; i2 < reg1Start + reg1Len; ++i2) {
            Assert.assertEquals((byte)buf.getByte(), (byte)zeroByte);
        }
        buf.setStartPositionEnd((long)reg2Start, (long)reg2Start, (long)(reg2Start + reg2Len));
        buf.resetPosition();
        buf.clear();
        buf.resetPosition();
        for (i2 = reg2Start; i2 < reg2Len + reg2Start; ++i2) {
            Assert.assertEquals((byte)buf.getByte(), (byte)zeroByte);
        }
        buf.setStartPositionEnd((long)reg1Start, (long)reg1Start, (long)accessCapacity);
        byte b4 = 127;
        buf.resetPosition();
        buf.fill(b4);
        buf.resetPosition();
        for (i = 0; i < accessCapacity; ++i) {
            Assert.assertEquals((byte)buf.getByte(), (byte)b4);
        }
        buf.resetPosition();
        buf.clear();
        buf.resetPosition();
        for (i = 0; i < accessCapacity; ++i) {
            Assert.assertEquals((byte)buf.getByte(), (byte)zeroByte);
        }
    }

    @Test
    public void checkToHexStringAllMem() throws Exception {
        int memCapacity = 48;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.memReqSvr);
            WritableBuffer buf = mem.asWritableBuffer();
            Assert.assertEquals((long)buf.getCapacity(), (long)memCapacity);
            CommonBufferTest.toHexStringAllMemTests(buf);
        }
    }

    public static void toHexStringAllMemTests(WritableBuffer buf) {
        int memCapacity = (int)buf.getCapacity();
        for (int i = 0; i < memCapacity; ++i) {
            buf.putByte((byte)i);
        }
    }

    @Test
    public void printlnTest() {
        CommonBufferTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

