/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class WritableMemoryTest {
    @Test
    public void wrapBigEndian() {
        ByteBuffer bb = ByteBuffer.allocate(64);
        WritableMemory wmem = WritableMemory.writableWrap((ByteBuffer)bb);
        Assert.assertEquals((Object)wmem.getTypeByteOrder(), (Object)ByteOrder.BIG_ENDIAN);
        wmem = WritableMemory.writableWrap((ByteBuffer)bb, (ByteOrder)ByteOrder.LITTLE_ENDIAN, null);
        Assert.assertEquals((Object)wmem.getTypeByteOrder(), (Object)ByteOrder.LITTLE_ENDIAN);
    }

    @Test
    public void wrapBigEndianAsLittle() {
        ByteBuffer bb = ByteBuffer.allocate(64);
        bb.putChar(0, '\u0001');
        WritableMemory wmem = WritableMemory.writableWrap((ByteBuffer)bb, (ByteOrder)ByteOrder.LITTLE_ENDIAN, null);
        Assert.assertEquals((int)wmem.getChar(0L), (int)256);
    }

    @Test
    public void allocateWithByteOrder() {
        WritableMemory wmem = WritableMemory.allocate((int)64, (ByteOrder)ByteOrder.BIG_ENDIAN);
        Assert.assertEquals((Object)wmem.getTypeByteOrder(), (Object)ByteOrder.BIG_ENDIAN);
        wmem = WritableMemory.allocate((int)64, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((Object)wmem.getTypeByteOrder(), (Object)ByteOrder.LITTLE_ENDIAN);
        wmem = WritableMemory.writableWrap((byte[])new byte[64], (int)32, (int)32, (ByteOrder)ByteOrder.BIG_ENDIAN);
        Assert.assertEquals((Object)wmem.getTypeByteOrder(), (Object)ByteOrder.BIG_ENDIAN);
    }

    @Test
    public void checkSelfArrayCopy() {
        byte[] srcAndDst = new byte[128];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])srcAndDst);
        wmem.getByteArray(0L, srcAndDst, 64, 64);
    }

    @Test
    public void checkEquals() {
        int i;
        int len = 7;
        WritableMemory wmem1 = WritableMemory.allocate((int)len);
        WritableMemory wmem2 = WritableMemory.allocate((int)(len + 1));
        Assert.assertFalse((boolean)wmem1.equals(wmem2));
        WritableMemory reg1 = wmem1.writableRegion(0L, wmem1.getCapacity());
        Assert.assertTrue((boolean)wmem1.equalTo(0L, (Resource)reg1, 0L, wmem1.getCapacity()));
        wmem2 = WritableMemory.allocate((int)len);
        for (i = 0; i < len; ++i) {
            wmem1.putByte((long)i, (byte)i);
            wmem2.putByte((long)i, (byte)i);
        }
        Assert.assertTrue((boolean)wmem1.equalTo(0L, (Resource)wmem2, 0L, (long)len));
        Assert.assertTrue((boolean)wmem1.equalTo(0L, (Resource)wmem1, 0L, (long)len));
        reg1 = wmem1.writableRegion(0L, wmem1.getCapacity());
        Assert.assertTrue((boolean)wmem1.equalTo(0L, (Resource)reg1, 0L, (long)len));
        len = 24;
        wmem1 = WritableMemory.allocate((int)len);
        wmem2 = WritableMemory.allocate((int)len);
        for (i = 0; i < len; ++i) {
            wmem1.putByte((long)i, (byte)i);
            wmem2.putByte((long)i, (byte)i);
        }
        Assert.assertTrue((boolean)wmem1.equalTo(0L, (Resource)wmem2, 0L, (long)(len - 1)));
        Assert.assertTrue((boolean)wmem1.equalTo(0L, (Resource)wmem2, 0L, (long)len));
        wmem2.putByte(0L, (byte)10);
        Assert.assertFalse((boolean)wmem1.equalTo(0L, (Resource)wmem2, 0L, (long)len));
        wmem2.putByte(0L, (byte)0);
        wmem2.putByte((long)(len - 2), (byte)0);
        Assert.assertFalse((boolean)wmem1.equalTo(0L, (Resource)wmem2, 0L, (long)(len - 1)));
    }

    @Test
    public void checkEquals2() {
        int len = 23;
        WritableMemory wmem1 = WritableMemory.allocate((int)len);
        Assert.assertFalse((boolean)wmem1.equals(null));
        WritableMemory wmem2 = WritableMemory.allocate((int)(len + 1));
        Assert.assertTrue((boolean)wmem1.equalTo(0L, (Resource)wmem2, 0L, (long)len));
        for (int i = 0; i < len; ++i) {
            wmem1.putByte((long)i, (byte)i);
            wmem2.putByte((long)i, (byte)i);
        }
        Assert.assertTrue((boolean)wmem1.equalTo(0L, (Resource)wmem2, 0L, (long)len));
        Assert.assertTrue((boolean)wmem1.equalTo(1L, (Resource)wmem2, 1L, (long)(len - 1)));
    }

    @Test
    public void checkLargeEquals() {
        int thresh = 0x100000;
        int len = 0x200007;
        byte[] byteArr1 = new byte[0x200007];
        ThreadLocalRandom.current().nextBytes(byteArr1);
        byte[] byteArr2 = (byte[])byteArr1.clone();
        Memory mem1 = Memory.wrap((byte[])byteArr1);
        Memory mem2 = Memory.wrap((byte[])byteArr2);
        Assert.assertTrue((boolean)mem1.equalTo(0L, (Resource)mem2, 0L, 0x200007L));
        byteArr2[0x10000A] = (byte)(byteArr1[0x10000A] + 1);
        Assert.assertFalse((boolean)mem1.equalTo(0L, (Resource)mem2, 0L, 0x200007L));
        byteArr2[0x10000A] = byteArr1[0x10000A];
        byteArr2[0x200003] = (byte)(byteArr1[0x200003] + 1);
        Assert.assertFalse((boolean)mem1.equalTo(0L, (Resource)mem2, 0L, 0x200007L));
    }

    @Test
    public void checkWrapWithBO() {
        WritableMemory wmem = WritableMemory.writableWrap((byte[])new byte[0], (ByteOrder)ByteOrder.BIG_ENDIAN);
        boolean nativeBO = wmem.getTypeByteOrder() == ByteOrder.nativeOrder();
        Assert.assertFalse((boolean)nativeBO);
        WritableMemoryTest.println("" + nativeBO);
        wmem = WritableMemory.writableWrap((byte[])new byte[8], (ByteOrder)ByteOrder.BIG_ENDIAN);
        nativeBO = wmem.getTypeByteOrder() == ByteOrder.nativeOrder();
        Assert.assertFalse((boolean)nativeBO);
        WritableMemoryTest.println("" + nativeBO);
    }

    @Test
    public void checkOwnerClientCase() {
        WritableMemory owner;
        WritableMemory client1 = owner = WritableMemory.allocate((int)64);
        owner.putInt(0L, 1);
        client1.putInt(0L, 2);
        Memory client2 = owner.region(0L, owner.getCapacity());
        owner.putInt(0L, 3);
    }

    @Test
    public void printlnTest() {
        WritableMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

