/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DynamicLikeOptimizationTest
extends BaseJDBCTestCase {
    private static final Object[][] CEI_ROWS = new Object[][]{{0, "Alarms", "AlarmDisk999"}, {1, "Alarms", "AlarmFS-usr"}, {2, "Alarms", "AlarmPower"}, {3, "Alert", "AlertBattery"}, {4, "Alert", "AlertUPS"}, {5, "Warning", "WarnIntrusion"}, {6, "Warning", "WarnUnlockDoor"}, {7, "Warning", "Warn%Unlock%Door"}, {8, "Warning", "W_Unlock_Door"}};

    public DynamicLikeOptimizationTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DynamicLikeOptimizationTest");
        baseTestSuite.addTestSuite(DynamicLikeOptimizationTest.class);
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)new BaseTestSuite(DynamicLikeOptimizationTest.class)));
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                int n;
                statement.executeUpdate("create table t1(c11 int)");
                statement.executeUpdate("insert into t1 values 1");
                statement.executeUpdate("create table test(id char(10), c10 char(10), vc10 varchar(10))");
                PreparedStatement preparedStatement = this.getConnection().prepareStatement("insert into test values (?,?,?)");
                String[] stringArray = new String[]{"asdf", "asdg", "aasdf", "%foobar", "foo%bar", "foo_bar"};
                for (int i = 0; i < stringArray.length; ++i) {
                    for (n = 1; n <= 3; ++n) {
                        preparedStatement.setString(n, stringArray[i]);
                    }
                    preparedStatement.executeUpdate();
                }
                preparedStatement.setString(1, "V-NULL");
                preparedStatement.setString(2, null);
                preparedStatement.setString(3, null);
                preparedStatement.executeUpdate();
                preparedStatement.setString(1, "MAX_CHAR");
                preparedStatement.setString(2, "\ufa2d");
                preparedStatement.setString(3, "\ufa2d");
                preparedStatement.executeUpdate();
                preparedStatement.close();
                statement.executeUpdate("create table likeable(match_me varchar(10), pattern varchar(10), esc varchar(1))");
                statement.executeUpdate("insert into likeable values ('foo%bar', 'fooZ%bar', 'Z'), ('foo%bar', '%Z%ba_', 'Z'),('foo%bar', 'fooZ%baZ', 'Z')");
                statement.executeUpdate("create table cei(id int, name varchar(192) not null, source varchar(252) not null)");
                PreparedStatement preparedStatement2 = this.getConnection().prepareStatement("insert into cei values (?,?,?)");
                for (n = 0; n < CEI_ROWS.length; ++n) {
                    for (int i = 0; i < CEI_ROWS[n].length; ++i) {
                        preparedStatement2.setObject(i + 1, CEI_ROWS[n][i]);
                    }
                    preparedStatement2.executeUpdate();
                }
                preparedStatement2.close();
            }
        };
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    public void testSimpleLikePredicates() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select 1 from t1 where 'asdf' like ?");
        String[] stringArray = new String[]{"%", "%f", "asd%", "_%", "%_", "%asdf"};
        for (int i = 0; i < stringArray.length; ++i) {
            preparedStatement.setString(1, stringArray[i]);
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        }
        String[] stringArray2 = new String[]{"", "%g", "_asdf", null};
        for (int i = 0; i < stringArray2.length; ++i) {
            preparedStatement.setObject(1, (Object)stringArray2[i], 12);
            JDBC.assertEmpty(preparedStatement.executeQuery());
        }
        preparedStatement.close();
    }

    public void testEscapeSyntax() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select 1 from t1 where '%foobar' like 'Z%foobar' escape ?");
        preparedStatement.setString(1, "Z");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        String[][] stringArrayArray = new String[][]{{"raZ", "22019"}, {"", "22019"}, {null, "22501"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            preparedStatement.setObject(1, (Object)stringArrayArray[i][0], 12);
            try {
                preparedStatement.executeQuery();
                DynamicLikeOptimizationTest.fail();
                continue;
            }
            catch (SQLException sQLException) {
                DynamicLikeOptimizationTest.assertSQLState(stringArrayArray[i][1], sQLException);
            }
        }
        preparedStatement.setString(1, "%");
        JDBC.assertEmpty(preparedStatement.executeQuery());
        preparedStatement.close();
    }

    public void testWildcardAsEscape() throws SQLException {
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select 1 from t1 where '%foobar' like '%%foobar' escape '%'"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select 1 from t1 where '_foobar' like '__foobar' escape '_'"), "1");
        statement.close();
    }

    public void testEscapeSyntax2() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select 1 from t1 where '%foobar' like ? escape ?");
        preparedStatement.setString(1, "Z%foobar");
        preparedStatement.setString(2, "Z");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        preparedStatement.setString(2, "");
        try {
            preparedStatement.executeQuery();
            DynamicLikeOptimizationTest.fail();
        }
        catch (SQLException sQLException) {
            DynamicLikeOptimizationTest.assertSQLState("22019", sQLException);
        }
        preparedStatement.close();
    }

    public void testEscapeSyntax3() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select 1 from t1 where '%foobar' like ? escape 'Z'");
        preparedStatement.setString(1, "x%foobar");
        JDBC.assertEmpty(preparedStatement.executeQuery());
        preparedStatement.setString(1, "Z%foobar");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        preparedStatement.close();
    }

    public void testEscapeSyntax4() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select 1 from t1 where '%foobar' like ? escape '$'");
        preparedStatement.setString(1, "$%f%bar");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        preparedStatement.close();
    }

    public void testEscapeSyntax5() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select 1 from t1 where 'Z%foobar' like ? escape 'Z'");
        preparedStatement.setString(1, "ZZZ%foo%a_");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        preparedStatement.close();
    }

    public void testLikeWithHighestValidCharacter() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select 1 from t1 where '\ufa2d' like ?");
        String[] stringArray = new String[]{"%", "_", "\ufa2d"};
        for (int i = 0; i < stringArray.length; ++i) {
            preparedStatement.setString(1, stringArray[i]);
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        }
        preparedStatement.setString(1, "");
        JDBC.assertEmpty(preparedStatement.executeQuery());
        preparedStatement.close();
    }

    public void testGeneratedPredicatesCHAR() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select id from test where c10 like ?");
        String[][][] stringArray = new String[][][]{new String[0][], new String[0][], new String[0][], {{"MAX_CHAR"}, {"asdf"}, {"asdg"}, {"aasdf"}, {"%foobar"}, {"foo%bar"}, {"foo_bar"}}, new String[0][], new String[0][], {{"asdf"}, {"asdg"}}, {{"MAX_CHAR"}, {"asdf"}, {"asdg"}, {"aasdf"}, {"%foobar"}, {"foo%bar"}, {"foo_bar"}}, {{"MAX_CHAR"}, {"asdf"}, {"asdg"}, {"aasdf"}, {"%foobar"}, {"foo%bar"}, {"foo_bar"}}, new String[0][], {{"aasdf"}}, new String[0][]};
        this.testGeneratedPredicates(preparedStatement, stringArray);
    }

    public void testGeneratedPredicatesVARCHAR() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select id from test where vc10 like ?");
        String[][][] stringArray = new String[][][]{new String[0][], new String[0][], new String[0][], {{"MAX_CHAR"}, {"asdf"}, {"asdg"}, {"aasdf"}, {"%foobar"}, {"foo%bar"}, {"foo_bar"}}, {{"asdf"}, {"aasdf"}}, {{"asdg"}}, {{"asdf"}, {"asdg"}}, {{"MAX_CHAR"}, {"asdf"}, {"asdg"}, {"aasdf"}, {"%foobar"}, {"foo%bar"}, {"foo_bar"}}, {{"MAX_CHAR"}, {"asdf"}, {"asdg"}, {"aasdf"}, {"%foobar"}, {"foo%bar"}, {"foo_bar"}}, {{"aasdf"}}, new String[0][], {{"asdf"}, {"aasdf"}}};
        this.testGeneratedPredicates(preparedStatement, stringArray);
    }

    private void testGeneratedPredicates(PreparedStatement preparedStatement, String[][][] stringArray) throws SQLException {
        Object[] objectArray = new Object[]{null, 1, "", "%", "%f", "%g", "asd%", "_%", "%_", "_asdf", "_asdf %", "%asdf"};
        DynamicLikeOptimizationTest.assertEquals((int)objectArray.length, (int)stringArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                preparedStatement.setString(1, null);
            } else {
                preparedStatement.setObject(1, objectArray[i]);
            }
            JDBC.assertUnorderedResultSet(preparedStatement.executeQuery(), stringArray[i]);
        }
        preparedStatement.close();
    }

    public void testStringAndPatternAndEscapeFromTable() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select match_me from likeable where match_me like pattern escape esc");
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            resultSet = preparedStatement.executeQuery();
            DynamicLikeOptimizationTest.assertTrue((boolean)resultSet.next());
            DynamicLikeOptimizationTest.assertTrue((boolean)resultSet.next());
            bl = true;
            resultSet.next();
            DynamicLikeOptimizationTest.fail();
        }
        catch (SQLException sQLException) {
            DynamicLikeOptimizationTest.assertSQLState("22025", sQLException);
            DynamicLikeOptimizationTest.assertTrue((DynamicLikeOptimizationTest.usingEmbedded() && bl || DynamicLikeOptimizationTest.usingDerbyNetClient() && resultSet == null ? 1 : 0) != 0);
        }
        if (resultSet != null) {
            resultSet.close();
        }
        PreparedStatement preparedStatement2 = this.prepareStatement("delete from likeable");
        DynamicLikeOptimizationTest.assertEquals((int)3, (int)preparedStatement2.executeUpdate());
        PreparedStatement preparedStatement3 = this.prepareStatement("insert into likeable values (?, ?, ?)");
        preparedStatement3.setString(1, "foo%bar");
        preparedStatement3.setString(2, "foo%bar");
        preparedStatement3.setString(3, null);
        preparedStatement3.executeUpdate();
        try {
            JDBC.assertDrainResults(preparedStatement.executeQuery());
            DynamicLikeOptimizationTest.fail();
        }
        catch (SQLException sQLException) {
            DynamicLikeOptimizationTest.assertSQLState("22501", sQLException);
        }
        DynamicLikeOptimizationTest.assertEquals((int)1, (int)preparedStatement2.executeUpdate());
        preparedStatement3.setString(3, "");
        preparedStatement3.executeUpdate();
        try {
            JDBC.assertDrainResults(preparedStatement.executeQuery());
            DynamicLikeOptimizationTest.fail();
        }
        catch (SQLException sQLException) {
            DynamicLikeOptimizationTest.assertSQLState("22019", sQLException);
        }
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
    }

    public void testEscapeWithBackslash() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select id, name, source from cei where (name LIKE ? escape '\\') and (source like ? escape '\\') order by source asc, name asc");
        HashMap<String[], Object[][]> hashMap = new HashMap<String[], Object[][]>();
        hashMap.put(new String[]{"%", "%"}, new Object[][]{CEI_ROWS[0], CEI_ROWS[1], CEI_ROWS[2], CEI_ROWS[3], CEI_ROWS[4], CEI_ROWS[8], CEI_ROWS[7], CEI_ROWS[5], CEI_ROWS[6]});
        hashMap.put(new String[]{"Alarms", "AlarmDisk%"}, new Object[][]{CEI_ROWS[0]});
        hashMap.put(new String[]{"A%", "%"}, new Object[][]{CEI_ROWS[0], CEI_ROWS[1], CEI_ROWS[2], CEI_ROWS[3], CEI_ROWS[4]});
        hashMap.put(new String[]{"%", "___rm%"}, new Object[][]{CEI_ROWS[0], CEI_ROWS[1], CEI_ROWS[2]});
        hashMap.put(new String[]{"Warning", "%oor"}, new Object[][]{CEI_ROWS[8], CEI_ROWS[7], CEI_ROWS[6]});
        hashMap.put(new String[]{"Warning", "Warn\\%Unlock\\%Door"}, new Object[][]{CEI_ROWS[7]});
        hashMap.put(new String[]{"Warning", "%\\%Unlo%"}, new Object[][]{CEI_ROWS[7]});
        hashMap.put(new String[]{"Warning", "W\\_Unloc%"}, new Object[][]{CEI_ROWS[8]});
        hashMap.put(new String[]{"Warning", "_\\_Unlock\\_Door"}, new Object[][]{CEI_ROWS[8]});
        hashMap.put(new String[]{"W%", "Warn\\%Unlock\\%Door"}, new Object[][]{CEI_ROWS[7]});
        hashMap.put(new String[]{"%ing", "W\\_Unlock\\_%Door"}, new Object[][]{CEI_ROWS[8]});
        hashMap.put(new String[]{"Bogus", "Name"}, new Object[0][]);
        for (Map.Entry entry : hashMap.entrySet()) {
            String[] stringArray = (String[])entry.getKey();
            Object[][] objectArray = (Object[][])entry.getValue();
            preparedStatement.setObject(1, stringArray[0]);
            preparedStatement.setObject(2, stringArray[1]);
            JDBC.assertFullResultSet(preparedStatement.executeQuery(), objectArray, false);
        }
        preparedStatement.close();
    }

    public void testTabs() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into test values ('asd\tp', 'asd\tp', 'asd\tp'), ('ase\tp', 'ase\tg', 'ase\tg')");
        String[][] stringArray = new String[][]{{"asdf"}, {"asdg"}, {"asd\tp"}};
        JDBC.assertUnorderedResultSet(statement.executeQuery("select c10 from test where c10 like 'asd%'"), stringArray);
        PreparedStatement preparedStatement = this.prepareStatement("select c10 from test where c10 like ?");
        preparedStatement.setString(1, "asd%");
        JDBC.assertUnorderedResultSet(preparedStatement.executeQuery(), stringArray);
        statement.close();
        preparedStatement.close();
    }

    public void testEscapedEscapeCharacterPrecedingFirstWildcard() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into test values ('abc#def', 'abc#def', 'abc#def'), ('abc\\def', 'abc\\def', 'abc\\def')");
        PreparedStatement[] preparedStatementArray = new PreparedStatement[]{this.prepareStatement("select id from test where c10 like ? escape ?"), this.prepareStatement("select id from test where vc10 like ? escape ?")};
        String[][] stringArrayArray = new String[][]{{"abc##%", "#", "abc#def", "abc#def"}, {"abc\\\\%", "\\", "abc\\def", "abc\\def"}, {"abc##_ef", "#", null, "abc#def"}, {"abc\\\\_ef", "\\", null, "abc\\def"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            for (int j = 0; j < preparedStatementArray.length; ++j) {
                preparedStatementArray[j].setString(1, stringArrayArray[i][0]);
                preparedStatementArray[j].setString(2, stringArrayArray[i][1]);
                ResultSet resultSet = preparedStatementArray[j].executeQuery();
                String string = stringArrayArray[i][2 + j];
                if (string == null) {
                    JDBC.assertEmpty(resultSet);
                    continue;
                }
                JDBC.assertSingleValueResultSet(resultSet, string);
            }
        }
        statement.close();
        preparedStatementArray[0].close();
        preparedStatementArray[1].close();
    }

    public void testDynamicLikeOptimization() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')");
        if (resultSet.next() && resultSet.getString(1).equals("TERRITORY_BASED")) {
            resultSet.close();
            statement.close();
            return;
        }
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        PreparedStatement preparedStatement = this.prepareStatement("select id from test where vc10 like ?");
        preparedStatement.setString(1, "%");
        JDBC.assertDrainResults(preparedStatement.executeQuery());
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DynamicLikeOptimizationTest.assertTrue((boolean)runtimeStatisticsParser.hasGreaterThanOrEqualQualifier());
        DynamicLikeOptimizationTest.assertTrue((boolean)runtimeStatisticsParser.hasLessThanQualifier());
        statement.close();
        preparedStatement.close();
    }

    public void testCast() throws SQLException {
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select 1 from t1 where 'asdf' like cast('%f' as varchar(2))"), "1");
        JDBC.assertEmpty(statement.executeQuery("select 1 from t1 where 'asdf' like cast(null as char)"));
        JDBC.assertSingleValueResultSet(statement.executeQuery("select 1 from t1 where '%foobar' like 'Z%foobar' escape cast('Z' as varchar(1))"), "1");
        JDBC.assertEmpty(statement.executeQuery("select vc10 from test where vc10 like 'values cast(null as varchar(1))'"));
        JDBC.assertEmpty(statement.executeQuery("select id from test where c10 like cast ('%f' as varchar(2))"));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select id from test where vc10 like cast ('%f' as varchar(2))"), new String[][]{{"asdf"}, {"aasdf"}});
        statement.close();
    }
}

