/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public class ConnectionHandlingJunit
extends BaseJDBCTestCase {
    public static Writer getLogDiscarder() {
        return new Writer(){

            @Override
            public void write(char[] cArray, int n, int n2) {
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
    }

    public ConnectionHandlingJunit(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ConnectionHandlingJUnit");
        if (JDBC.vmSupportsJDBC3()) {
            ConnectionHandlingJunit connectionHandlingJunit = new ConnectionHandlingJunit("driverMgrTestConnectionsToNonexistentDb");
            ConnectionHandlingJunit connectionHandlingJunit2 = new ConnectionHandlingJunit("driverMgrTestConnectionsToNonexistentDbInMemory");
            baseTestSuite.addTest((Test)connectionHandlingJunit);
            baseTestSuite.addTest((Test)connectionHandlingJunit2);
        }
        return baseTestSuite;
    }

    public void driverMgrTestConnectionsToNonexistentDb() throws SQLException {
        String string = this.getTestConfiguration().getJDBCUrl("nonexistentDatabase");
        this.driverMgrConnectionInitiator(string, false);
    }

    public void driverMgrTestConnectionsToNonexistentDbInMemory() throws SQLException {
        this.driverMgrConnectionInitiator("jdbc:derby:memory:noDbHere", true);
    }

    private void driverMgrConnectionInitiator(String string, boolean bl) throws SQLException {
        Connection connection = null;
        this.loadDriver(string);
        Runtime runtime = Runtime.getRuntime();
        int n = 130000;
        int n2 = 0;
        ConnectionHandlingJunit.println("Trying " + n + " connection attempts...");
        try {
            while (n2 < n) {
                try {
                    connection = DriverManager.getConnection((String)(bl ? string + n2 : string));
                    ConnectionHandlingJunit.fail((String)"Got connection to a DB that should not exist");
                }
                catch (SQLException sQLException) {
                    String string2;
                    if (this.getTestConfiguration().getJDBCClient().isEmbedded()) {
                        string2 = "XJ004";
                        if (sQLException.getSQLState().equals("08004") && sQLException.getMessage().matches(".*OutOfMemoryError.*")) {
                            ConnectionHandlingJunit.alarm("OutOfMemoryError after " + n2 + " connection attempts to a non-existing database!");
                            ConnectionHandlingJunit.printStackTrace(sQLException);
                        }
                    } else {
                        string2 = "08004";
                        if (sQLException.getSQLState().equals("XJ001") && sQLException.getMessage().matches(".*OutOfMemoryError.*")) {
                            ConnectionHandlingJunit.alarm("OutOfMemoryError after " + n2 + " connection attempts to a non-existing database!");
                            ConnectionHandlingJunit.printStackTrace(sQLException);
                        }
                    }
                    ConnectionHandlingJunit.assertSQLState("Wrong SQLState for non-existent database", string2, sQLException);
                }
                if (!this.getTestConfiguration().isVerbose() || ++n2 % 1000 != 0) continue;
                double d = (double)runtime.totalMemory() / 1048576.0;
                ConnectionHandlingJunit.println("Iteration: " + n2 + "\tTotal memory (MB): " + d);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ConnectionHandlingJunit.alarm("OutOfMemory after " + n2 + " connection attempts!");
            ConnectionHandlingJunit.alarm(outOfMemoryError.getMessage());
            throw outOfMemoryError;
        }
    }

    private void loadDriver(String string) throws SQLException {
        ConnectionHandlingJunit.setSystemProperty("derby.stream.error.method", "org.apache.derbyTesting.functionTests.tests.memory.ConnectionHandlingJunit.getLogDiscarder");
        try {
            DriverManager.getDriver(string);
        }
        catch (SQLException sQLException) {
            ConnectionHandlingJunit.assertSQLState("Unexpected SQLState from getDriver().", "08001", sQLException);
            ConnectionHandlingJunit.assertEquals((String)"Unexpected exception message from getDriver(), ", (String)"No suitable driver", (String)sQLException.getMessage());
            String string2 = this.getTestConfiguration().getJDBCClient().getJDBCDriverName();
            ConnectionHandlingJunit.println("Loading JDBC driver " + string2);
            try {
                Class<?> clazz = Class.forName(string2);
                clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException("Failed to load JDBC driver '" + string2 + "', ClassNotFoundException: " + classNotFoundException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException("Failed to load JDBC driver '" + string2 + "', IllegalAccessException: " + illegalAccessException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException("Failed to load JDBC driver '" + string2 + "', InstantiationException: " + instantiationException.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SQLException("Missing constructor for JDBC driver '" + string2 + "', NoSuchMethodException: " + noSuchMethodException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SQLException("Could not invoke the constructor for JDBC driver '" + string2 + "', InvocationTargetException: " + invocationTargetException.getMessage());
            }
        }
    }
}

