/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BackgroundStreamSaver
implements Runnable {
    protected InputStream in;
    protected OutputStream out;
    protected boolean finished;
    protected IOException ioe;

    public BackgroundStreamSaver(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
        Thread thread = new Thread((Runnable)this, this.getClass().getName());
        thread.setPriority(1);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        try {
            int n;
            object = new byte[1024];
            while ((n = this.in.read((byte[])object, 0, ((byte[])object).length)) != -1) {
                this.out.write((byte[])object, 0, n);
            }
            this.out.flush();
        }
        catch (IOException iOException) {
            this.ioe = iOException;
        }
        BackgroundStreamSaver backgroundStreamSaver = this;
        object = backgroundStreamSaver;
        synchronized (backgroundStreamSaver) {
            this.finished = true;
            this.notifyAll();
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        if (this.ioe != null) {
            throw this.ioe;
        }
        BackgroundStreamSaver backgroundStreamSaver = this;
        synchronized (backgroundStreamSaver) {
            try {
                while (!this.finished) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException.toString());
            }
        }
    }
}

