/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SqlExceptionTest
extends BaseJDBCTestCase {
    public SqlExceptionTest(String string) {
        super(string);
    }

    public void testChainedException() {
        IOException iOException = new IOException("Test exception");
        SqlException sqlException = new SqlException(null, new ClientMessageId("08003.C.1"), (Throwable)iOException, new Object[0]);
        SQLException sQLException = sqlException.getSQLException();
        SqlExceptionTest.assertEquals((Object)sqlException, (Object)sQLException.getCause());
        SqlExceptionTest.assertEquals((Object)iOException, (Object)sQLException.getCause().getCause());
        SqlExceptionTest.assertNull((Object)sqlException.getNextException());
    }

    public void testNextException() {
        SQLException sQLException = new SQLException("test");
        SqlException sqlException = new SqlException(null, new ClientMessageId("08003.C.1"), (Throwable)sQLException, new Object[0]);
        SQLException sQLException2 = sqlException.getSQLException();
        SqlExceptionTest.assertEquals((Object)sqlException, (Object)sQLException2.getCause());
        SqlExceptionTest.assertEquals((Object)sQLException, (Object)sQLException2.getCause().getCause());
        SqlExceptionTest.assertEquals((Object)sQLException, (Object)sQLException2.getNextException());
        SqlException sqlException2 = new SqlException(null, new ClientMessageId("08000"), new Object[0]);
        sQLException2 = new SqlException(null, new ClientMessageId("08003.C.1"), (Throwable)sqlException2, new Object[0]).getSQLException();
        SqlExceptionTest.assertNotNull((Object)sQLException2.getNextException());
        SqlExceptionTest.assertEquals((String)sQLException2.getNextException().getSQLState(), (String)"08000");
        SqlExceptionTest.assertEquals((Object)sqlException2, (Object)sQLException2.getCause().getCause());
    }

    public void testSQLStateInRootException() throws SQLException {
        String string = "22018";
        Statement statement = this.createStatement();
        try {
            statement.execute("values cast('hello' as int)");
            SqlExceptionTest.fail();
        }
        catch (SQLDataException sQLDataException) {
            SqlExceptionTest.assertSQLState(string, sQLDataException);
            Throwable throwable = sQLDataException;
            while (throwable instanceof SQLException) {
                throwable = throwable.getCause();
            }
            String string2 = throwable.toString();
            SqlExceptionTest.assertTrue((String)("Message should start with the SQLState, found: " + string2), (boolean)string2.startsWith("ERROR " + string + ":"));
        }
    }

    public void testSerializedException() throws Exception {
        Object object;
        try {
            this.createStatement().execute("DROP TABLE APP.DERBY62_DAIN_SUNDSTROM");
            SqlExceptionTest.fail((String)"should've received an error");
        }
        catch (SQLException sQLException) {
            object = this.recreateSQLException(sQLException);
            SqlExceptionTest.assertSQLState("Unexpected SQL State", sQLException.getSQLState(), (SQLException)object);
            SqlExceptionTest.assertSQLExceptionEquals(sQLException, (SQLException)object);
        }
        try {
            Connection connection = this.getConnection();
            object = connection.createStatement();
            String string = "INSERT INTO tableWithPK values (1, 1), (2, 2), (3, 3), (4, 4), (5, 5)";
            object.addBatch(string);
            object.addBatch(string);
            object.addBatch(string);
            object.executeBatch();
            SqlExceptionTest.fail((String)"Unexpected: SQL statement should have failed");
        }
        catch (SQLException sQLException) {
            object = this.recreateSQLException(sQLException);
            SqlExceptionTest.assertSQLState("Unexpected SQL State", sQLException.getSQLState(), (SQLException)object);
            SqlExceptionTest.assertSQLExceptionEquals(sQLException, (SQLException)object);
        }
    }

    public void testDerby3390() throws Exception {
        ResultSet resultSet;
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        try {
            if (SqlExceptionTest.usingDerbyNetClient()) {
                statement.execute("values badFunction1()");
                SqlExceptionTest.fail((String)"expected an error");
            } else {
                statement.execute("values badFunction1()");
                resultSet = statement.getResultSet();
                resultSet.next();
                SqlExceptionTest.fail((String)"expected an error");
            }
        }
        catch (SQLException sQLException) {
            this.setAutoCommit(true);
            SqlExceptionTest.assertSQLState("38000", sQLException);
            SqlExceptionTest.assertTrue((sQLException.getMessage().indexOf("I refuse to return an int") > 1 ? 1 : 0) != 0);
        }
        try {
            if (SqlExceptionTest.usingDerbyNetClient()) {
                statement.execute("values badFunction2()");
                SqlExceptionTest.fail((String)"expected an error");
            } else {
                statement.execute("values badFunction2()");
                resultSet = statement.getResultSet();
                resultSet.next();
                SqlExceptionTest.fail((String)"expected an error");
            }
        }
        catch (SQLException sQLException) {
            this.setAutoCommit(true);
            SqlExceptionTest.assertSQLState("38000", sQLException);
            SqlExceptionTest.assertSQLState("50000", sQLException);
            SqlExceptionTest.assertTrue((sQLException.getMessage().indexOf("I refuse to return an int") > 1 ? 1 : 0) != 0);
        }
        try {
            if (SqlExceptionTest.usingDerbyNetClient()) {
                statement.execute("values badFunction3()");
                SqlExceptionTest.fail((String)"expected an error");
            } else {
                statement.execute("values badFunction3()");
                resultSet = statement.getResultSet();
                resultSet.next();
                SqlExceptionTest.fail((String)"expected an error");
            }
        }
        catch (SQLException sQLException) {
            this.setAutoCommit(true);
            SqlExceptionTest.assertSQLState("38000", sQLException);
            SqlExceptionTest.assertTrue((sQLException.getMessage().indexOf("The exception 'java.lang.Exception: I refuse to return an int!'") == 0 ? 1 : 0) != 0);
        }
        statement.close();
        this.rollback();
        this.setAutoCommit(true);
    }

    public void setUp() throws Exception {
        Connection connection = this.getConnection();
        String string = "CREATE TABLE tableWithPK (c1 int primary key,c2 int)";
        Statement statement = connection.createStatement();
        statement.execute(string);
        statement.execute("create function badFunction1() returns int language java parameter style java no sql external name '" + SqlExceptionTest.class.getName() + ".badFunction1'");
        statement.execute("create function badFunction2() returns int language java parameter style java no sql external name '" + SqlExceptionTest.class.getName() + ".badFunction2'");
        statement.execute("create function badFunction3() returns int language java parameter style java no sql external name '" + SqlExceptionTest.class.getName() + ".badFunction3'");
        statement.close();
        connection.close();
    }

    @Override
    public void tearDown() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("DROP TABLE tableWithPK");
        statement.executeUpdate("drop function badfunction1");
        statement.executeUpdate("drop function badfunction2");
        statement.executeUpdate("drop function badfunction3");
        statement.close();
        connection.close();
        super.tearDown();
    }

    private SQLException recreateSQLException(SQLException sQLException) throws Exception {
        SQLException sQLException2 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(sQLException);
        objectOutputStream.flush();
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        sQLException2 = (SQLException)objectInputStream.readObject();
        objectInputStream.close();
        SqlExceptionTest.assertNotNull((Object)sQLException2);
        return sQLException2;
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("empty SqlExceptionTest - client not supported on JSR169");
        }
        Test test = TestConfiguration.defaultSuite(SqlExceptionTest.class);
        return test;
    }

    public static int badFunction1() throws SQLException {
        throw new SQLException("I refuse to return an int!");
    }

    public static int badFunction2() throws SQLException {
        throw new SQLException("I refuse to return an int!", "50000");
    }

    public static int badFunction3() throws Exception {
        throw new Exception("I refuse to return an int!");
    }
}

