/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.PooledConnection;
import junit.framework.Test;
import org.apache.derby.client.ClientConnectionPoolDataSourceInterface;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClientConnectionPoolDataSourceTest
extends BaseJDBCTestCase {
    public ClientConnectionPoolDataSourceTest(String string) {
        super(string);
    }

    public void testMaxStatementsProperty() throws Exception {
        ClientConnectionPoolDataSourceInterface clientConnectionPoolDataSourceInterface;
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientConnectionPoolDataSource");
            clientConnectionPoolDataSourceInterface = (ClientConnectionPoolDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientConnectionPoolDataSource40");
            clientConnectionPoolDataSourceInterface = (ClientConnectionPoolDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        ClientConnectionPoolDataSourceTest.assertEquals((String)"Unexpected default value", (int)0, (int)clientConnectionPoolDataSourceInterface.getMaxStatements());
        clientConnectionPoolDataSourceInterface.setMaxStatements(25);
        ClientConnectionPoolDataSourceTest.assertEquals((String)"New value not set", (int)25, (int)clientConnectionPoolDataSourceInterface.getMaxStatements());
        try {
            clientConnectionPoolDataSourceInterface.setMaxStatements(-99);
            ClientConnectionPoolDataSourceTest.fail((String)("Negative values should not be allowed: " + clientConnectionPoolDataSourceInterface.getMaxStatements()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        clientConnectionPoolDataSourceInterface.setMaxStatements(0);
        ClientConnectionPoolDataSourceTest.assertEquals((String)"New value not set", (int)0, (int)clientConnectionPoolDataSourceInterface.getMaxStatements());
    }

    public void testGetConnectionNoStatementPooling() throws SQLException {
        ClientConnectionPoolDataSourceInterface clientConnectionPoolDataSourceInterface = (ClientConnectionPoolDataSourceInterface)J2EEDataSource.getConnectionPoolDataSource();
        clientConnectionPoolDataSourceInterface.setMaxStatements(0);
        ClientConnectionPoolDataSourceTest.assertEquals((int)0, (int)clientConnectionPoolDataSourceInterface.getMaxStatements());
        this.verifyConnection(clientConnectionPoolDataSourceInterface);
    }

    public void testGetConnectionWithStatementPooling() throws SQLException {
        ClientConnectionPoolDataSourceInterface clientConnectionPoolDataSourceInterface = (ClientConnectionPoolDataSourceInterface)J2EEDataSource.getConnectionPoolDataSource();
        clientConnectionPoolDataSourceInterface.setMaxStatements(27);
        ClientConnectionPoolDataSourceTest.assertTrue((clientConnectionPoolDataSourceInterface.getMaxStatements() > 0 ? 1 : 0) != 0);
        this.verifyConnection(clientConnectionPoolDataSourceInterface);
    }

    private void verifyConnection(ClientConnectionPoolDataSourceInterface clientConnectionPoolDataSourceInterface) throws SQLException {
        J2EEDataSource.setBeanProperty(clientConnectionPoolDataSourceInterface, "createDatabase", "create");
        PooledConnection pooledConnection = clientConnectionPoolDataSourceInterface.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from sys.systables");
        JDBC.assertDrainResultsHasData(resultSet);
        PreparedStatement preparedStatement = connection.prepareStatement("values 31");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "31");
        preparedStatement.close();
        PreparedStatement preparedStatement2 = connection.prepareStatement("values 31");
        ClientConnectionPoolDataSourceTest.assertNotSame((Object)preparedStatement, (Object)preparedStatement2);
        JDBC.assertSingleValueResultSet(preparedStatement2.executeQuery(), "31");
        statement.close();
        preparedStatement2.close();
        connection.close();
        pooledConnection.close();
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(ClientConnectionPoolDataSourceTest.class);
    }
}

