/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.derby.vti.AwareVTI;
import org.apache.derby.vti.ForeignTableVTI;
import org.apache.derby.vti.ForwardingVTI;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derby.vti.VTIContext;

public class ArchiveVTI
extends ForwardingVTI
implements AwareVTI,
RestrictedVTI {
    private Connection _connection = DriverManager.getConnection("jdbc:default:connection");
    private String _archiveSuffix;
    private VTIContext _vtiContext;
    private ArrayList<String> _tableNames;
    private int _tableIdx;
    private String[] _columnNames;
    private Restriction _restriction;

    public static ArchiveVTI archiveVTI(String string) throws SQLException {
        return new ArchiveVTI(string);
    }

    public ArchiveVTI(String string) throws SQLException {
        this._archiveSuffix = string;
    }

    public VTIContext getContext() {
        return this._vtiContext;
    }

    public void setContext(VTIContext vTIContext) {
        this._vtiContext = vTIContext;
    }

    public void initScan(String[] stringArray, Restriction restriction) throws SQLException {
        this._columnNames = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this._columnNames, 0, stringArray.length);
        this._restriction = restriction;
    }

    public boolean next() throws SQLException {
        if (this._tableNames == null) {
            this.getTableNames();
            this._tableIdx = 0;
            this.loadResultSet();
        }
        while (!super.next()) {
            ++this._tableIdx;
            if (this._tableIdx >= this._tableNames.size()) {
                return false;
            }
            this.loadResultSet();
        }
        return true;
    }

    public void close() throws SQLException {
        if (this.getWrappedResultSet() != null) {
            this.getWrappedResultSet().close();
        }
        this.wrapResultSet(null);
        this._connection = null;
    }

    private void getTableNames() throws SQLException {
        this._tableNames = new ArrayList();
        this._tableNames.add(this.getContext().vtiTable());
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, this.getContext().vtiSchema(), this.getContext().vtiTable() + this._archiveSuffix + "%", null);
        while (resultSet.next()) {
            this._tableNames.add(resultSet.getString("TABLE_NAME"));
        }
        resultSet.close();
    }

    private void loadResultSet() throws SQLException {
        if (this.getWrappedResultSet() != null) {
            this.getWrappedResultSet().close();
        }
        ForeignTableVTI foreignTableVTI = new ForeignTableVTI(this.getContext().vtiSchema(), this._tableNames.get(this._tableIdx), this.getConnection());
        foreignTableVTI.initScan(this._columnNames, this._restriction);
        this.wrapResultSet((ResultSet)foreignTableVTI);
    }

    private Connection getConnection() throws SQLException {
        return this._connection;
    }
}

