/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.SampleVTI;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DeclareGlobalTempTableJavaTest
extends BaseJDBCTestCase {
    public DeclareGlobalTempTableJavaTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(DeclareGlobalTempTableJavaTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.dropSchemaTables();
        this.getConnection().setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDerby1706() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("drop schema SESSION restrict");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaTest.assertSQLState("42Y07", sQLException);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "set schema SESSION");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "create table DERBY1706(c11 int)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "drop table DERBY1706");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "set schema APP");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "drop schema SESSION restrict");
    }

    public void testGTTSchemaName() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "set schema APP");
        DeclareGlobalTempTableJavaTest.assertStatementError("428EK", statement, "DECLARE GLOBAL TEMPORARY TABLE APP.t2(c21 int) on commit delete rows not logged");
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE t2(c21 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", statement, "insert into APP.t2 values(7)");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", statement, "insert into t2 values(7)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(7)");
        DeclareGlobalTempTableJavaTest.assertStatementError("42Y55", statement, "drop table t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "drop table SESSION.t2");
    }

    public void testPositiveGrammars() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tA(c1 int) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tB(c1 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tC(c1 int) not logged on commit delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tD(c1 int) on commit preserve rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tE(c1 int) not logged on commit preserve rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tF(c1 int) on rollback delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tG(c1 int) not logged on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tH(c1 int) on commit preserve rows not logged on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tI(c1 int) not logged on commit preserve rows on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tJ(c1 int) not logged on rollback delete rows on commit preserve rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tK(c1 int) on commit delete rows not logged on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tL(c1 int) not logged on commit delete rows on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE tM(c1 int) not logged on rollback delete rows on commit delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tA");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tB");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tC");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tD");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tE");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tF");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tG");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tH");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tI");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tJ");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tK");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tL");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.tM");
    }

    public void testNegativeGrammars() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertStatementError("42X01", statement, "DECLARE GLOBAL TEMPORARY TABLE t1(c11 int)");
        DeclareGlobalTempTableJavaTest.assertStatementError("42613", statement, "DECLARE GLOBAL TEMPORARY TABLE t1(c11 int) NOT LOGGED NOT LOGGED");
        DeclareGlobalTempTableJavaTest.assertStatementError("42613", statement, "DECLARE GLOBAL TEMPORARY TABLE t1(c11 int) NOT LOGGED ON COMMIT PRESERVE ROWS ON COMMIT DELETE ROWS");
        DeclareGlobalTempTableJavaTest.assertStatementError("42613", statement, "DECLARE GLOBAL TEMPORARY TABLE t1(c11 int) NOT LOGGED ON ROLLBACK DELETE ROWS ON ROLLBACK DELETE ROWS");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X01", statement, "DECLARE GLOBAL TEMPORARY TABLE t1(c11 int) ON ROLLBACK DELETE ROWS ON COMMIT PRESERVE ROWS");
    }

    public void testFeaturesNotAllowedOnGTTs() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) not logged on commit delete rows");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", statement, "ALTER TABLE SESSION.t2 add column c22 int");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", statement, "LOCK TABLE SESSION.t2 IN SHARE MODE");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", statement, "RENAME TABLE SESSION.t2 TO t3");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", statement, "CREATE index t2i1 on SESSION.t2 (c21)");
        DeclareGlobalTempTableJavaTest.assertStatementError("XCL51", statement, "CREATE VIEW t2v1 as select * from SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", statement, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t1(c21 int generated always as identity) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("42962", statement, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t1(c21 int, c22 blob(3k)) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("42962", statement, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t1(c21 int, c22 clob(3k)) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("42962", statement, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t1(c21 int, c22 long varchar) on commit delete rows not logged");
        statement.executeUpdate("DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertStatementError("42Y55", statement, "DROP TABLE SESSION.t1");
    }

    public void testFeaturesAllowedOnPhysicalTablesOfSESSIONSchema() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("CREATE schema SESSION");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", sQLException);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "CREATE TABLE SESSION.t2(c21 int)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "ALTER TABLE SESSION.t2 add column c22 int");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "LOCK TABLE SESSION.t2 IN EXCLUSIVE MODE");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "RENAME TABLE SESSION.t2 TO t3");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "RENAME COLUMN SESSION.t3.c21 TO c23");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "CREATE TABLE SESSION.t2 (c21 int)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "CREATE index t2i1 on SESSION.t2 (c21)");
        DeclareGlobalTempTableJavaTest.assertStatementError("XCL51", statement, "CREATE VIEW t2v1 as select * from SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t3");
    }

    public void testConstraintsNotAllowedOnGTTs() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", statement, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int not null, constraint pk primary key (c21)) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", statement, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int not null unique) on commit delete rows not logged");
        statement.executeUpdate("CREATE TABLE t1(c11 int not null unique)");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", statement, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int references t1(c11)) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("42995", statement, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int check (c21 > 0)) on commit delete rows not logged");
        statement.executeUpdate("DROP TABLE t1");
    }

    public void testConstraintsAllowedOnSESSIONPhysicalTables() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("CREATE SCHEMA SESSION");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", sQLException);
        }
        statement.executeUpdate("CREATE TABLE SESSION.t1(c21 int not null, constraint pk primary key (c21))");
        statement.executeUpdate("CREATE TABLE SESSION.t2(c21 int not null unique)");
        statement.executeUpdate("CREATE TABLE SESSION.t3(c21 int check (c21 > 0))");
        statement.executeUpdate("CREATE TABLE t4(c11 int not null unique)");
        statement.executeUpdate("CREATE TABLE SESSION.t5(c21 int references t4(c11))");
        statement.executeUpdate("DROP TABLE SESSION.t1");
        statement.executeUpdate("DROP TABLE SESSION.t2");
        statement.executeUpdate("DROP TABLE SESSION.t3");
        statement.executeUpdate("DROP TABLE SESSION.t5");
        statement.executeUpdate("DROP TABLE t4");
    }

    public void testOnCommiDeleteRowsWithAndWithoutOpenCursors() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(22, 22)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(23, 23)");
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c31 int, c32 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t3 values(32, 32)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t3 values(33, 33)");
        ResultSet resultSet2 = statement.executeQuery("select count(*) from SESSION.t3");
        JDBC.assertSingleValueResultSet(resultSet2, "2");
        this.commit();
        resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        resultSet2 = statement.executeQuery("select count(*) from SESSION.t3");
        JDBC.assertSingleValueResultSet(resultSet2, "0");
        statement.executeUpdate("DROP TABLE SESSION.t2");
        statement.executeUpdate("DROP TABLE SESSION.t3");
    }

    public void testOnCommitPreserveRowsWithAndWithoutOpenCursors() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged");
        statement.executeUpdate("insert into SESSION.t2 values(22, 22)");
        statement.executeUpdate("insert into SESSION.t2 values(23, 23)");
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c31 int, c32 int) on commit preserve rows not logged");
        statement.executeUpdate("insert into SESSION.t3 values(32, 32)");
        statement.executeUpdate("insert into SESSION.t3 values(33, 33)");
        ResultSet resultSet2 = statement.executeQuery("select count(*) from SESSION.t3");
        JDBC.assertSingleValueResultSet(resultSet2, "2");
        this.commit();
        resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        resultSet2 = statement.executeQuery("select count(*) from SESSION.t3");
        JDBC.assertSingleValueResultSet(resultSet2, "2");
        statement.executeUpdate("DROP TABLE SESSION.t2");
        statement.executeUpdate("DROP TABLE SESSION.t3");
    }

    public void testDuplicateAndNullGTT() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertStatementError("X0Y32", statement, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) not logged on commit preserve rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertStatementError("42Y55", statement, "DROP TABLE SESSION.t2");
    }

    public void testInsertOnGTT() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 char(2)) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values (1, 'aa')");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 3, "insert into SESSION.t2 values (2, 'bb'),(3, 'cc'),(4, null)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "CREATE TABLE t1(c11 int, c22 char(2))");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 3, "insert into t1 values (5, null),(6, null),(7, 'gg')");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 3, "insert into SESSION.t2 (select * from t1 where c11>4)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 7, "insert into SESSION.t2 select * from SESSION.t2");
        ResultSet resultSet = statement.executeQuery("select sum(c21) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "56");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c21 int, c22 char(2) not null) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t3 values (1, 'aa')");
        DeclareGlobalTempTableJavaTest.assertStatementError("23502", statement, "insert into SESSION.t3 values (2, null)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t4(c21 int, c22 char(2) default 'aa', c23 varchar(20) default user ) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t4 values (1, 'aa', null)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t4(c21) values (2)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t4");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t3");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE t1");
    }

    public void testDeleteOnGTT() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 decimal) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(1, 1.1)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(2, 2.2)");
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 2, "DELETE FROM SESSION.t2 where c21 > 0");
        resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
    }

    public void testUpdateOnGTT() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(1, 1)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(2, 1)");
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2 where c22 = 1");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 2, "UPDATE SESSION.t2 SET c22 = 2 where c21>0");
        resultSet = statement.executeQuery("select count(*) from SESSION.t2 where c22 = 1");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        resultSet = statement.executeQuery("select count(*) from SESSION.t2 where c22 = 2");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
    }

    public void testSESSIONschema() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("CREATE SCHEMA SESSION");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", sQLException);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP SCHEMA SESSION restrict");
        DeclareGlobalTempTableJavaTest.assertStatementError("42Y07", statement, "DROP SCHEMA SESSION restrict");
    }

    public void testCreateView() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "CREATE TABLE t2 (c28 int)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 2, "INSERT INTO t2 VALUES (280),(281)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "CREATE VIEW SESSION.t2v1 as select * from t2");
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2v1");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP VIEW SESSION.t2v1");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE t2");
    }

    public void testStatementCaching() throws SQLException {
        Statement statement = this.createStatement();
        this.getConnection().setAutoCommit(true);
        try {
            statement.executeUpdate("CREATE schema SESSION");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", sQLException);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "CREATE TABLE SESSION.t2 (c21 int)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "INSERT into SESSION.t2 values(21)");
        this.getConnection().setAutoCommit(false);
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "INSERT into SESSION.t2 values(22, 22)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "INSERT into SESSION.t2 values(23, 23)");
        resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "drop schema SESSION restrict");
    }

    public void testSESSIONQualifier() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(21, 21)");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", statement, "insert into t2 values(23, 23)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(22, 22)");
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        try {
            statement.executeUpdate("CREATE SCHEMA SESSION");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", sQLException);
        }
        statement.executeUpdate("SET SCHEMA SESSION");
        resultSet = statement.executeQuery("select count(*) from t2");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "SET SCHEMA APP");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "drop schema SESSION restrict");
    }

    public void testOneGTTInConnection() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(22, 22)");
        Connection connection = this.openDefaultConnection();
        Statement statement2 = connection.createStatement();
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", statement2, "select count(*) from SESSION.t2");
        statement2.close();
        connection.close();
    }

    public void testSameGTTNameForTwoConnections() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(22, 22)");
        Connection connection = this.openDefaultConnection();
        Statement statement2 = connection.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement2, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement2, 1, "insert into SESSION.t2 values(99)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement2, 0, "DROP TABLE SESSION.t2");
        statement2.close();
        connection.close();
    }

    public void testPreparedStatement1() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        PreparedStatement preparedStatement = this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        preparedStatement.setInt(1, 21);
        preparedStatement.setInt(2, 1);
        preparedStatement.execute();
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        try {
            preparedStatement.setInt(1, 22);
            preparedStatement.setInt(2, 2);
            preparedStatement.execute();
            DeclareGlobalTempTableJavaTest.fail((String)" Table/View 'SESSION.T2' does not exist:");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaTest.assertSQLState("42X05", sQLException);
        }
    }

    public void testPreparedStatement2() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        PreparedStatement preparedStatement = this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        preparedStatement.setInt(1, 21);
        preparedStatement.setInt(2, 1);
        preparedStatement.execute();
        preparedStatement.close();
        ResultSet resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        DeclareGlobalTempTableJavaTest.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int, c23 int) not logged");
        preparedStatement = this.prepareStatement("insert into SESSION.t2 values (?, ? , ?)");
        preparedStatement.setInt(1, 22);
        preparedStatement.setInt(2, 2);
        preparedStatement.setNull(3, 4);
        preparedStatement.execute();
        resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        resultSetMetaData = resultSet.getMetaData();
        DeclareGlobalTempTableJavaTest.assertEquals((int)3, (int)resultSetMetaData.getColumnCount());
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int, c23 int, c24 int not null) not logged");
        preparedStatement = this.prepareStatement("insert into SESSION.t2 values (?, ? , ? , ?)");
        try {
            preparedStatement.setInt(1, 22);
            preparedStatement.setInt(2, 2);
            preparedStatement.setNull(3, 4);
            preparedStatement.setNull(4, 4);
            preparedStatement.execute();
            DeclareGlobalTempTableJavaTest.fail((String)"trying to Insert a null value into non null column:");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaTest.assertSQLState("23502", sQLException);
        }
    }

    public void testTempTableDDLRollbackbehaviour1() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        statement.executeUpdate("drop table SESSION.t1");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", statement, "select * from SESSION.t1");
        this.rollback();
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", statement, "select * from SESSION.t1");
    }

    public void testTempTableDDLRollbackbehaviour2() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        this.commit();
        statement.executeUpdate("drop table SESSION.t1");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", statement, "select * from SESSION.t1");
        this.rollback();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
    }

    public void testTempTableDDLRollbackbehaviour3() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        this.commit();
        statement.executeUpdate("drop table SESSION.t1");
        this.commit();
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", statement, "select * from SESSION.t1");
    }

    public void testTempTableDDLRollbackbehaviour4() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from SESSION.t1"), "0");
        this.rollback();
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", statement, "select * from SESSION.t1");
    }

    public void testRollbackBehavior1() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged");
        PreparedStatement preparedStatement = this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        preparedStatement.setInt(1, 21);
        preparedStatement.setInt(2, 1);
        preparedStatement.execute();
        preparedStatement.close();
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        this.rollback();
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", statement, "select * from SESSION.t2");
    }

    public void testRollbackBehavior2() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged");
        PreparedStatement preparedStatement = this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        preparedStatement.setInt(1, 21);
        preparedStatement.setInt(2, 1);
        preparedStatement.execute();
        preparedStatement.close();
        this.commit();
        statement.executeUpdate("DROP TABLE SESSION.t2");
        this.rollback();
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        this.commit();
    }

    public void testRollbackBehavior3() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int, c23 int) on commit preserve rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into session.t2 values(1,1,1)");
        ResultSet resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        DeclareGlobalTempTableJavaTest.assertEquals((int)3, (int)resultSetMetaData.getColumnCount());
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", statement, "select * from SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into session.t2 values(1,1)");
        resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        resultSetMetaData = resultSet.getMetaData();
        DeclareGlobalTempTableJavaTest.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
        this.commit();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into session.t2 values(1)");
        resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        resultSetMetaData = resultSet.getMetaData();
        DeclareGlobalTempTableJavaTest.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
        resultSet.close();
        this.rollback();
        resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        resultSetMetaData = resultSet.getMetaData();
        DeclareGlobalTempTableJavaTest.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
        resultSet.close();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
    }

    public void testRollbackBehavior4() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c31 int, c32 int) not logged on commit preserve rows on rollback delete rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t4(c41 int, c42 int) not logged on rollback delete rows on commit preserve rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t5(c51 int, c52 int) on commit preserve rows not logged");
        statement.executeUpdate("insert into session.t2 values(21,1)");
        statement.executeUpdate("insert into session.t2 values(22,2)");
        statement.executeUpdate("insert into session.t2 values(23,3)");
        statement.executeUpdate("insert into session.t3 values(31,1)");
        statement.executeUpdate("insert into session.t3 values(32,2)");
        statement.executeUpdate("insert into session.t3 values(33,3)");
        statement.executeUpdate("insert into session.t4 values(41,1)");
        statement.executeUpdate("insert into session.t4 values(42,2)");
        statement.executeUpdate("insert into session.t4 values(43,3)");
        statement.executeUpdate("insert into session.t5 values(51,1)");
        statement.executeUpdate("insert into session.t5 values(52,2)");
        statement.executeUpdate("insert into session.t5 values(53,3)");
        this.commit();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t6(c61 int, c62 int) on commit preserve rows not logged on rollback delete rows");
        statement.executeUpdate("insert into session.t6 values(61,1)");
        statement.executeUpdate("insert into session.t6 values(62,2)");
        statement.executeUpdate("insert into session.t6 values(63,3)");
        statement.executeUpdate("DELETE FROM session.t2 WHERE c22> (select c52 from session.t5 where c52=2)");
        statement.executeUpdate("DELETE FROM session.t3 WHERE c32>3");
        this.rollback();
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        resultSet = statement.executeQuery("select count(*) from SESSION.t3");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        resultSet = statement.executeQuery("select count(*) from SESSION.t4");
        JDBC.assertSingleValueResultSet(resultSet, "3");
        resultSet = statement.executeQuery("select count(*) from SESSION.t5");
        JDBC.assertSingleValueResultSet(resultSet, "3");
        DeclareGlobalTempTableJavaTest.assertStatementError("42X05", statement, "select * from SESSION.t6");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t3");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t4");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t5");
    }

    public void testEntryForSESSIONTablesToSysCatalog() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) on commit delete rows not logged");
        ResultSet resultSet = statement.executeQuery("select count(*) from sys.systables where CAST(tablename AS VARCHAR(128)) like 'T2'");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        try {
            statement.executeUpdate("CREATE SCHEMA SESSION");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", sQLException);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "CREATE TABLE SESSION.t2(c21 int, c22 int)");
        resultSet = statement.executeQuery("select count(*) from sys.systables where CAST(tablename AS VARCHAR(128)) like 'T2'");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "drop schema SESSION restrict");
    }

    public void testEntryForSEESSIONtoSysCatalog() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("drop schema SESSION restrict");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaTest.assertSQLState("42Y07", sQLException);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) on commit delete rows not logged");
        ResultSet resultSet = statement.executeQuery("select count(schemaname) from sys.sysschemas where CAST(schemaname AS VARCHAR(128)) like 'SESSION'");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
    }

    public void testDatabaseMetadata() throws SQLException {
        Statement statement = this.createStatement();
        int n = 0;
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        try {
            statement.executeUpdate("CREATE SCHEMA SESSION");
        }
        catch (SQLException sQLException) {
            DeclareGlobalTempTableJavaTest.assertSQLState("X0Y68", sQLException);
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "CREATE TABLE SESSION.t3(c31 int, c32 int)");
        ResultSet resultSet = databaseMetaData.getTables("", null, "%", null);
        while (resultSet.next()) {
            if ("T2".equals(resultSet.getString(3)) && "SESSION".equals(resultSet.getString(2))) {
                DeclareGlobalTempTableJavaTest.fail((String)"Temporary table Found");
            }
            ++n;
        }
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t3");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "drop schema SESSION restrict");
    }

    public void testDeleteWhereCurrentOfOnGTT() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(21, 1)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(22, 1)");
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        PreparedStatement preparedStatement = this.prepareStatement("select c21 from session.t2 for update");
        ResultSet resultSet2 = preparedStatement.executeQuery();
        resultSet2.next();
        PreparedStatement preparedStatement2 = this.prepareStatement("delete from session.t2 where current of " + resultSet2.getCursorName());
        preparedStatement2.executeUpdate();
        resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)22, (int)resultSet.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)1, (int)resultSet.getInt(2));
        resultSet2.next();
        preparedStatement2.executeUpdate();
        resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        resultSet.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)0, (int)resultSet.getInt(1));
        resultSet2.close();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
    }

    public void UpdateWhereCurrentOfOnGTT() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit delete rows not logged");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(21, 1)");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "insert into SESSION.t2 values(22, 1)");
        ResultSet resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        PreparedStatement preparedStatement = this.prepareStatement("select c21 from session.t2 for update");
        ResultSet resultSet2 = preparedStatement.executeQuery();
        resultSet2.next();
        PreparedStatement preparedStatement2 = this.prepareStatement("update session.t2 set c22 = 2 where current of " + resultSet2.getCursorName());
        preparedStatement2.executeUpdate();
        resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)21, (int)resultSet.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)2, (int)resultSet.getInt(2));
        resultSet.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)22, (int)resultSet.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)1, (int)resultSet.getInt(2));
        resultSet2.next();
        preparedStatement2.executeUpdate();
        resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)21, (int)resultSet.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)2, (int)resultSet.getInt(2));
        resultSet.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)22, (int)resultSet.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)2, (int)resultSet.getInt(2));
        resultSet2.close();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
    }

    public void testDMLRollback1() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged on commit preserve rows");
        PreparedStatement preparedStatement = this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        preparedStatement.setInt(1, 21);
        preparedStatement.setInt(2, 1);
        preparedStatement.execute();
        this.commit();
        ResultSet resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)21, (int)resultSet.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)1, (int)resultSet.getInt(2));
        preparedStatement.setInt(1, 22);
        preparedStatement.setInt(2, 2);
        preparedStatement.execute();
        this.rollback();
        resultSet = statement.executeQuery("select count(*) from SESSION.t2");
        resultSet.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)0, (int)resultSet.getInt(1));
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
    }

    public void testDMLRollback2() throws SQLException {
        Statement statement = this.createStatement();
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged on commit preserve rows");
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 1, "INSERT INTO SESSION.t2 VALUES(21, 1)");
        this.commit();
        ResultSet resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)21, (int)resultSet.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)1, (int)resultSet.getInt(2));
        this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        this.rollback();
        resultSet = statement.executeQuery("select * from SESSION.t2");
        resultSet.next();
        DeclareGlobalTempTableJavaTest.assertEquals((int)21, (int)resultSet.getInt(1));
        DeclareGlobalTempTableJavaTest.assertEquals((int)1, (int)resultSet.getInt(2));
        DeclareGlobalTempTableJavaTest.assertUpdateCount(statement, 0, "DROP TABLE SESSION.t2");
    }

    public void testVtiInsertIntoGTT() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.vtitogtt(c1 varchar(10)) not logged on commit preserve rows");
        statement.executeUpdate("CREATE FUNCTION emptySampleVTI() RETURNS TABLE(v1 varchar(10))LANGUAGE JAVA PARAMETER STYLE DERBY_JDBC_RESULT_SET NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.SampleVTI.emptySampleVTI'");
        statement.executeUpdate("insert into session.vtitogtt select * from table(emptySampleVTI()) as v");
        JDBC.assertEmpty(statement.executeQuery("select * from session.vtitogtt"));
        statement.executeUpdate("DROP FUNCTION emptySampleVTI");
        statement.executeUpdate("CREATE FUNCTION sampleVTI() RETURNS TABLE(v1 varchar(10))LANGUAGE JAVA PARAMETER STYLE DERBY_JDBC_RESULT_SET NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.SampleVTI.oneColSampleVTI'");
        statement.executeUpdate("insert into session.vtitogtt select * from table(sampleVTI()) as v");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from session.vtitogtt"), SampleVTI.oneColSampleVTIData());
        statement.executeUpdate("DROP FUNCTION sampleVTI");
    }

    public void dropSchemaTables() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = this.getConnection().getMetaData().getTables(null, "SESSION", "%", null);
        while (resultSet.next()) {
            try {
                statement.executeUpdate("DROP TABLE " + resultSet.getString(2) + "." + resultSet.getString(3));
            }
            catch (SQLException sQLException) {}
        }
        resultSet.close();
    }
}

