/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public final class XMLTypeAndOpsTest
extends BaseJDBCTestCase {
    public XMLTypeAndOpsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("XML Type and Operators Suite\n");
        if (!XML.classpathMeetsXMLReqs()) {
            return baseTestSuite;
        }
        baseTestSuite.addTest(TestConfiguration.defaultSuite(XMLTypeAndOpsTest.class, false));
        return new XMLTestSetup(baseTestSuite);
    }

    public void testXMLColCreation() throws Exception {
        this.assertCompileError("42894", "create table fail1 (i int, x xml default 'oops')");
        this.assertCompileError("42894", "create table fail2 (i int, x xml default 8)");
        this.assertCompileError("42818", "create table fail3 (i int, x xml check (x != 0))");
        Statement statement = this.createStatement();
        statement.executeUpdate("create table tc1 (i int, x xml)");
        statement.executeUpdate("create table tc2 (i int, x xml not null)");
        statement.executeUpdate("create table tc3 (i int, x xml default null)");
        statement.executeUpdate("create table tc4 (x2 xml not null)");
        statement.executeUpdate("alter table tc4 add column x1 xml");
        statement.executeUpdate("drop table tc1");
        statement.executeUpdate("drop table tc2");
        statement.executeUpdate("drop table tc3");
        statement.executeUpdate("drop table tc4");
        statement.close();
    }

    public void testIllegalNullInserts() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table tc2 (i int, x xml not null)");
        XMLTypeAndOpsTest.assertStatementError("23502", statement, "insert into tc2 values (1, null)");
        XMLTypeAndOpsTest.assertStatementError("23502", statement, "insert into tc2 values (2, cast (null as xml))");
        statement.executeUpdate("drop table tc2");
        statement.close();
    }

    public void testXMLColsWithNonXMLVals() throws Exception {
        this.assertCompileError("42821", "insert into t1 values (3, 'hmm')");
        this.assertCompileError("42821", "insert into t1 values (1, 2)");
        this.assertCompileError("42821", "insert into t1 values (1, 123.456)");
        this.assertCompileError("42821", "insert into t1 values (1, x'01')");
        this.assertCompileError("42821", "insert into t1 values (1, x'ab')");
        this.assertCompileError("42821", "insert into t1 values (1, current date)");
        this.assertCompileError("42821", "insert into t1 values (1, current time)");
        this.assertCompileError("42821", " insert into t1 values (1, current timestamp)");
        this.assertCompileError("42821", " insert into t1 values (1, ('hmm' || 'andstuff'))");
    }

    public void testNonXMLColsWithXMLVals() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table nonXTable (si smallint, i int, bi bigint, vcb varchar (32) for bit data, nu numeric(10,2), f float, d double, vc varchar(20), da date, ti time, ts timestamp, cl clob, bl blob)");
        this.assertCompileError("42821", "insert into nonXTable (si) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (i) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (bi) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (vcb) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (nu) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (f) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (d) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (vc) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (da) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (ti) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (ts) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (cl) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (bl) values (cast (null as xml))");
        this.assertCompileError("42821", "insert into nonXTable (cl) values (xmlparse(document '</simp>' preserve whitespace))");
        statement.executeUpdate("drop table nonXTable");
        statement.close();
    }

    public void testXMLCasting() throws Exception {
        this.assertCompileError("42846", "insert into t1 values (1, cast ('hmm' as xml))");
        this.assertCompileError("42846", "insert into t1 values (1, cast (2 as xml))");
        this.assertCompileError("42846", "insert into t1 values (1, cast (123.456 as xml))");
        this.assertCompileError("42846", "insert into t1 values (1, cast (x'01' as xml))");
        this.assertCompileError("42846", "insert into t1 values (1, cast (x'ab' as xml))");
        this.assertCompileError("42846", "insert into t1 values (1, cast (current date as xml))");
        this.assertCompileError("42846", "insert into t1 values (1, cast (current time as xml))");
        this.assertCompileError("42846", "insert into t1 values (1, cast (current timestamp as xml))");
        this.assertCompileError("42846", "insert into t1 values (1, cast (('hmm' || 'andstuff') as xml))");
        Statement statement = this.createStatement();
        statement.executeUpdate("create table nonXTable (i int, cl clob)");
        this.assertCompileError("42846", "insert into nonXTable (cl) values (cast ((xmlparse(document '</simp>' preserve whitespace)) as clob))");
        this.assertCompileError("42846", "insert into nonXTable (i) values (cast ((xmlparse(document '</simp>' preserve whitespace)) as int))");
        statement.executeUpdate("drop table nonXTable");
        statement.close();
    }

    public void testXMLInNonXMLOps() throws Exception {
        this.assertCompileError("42Y95", "select i + x from t1");
        this.assertCompileError("42Y95", "select i * x from t1");
        this.assertCompileError("42Y95", "select i / x from t1");
        this.assertCompileError("42Y95", "select i - x from t1");
        this.assertCompileError("42X37", "select -x from t1");
        this.assertCompileError("42846", "select 'hi' || x from t1");
        this.assertCompileError("42X25", "select substr(x, 0) from t1");
        this.assertCompileError("42Y22", "select max(x) from t1");
        this.assertCompileError("42Y22", "select min(x) from t1");
        this.assertCompileError("42X25", "select length(x) from t1");
        this.assertCompileError("42884", "select i from t1 where x like 'hmm'");
    }

    public void testXMLComparisons() throws Exception {
        this.assertCompileError("42818", "select i from t1 where x = 'hmm'");
        this.assertCompileError("42818", "select i from t1 where x > 0");
        this.assertCompileError("42818", "select i from t1 where x < x");
        this.assertCompileError("42818", "select i from t1 where x <> 'some char'");
    }

    public void testIllegalOps() throws Exception {
        this.assertCompileError("X0X67", "create index oops_ix on t1(x)");
        this.assertCompileError("X0X67", "select i from t1 where x is null order by x");
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE (  null, 'T1', 'extinout/xmlexport.del', null, null, null)");
        XMLTypeAndOpsTest.assertStatementError("42Z71", callableStatement);
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_EXPORT_QUERY(  'select x from t1', 'extinout/xmlexport.del', null, null, null)");
        XMLTypeAndOpsTest.assertStatementError("42Z71", callableStatement);
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE (  null, 'T1', 'extinout/shouldntmatter.del', null, null, null, 0)");
        XMLTypeAndOpsTest.assertStatementError("XIE0B", callableStatement);
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_DATA (  NULL, 'T1', null, '2', 'extinout/shouldntmatter.del', null, null, null,0)");
        XMLTypeAndOpsTest.assertStatementError("XIE0B", callableStatement);
        callableStatement.close();
        this.assertCompileError("42962", "create procedure hmmproc (in i int, in x xml)  parameter style java language java external name 'hi.there'");
        this.assertCompileError("42962", " create function hmmfunc (i int, x xml) returns int  parameter style java language java external name 'hi.there'");
        this.assertCompileError("42962", "declare global temporary table SESSION.xglobal (myx XML)  not logged on commit preserve rows");
    }

    public void testTriggerSetXML() throws Exception {
        this.assertCompileError("42821", "create trigger tr2 after insert on t1 for each row mode db2sql update t1 set x = 'hmm'");
        Statement statement = this.createStatement();
        statement.executeUpdate("create trigger tr1 after insert on t1 for each row mode db2sql update t1 set x = null");
        statement.executeUpdate(" drop trigger tr1");
        statement.close();
    }

    public void testXMLParse() throws Exception {
        Statement statement = this.createStatement();
        this.assertCompileError("42Z74", "insert into t1 values (1, xmlparse(document '<hmm/>' strip whitespace))");
        this.assertCompileError("42Z72", " insert into t1 values (1, xmlparse(document '<hmm/>'))");
        this.assertCompileError("42Z72", " insert into t1 values (1, xmlparse('<hmm/>' preserve whitespace))");
        this.assertCompileError("42Z74", " insert into t1 values (1, xmlparse(content '<hmm/>' preserve whitespace))");
        this.assertCompileError("42X25", " select xmlparse(document xmlparse(document '<hein/>' preserve whitespace) preserve whitespace) from t1");
        this.assertCompileError("42X19", " select i from t1 where xmlparse(document '<hein/>' preserve whitespace)");
        XMLTypeAndOpsTest.assertStatementError("2200M", statement, " insert into t1 values (1, xmlparse(document '<oops>' preserve whitespace))");
        this.assertCompileError("42Z79", "insert into t1(x) values XMLPARSE(document ? preserve whitespace)");
        this.assertCompileError("42894", "create table fail1 (i int, x xml default xmlparse(document '<my>default col</my>' preserve whitespace))");
        ResultSet resultSet = statement.executeQuery(" select i from t1 where xmlparse(document '<hein/>' preserve whitespace) is not null");
        String[] stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1"}, {"2"}, {"4"}, {"3"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select i from t1 where xmlparse(document '<hein/>' preserve whitespace) is not null order by i");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.execute("create table paramInsert(x xml)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into paramInsert values XMLPARSE(document cast (? as CLOB) preserve whitespace)");
        preparedStatement.setString(1, "<ay>caramba</ay>");
        XMLTypeAndOpsTest.assertUpdateCount(preparedStatement, 1);
        preparedStatement.close();
        resultSet = statement.executeQuery("select xmlserialize(x as clob) from t1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"<update2> document was inserted as part of an UPDATE </update2>"}, {null}, {null}, {null}, {"<hmm/>"}, {"<half> <masted> bass </masted> boosted. </half>"}, {"<umm> decl check </umm>"}, {"<lets> <try> this out </try> </lets>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlserialize(x as clob) from paramInsert");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"<ay>caramba</ay>"}};
        statement.executeUpdate("drop table paramInsert");
        statement.close();
    }

    public void testIsNull() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select i from t1 where x is not null");
        String[] stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select i from t1 where x is null");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2"}, {"4"}, {"3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.close();
    }

    public void testTopLevelSelect() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table vcTab (vc varchar(100))");
        this.assertCompileError("42Z71", "select x from t1");
        this.assertCompileError("42Z71", "select * from t1");
        this.assertCompileError("42Z71", " select xmlparse(document vc preserve whitespace) from vcTab");
        this.assertCompileError("42Z71", " values xmlparse(document '<bye/>' preserve whitespace)");
        this.assertCompileError("42Z71", " values xmlparse(document '<hel' || 'lo/>' preserve whitespace)");
        statement.executeUpdate("drop table vcTab");
        statement.close();
    }

    public void testXMLSerialize() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table vcTab (vc varchar(100))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, "insert into vcTab values ('<hmm/>')");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, "insert into vcTab values 'no good'");
        this.assertCompileError("42Z72", "select xmlserialize(x) from t1");
        this.assertCompileError("42X01", "select xmlserialize(x as) from t1");
        this.assertCompileError("42Z73", " select xmlserialize(x as int) from t1");
        this.assertCompileError("42Z73", " select xmlserialize(x as boolean) from t1");
        this.assertCompileError("42Z73", " select xmlserialize(x as varchar(20) for bit data) from t1");
        this.assertCompileError("42X04", " select xmlserialize(y as char(10)) from t1");
        this.assertCompileError("42X25", " select xmlserialize(xmlserialize(x as clob) as clob) from t1");
        this.assertCompileError("42X25", " values xmlserialize('<okay> dokie </okay>' as clob)");
        ResultSet resultSet = statement.executeQuery("select xmlserialize(x as clob) from t1");
        String[] stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"<update2> document was inserted as part of an UPDATE </update2>"}, {null}, {null}, {null}, {"<hmm/>"}, {"<half> <masted> bass </masted> boosted. </half>"}, {"<umm> decl check </umm>"}, {"<lets> <try> this out </try> </lets>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlserialize(x1 as clob), xmlserialize(x2 as clob) from t2");
        stringArray = new String[]{"1", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null, "<notnull/>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlserialize(x as char(100)) from t1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"<update2> document was inserted as part of an UPDATE </update2>"}, {null}, {null}, {null}, {"<hmm/>"}, {"<half> <masted> bass </masted> boosted. </half>"}, {"<umm> decl check </umm>"}, {"<lets> <try> this out </try> </lets>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlserialize(x as varchar(300)) from t1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"<update2> document was inserted as part of an UPDATE </update2>"}, {null}, {null}, {null}, {"<hmm/>"}, {"<half> <masted> bass </masted> boosted. </half>"}, {"<umm> decl check </umm>"}, {"<lets> <try> this out </try> </lets>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        XMLTypeAndOpsTest.assertStatementError("2200M", statement, "select xmlserialize(xmlparse(document vc preserve whitespace) as char(10)) from vcTab");
        XMLTypeAndOpsTest.assertStatementError("22001", statement, " select xmlserialize(x as char) from t1");
        XMLTypeAndOpsTest.assertStatementError("22001", statement, " select xmlserialize(x as clob(10)) from t1");
        XMLTypeAndOpsTest.assertStatementError("22001", statement, " select xmlserialize(x as char(1)) from t1");
        XMLTypeAndOpsTest.assertStatementError("22001", statement, " select length(xmlserialize(x as char(1))) from t1");
        XMLTypeAndOpsTest.assertStatementError("22001", statement, " select xmlserialize(x as varchar(1)) from t1");
        XMLTypeAndOpsTest.assertStatementError("22001", statement, " select length(xmlserialize(x as varchar(1))) from t1");
        resultSet = statement.executeQuery("select xmlserialize(x as char(100)) from t1");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        XMLTypeAndOpsTest.assertEquals((String)"Incorrect XMLSERIALIZE result type:", (int)1, (int)resultSetMetaData.getColumnType(1));
        resultSet = statement.executeQuery("select xmlserialize(x as varchar(100)) from t1");
        resultSetMetaData = resultSet.getMetaData();
        XMLTypeAndOpsTest.assertEquals((String)"Incorrect XMLSERIALIZE result type:", (int)12, (int)resultSetMetaData.getColumnType(1));
        resultSet = statement.executeQuery("select xmlserialize(x as long varchar) from t1");
        resultSetMetaData = resultSet.getMetaData();
        XMLTypeAndOpsTest.assertEquals((String)"Incorrect XMLSERIALIZE result type:", (int)-1, (int)resultSetMetaData.getColumnType(1));
        resultSet = statement.executeQuery("select xmlserialize(x as clob(100)) from t1");
        resultSetMetaData = resultSet.getMetaData();
        XMLTypeAndOpsTest.assertEquals((String)"Incorrect XMLSERIALIZE result type:", (int)2005, (int)resultSetMetaData.getColumnType(1));
        resultSet.close();
        statement.executeUpdate("drop table vcTab");
        statement.close();
    }

    public void testXMLParseSerializeCombos() throws Exception {
        Statement statement = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("2200M", statement, "select xmlserialize(xmlparse(document '<hmm>' preserve whitespace) as clob) from t1");
        this.assertCompileError("42X25", " select xmlserialize(xmlparse(document x preserve whitespace) as char(100)) from t1");
        ResultSet resultSet = statement.executeQuery("select xmlserialize(xmlparse(document '<hmm/>' preserve whitespace) as clob) from t1 where i = 1");
        String[] stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"<hmm/>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlserialize(xmlparse(document xmlserialize(x as clob) preserve whitespace) as clob) from t1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"<update2> document was inserted as part of an UPDATE </update2>"}, {null}, {null}, {null}, {"<hmm/>"}, {"<half> <masted> bass </masted> boosted. </half>"}, {"<umm> decl check </umm>"}, {"<lets> <try> this out </try> </lets>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("values xmlserialize(xmlparse(document '<okay> dokie </okay>' preserve whitespace) as clob)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"<okay> dokie </okay>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i from t1 where xmlparse(document xmlserialize(x as clob) preserve whitespace) is not null order by i");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.close();
    }

    public void testXMLExists() throws Exception {
        this.assertCompileError("42X01", "select i from t1 where xmlexists(x)");
        this.assertCompileError("42X01", "select i from t1 where xmlexists(i)");
        this.assertCompileError("42X01", "select i from t1 where xmlexists('//*')");
        this.assertCompileError("42X01", "select i from t1 where xmlexists('//*' x)");
        this.assertCompileError("42X01", "select i from t1 where xmlexists('//*' passing x)");
        this.assertCompileError("42Z74", "select i from t1 where xmlexists('//*' passing by value x)");
        this.assertCompileError("42Z77", "select i from t1 where xmlexists('//*' passing by ref i)");
        this.assertCompileError("42Z75", "select i from t1 where xmlexists(i passing by ref x)");
        this.assertCompileError("42Z76", "select i from t1 where xmlexists(i passing by ref x, x)");
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select i from t1 where xmlexists('//*' passing by ref x)");
        String[] stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i from t1 where xmlexists('//person' passing by ref x)");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select i from t1 where xmlexists('//lets' passing by ref x)");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlexists('//lets' passing by ref x) from t1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"false"}, {null}, {null}, {null}, {"false"}, {"false"}, {"false"}, {"true"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlexists('//try[text()='' this out '']' passing by ref x) from t1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"false"}, {null}, {null}, {null}, {"false"}, {"false"}, {"false"}, {"true"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlexists('//let' passing by ref x) from t1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"false"}, {null}, {null}, {null}, {"false"}, {"false"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlexists('//try[text()='' this in '']' passing by ref x) from t1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"false"}, {null}, {null}, {null}, {"false"}, {"false"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i, xmlexists('//let' passing by ref x) from t1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "false"}, {"2", null}, {"4", null}, {"3", null}, {"5", "false"}, {"6", "false"}, {"7", "false"}, {"8", "false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i, xmlexists('//lets' passing by ref x) from t1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "false"}, {"2", null}, {"4", null}, {"3", null}, {"5", "false"}, {"6", "false"}, {"7", "false"}, {"8", "true"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("values xmlexists('//let' passing by ref xmlparse(document '<lets> try this </lets>' preserve whitespace))");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("values xmlexists('//lets' passing by ref xmlparse(document '<lets> try this </lets>' preserve whitespace))");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"true"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("values xmlexists('//lets/@doit' passing by ref xmlparse(document '<lets doit=\"true\"> try this </lets>' preserve whitespace))");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"true"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("values xmlexists('//lets/@dot' passing by ref xmlparse(document '<lets doit=\"true\"> try this </lets>' preserve whitespace))");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlserialize(x1 as clob) from t2 where xmlexists('//*' passing by ref x1)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select xmlserialize(x2 as clob) from t2 where xmlexists('//*' passing by ref x2)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"<notnull/>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlserialize(x1 as clob), xmlexists('//*' passing by ref xmlparse(document '<badboy/>' preserve whitespace)) from t2");
        stringArray = new String[]{"1", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null, "true"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlserialize(x1 as clob), xmlexists('//goodboy' passing by ref xmlparse(document '<badboy/>' preserve whitespace)) from t2");
        stringArray = new String[]{"1", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null, "false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table xqExists2 (i int, x1 xml, x2 xml not null)");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into xqExists2 values (1, null, xmlparse(document '<ok/>' preserve whitespace))");
        resultSet = statement.executeQuery("select i, xmlserialize(x1 as char(10)), xmlserialize (x2 as char(10)) from xqExists2");
        stringArray = new String[]{"I", "2", "3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", null, "<ok/>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i from xqExists2 where xmlexists('/ok' passing by ref x1) and xmlexists('/ok' passing by ref x2)");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select i from xqExists2 where xmlexists('/ok' passing by ref x1) or xmlexists('/ok' passing by ref x2)");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table xqExists1 (i int, x xml check (xmlexists('//should' passing by ref x)))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into xqExists1 values (1, xmlparse(document '<should/>' preserve whitespace))");
        XMLTypeAndOpsTest.assertStatementError("23513", statement, " insert into xqExists1 values (1, xmlparse(document '<shouldnt/>' preserve whitespace))");
        resultSet = statement.executeQuery("select xmlserialize(x as char(20)) from xqExists1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"<should/>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table xqExists3 (i int, x xml)");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into xqExists3 values (1, xmlparse(document '<a:hi xmlns:a=\"http://www.hi.there\"/>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into xqExists3 values (2, xmlparse(document '<b:hi xmlns:b=\"http://www.hi.there\"/>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into xqExists3 values (3, xmlparse(document '<a:bye xmlns:a=\"http://www.good.bye\"/>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into xqExists3 values (4, xmlparse(document '<b:bye xmlns:b=\"http://www.hi.there\"/>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into xqExists3 values (5, xmlparse(document '<hi/>' preserve whitespace))");
        resultSet = statement.executeQuery("select xmlexists('//child::*[name()=\"none\"]' passing by ref x) from xqExists3");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"false"}, {"false"}, {"false"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlexists('//child::*[name()=''hi'']' passing by ref x) from xqExists3");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"false"}, {"false"}, {"false"}, {"false"}, {"true"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlexists('//child::*[local-name()=''hi'']' passing by ref x) from xqExists3");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"true"}, {"true"}, {"false"}, {"false"}, {"true"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlexists('//child::*[local-name()=''bye'']' passing by ref x) from xqExists3");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"false"}, {"false"}, {"true"}, {"true"}, {"false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlexists('//*[namespace::*[string()=''http://www.hi.there'']]' passing by ref x) from xqExists3");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"true"}, {"true"}, {"false"}, {"true"}, {"false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlexists('//*[namespace::*[string()=''http://www.good.bye'']]' passing by ref x) from xqExists3");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"false"}, {"false"}, {"true"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlexists('//child::*[local-name()=''hi'' and namespace::*[string()=''http://www.hi.there'']]' passing by ref x) from xqExists3");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"true"}, {"true"}, {"false"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlexists('//child::*[local-name()=''bye'' and namespace::*[string()=''http://www.good.bye'']]' passing by ref x) from xqExists3");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"false"}, {"false"}, {"true"}, {"false"}, {"false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select xmlexists('//child::*[local-name()=''bye'' and namespace::*[string()=''http://www.hi.there'']]' passing by ref x) from xqExists3");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"false"}, {"false"}, {"false"}, {"true"}, {"false"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        objectArray = new String[][]{{"true"}, {"true"}, {"true"}, {"true"}, {"true"}};
        JDBC.assertFullResultSet(statement.executeQuery("select xmlexists('1+1' passing by ref x) from xqExists3"), (String[][])objectArray);
        JDBC.assertFullResultSet(statement.executeQuery("select xmlexists('1=2' passing by ref x) from xqExists3"), (String[][])objectArray);
        statement.executeUpdate("drop table xqExists1");
        statement.executeUpdate("drop table xqExists2");
        statement.executeUpdate("drop table xqExists3");
        statement.close();
    }

    public void testXMLQuery() throws Exception {
        Object object;
        this.assertCompileError("42X01", "select i, xmlquery('//*') from t1");
        this.assertCompileError("42X01", " select i, xmlquery('//*' passing) from t1");
        this.assertCompileError("42X01", " select i, xmlquery('//*' passing by ref x) from t1");
        this.assertCompileError("42X01", " select i, xmlquery('//*' passing by ref x returning sequence) from t1");
        this.assertCompileError("42X01", " select i, xmlquery(passing by ref x empty on empty) from t1");
        this.assertCompileError("42X01", " select i, xmlquery(xmlquery('//*' returning sequence empty on empty) as char(75)) from t1");
        this.assertCompileError("42Z74", "select i, xmlquery('//*' passing by ref x returning sequence null on empty) from t1");
        this.assertCompileError("42Z74", " select i, xmlquery('//*' passing by ref x returning content empty on empty) from t1");
        this.assertCompileError("42Z71", "select i, xmlquery('//*' passing by ref x empty on empty) from t1");
        this.assertCompileError("42Z77", "select i, xmlquery('//*' passing by ref i empty on empty) from t1");
        this.assertCompileError("42Z77", " select i, xmlquery('//*' passing by ref 'hello' empty on empty) from t1");
        this.assertCompileError("42Z77", " select i, xmlquery('//*' passing by ref cast ('hello' as clob) empty on empty) from t1");
        this.assertCompileError("10000", "select i,  xmlserialize(    xmlquery('data(//@*)' passing by ref x returning sequence empty on empty)  as char(70))from t1");
        try {
            this.prepareStatement("select i,  xmlserialize(    xmlquery('myns:data(//@*)' passing by ref x returning sequence empty on empty)  as char(70))from t1");
            XMLTypeAndOpsTest.fail((String)"Compilation should fail because of unrecognized namespace");
        }
        catch (SQLException sQLException) {
            XMLTypeAndOpsTest.assertSQLState("10000", sQLException);
            object = sQLException;
            while ((object = ((Throwable)object).getCause()) != null) {
                if (!(object instanceof NullPointerException)) continue;
                XMLTypeAndOpsTest.fail("No NPE, please!", (Throwable)object);
            }
        }
        Statement statement = this.createStatement();
        object = statement.executeQuery("select i,  xmlserialize(    xmlquery('2+2' passing by ref x returning sequence empty on empty)  as char(70))from t1");
        String[] stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames((ResultSet)object, stringArray);
        Object[][] objectArray = new String[][]{{"1", "4"}, {"2", null}, {"4", null}, {"3", null}, {"5", "4"}, {"6", "4"}, {"7", "4"}, {"8", "4"}};
        JDBC.assertFullResultSet((ResultSet)object, objectArray, true);
        object = statement.executeQuery("select i,  xmlserialize(    xmlquery('./notthere' passing by ref x returning sequence empty on empty)  as char(70))from t1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames((ResultSet)object, stringArray);
        objectArray = new String[][]{{"1", ""}, {"2", null}, {"4", null}, {"3", null}, {"5", ""}, {"6", ""}, {"7", ""}, {"8", ""}};
        JDBC.assertFullResultSet((ResultSet)object, objectArray, true);
        object = statement.executeQuery("select i,  xmlserialize(    xmlquery('//*' passing by ref x empty on empty)  as char(70))from t1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames((ResultSet)object, stringArray);
        objectArray = new String[][]{{"1", "<update2> document was inserted as part of an UPDATE </update2>"}, {"2", null}, {"4", null}, {"3", null}, {"5", "<hmm/>"}, {"6", "<half> <masted> bass </masted> boosted. </half><masted> bass </masted>"}, {"7", "<umm> decl check </umm>"}, {"8", "<lets> <try> this out </try> </lets><try> this out </try>"}};
        JDBC.assertFullResultSet((ResultSet)object, objectArray, true);
        object = statement.executeQuery("select i,  xmlserialize(    xmlquery('//*[text() = \" bass \"]' passing by ref x empty on empty)  as char(70))from t1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames((ResultSet)object, stringArray);
        objectArray = new String[][]{{"1", ""}, {"2", null}, {"4", null}, {"3", null}, {"5", ""}, {"6", "<masted> bass </masted>"}, {"7", ""}, {"8", ""}};
        JDBC.assertFullResultSet((ResultSet)object, objectArray, true);
        object = statement.executeQuery("select i,  xmlserialize(    xmlquery('//lets' passing by ref x empty on empty)  as char(70))from t1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames((ResultSet)object, stringArray);
        objectArray = new String[][]{{"1", ""}, {"2", null}, {"4", null}, {"3", null}, {"5", ""}, {"6", ""}, {"7", ""}, {"8", "<lets> <try> this out </try> </lets>"}};
        JDBC.assertFullResultSet((ResultSet)object, objectArray, true);
        object = statement.executeQuery("select i,  xmlserialize(    xmlquery('//text()' passing by ref x empty on empty)  as char(70))from t1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames((ResultSet)object, stringArray);
        objectArray = new String[][]{{"1", "document was inserted as part of an UPDATE"}, {"2", null}, {"4", null}, {"3", null}, {"5", ""}, {"6", "bass  boosted."}, {"7", "decl check"}, {"8", "this out"}};
        JDBC.assertFullResultSet((ResultSet)object, objectArray, true);
        object = statement.executeQuery("select i,  xmlserialize(    xmlquery('//try[text()='' this out '']' passing by ref x empty on empty)  as char(70))from t1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames((ResultSet)object, stringArray);
        objectArray = new String[][]{{"1", ""}, {"2", null}, {"4", null}, {"3", null}, {"5", ""}, {"6", ""}, {"7", ""}, {"8", "<try> this out </try>"}};
        JDBC.assertFullResultSet((ResultSet)object, objectArray, true);
        object = statement.executeQuery("select i,  xmlserialize(    xmlquery('//try[text()='' this in '']' passing by ref x empty on empty)  as char(70))from t1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames((ResultSet)object, stringArray);
        objectArray = new String[][]{{"1", ""}, {"2", null}, {"4", null}, {"3", null}, {"5", ""}, {"6", ""}, {"7", ""}, {"8", ""}};
        JDBC.assertFullResultSet((ResultSet)object, objectArray, true);
        object = statement.executeQuery("select i,  xmlserialize(    xmlquery('2+.//try' passing by ref x returning sequence empty on empty)  as char(70))from t1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames((ResultSet)object, stringArray);
        objectArray = new String[][]{{"1", "NaN"}, {"2", null}, {"4", null}, {"3", null}, {"5", "NaN"}, {"6", "NaN"}, {"7", "NaN"}, {"8", "NaN"}};
        JDBC.assertFullResultSet((ResultSet)object, objectArray, true);
        object = statement.executeQuery("values ('x', xmlserialize(  xmlquery('//let' passing by ref    xmlparse(document '<lets> try this </lets>' preserve whitespace)  empty on empty)as char(30)))");
        stringArray = new String[]{"1", "2"};
        JDBC.assertColumnNames((ResultSet)object, stringArray);
        objectArray = new String[][]{{"x", ""}};
        JDBC.assertFullResultSet((ResultSet)object, objectArray, true);
        object = statement.executeQuery("values xmlserialize(  xmlquery('//lets' passing by ref    xmlparse(document '<lets> try this </lets>' preserve whitespace)  empty on empty)as char(30))");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames((ResultSet)object, stringArray);
        objectArray = new String[][]{{"<lets> try this </lets>"}};
        JDBC.assertFullResultSet((ResultSet)object, objectArray, true);
        statement.close();
    }

    public void testXMLQueryInsert() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table xqInsert1 (i int, x xml not null)");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into xqInsert1 values (1, xmlparse(document '<should> work as planned </should>' preserve whitespace))");
        statement.executeUpdate("create table xqInsert2 (i int, x xml default null)");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, "insert into xqInsert2 values (  9,  xmlparse(document '<here><is><my height=\"4.4\">attribute</my></is></here>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into xqInsert2 values (  0,  xmlparse(document '<there><goes><my weight=\"180\">attribute</my></goes></there>' preserve whitespace))");
        ResultSet resultSet = statement.executeQuery("select i, xmlserialize(x as char(75)) from xqInsert1");
        String[] stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "<should> work as planned </should>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i, xmlserialize(x as char(75)) from xqInsert2");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"9", "<here><is><my height=\"4.4\">attribute</my></is></here>"}, {"0", "<there><goes><my weight=\"180\">attribute</my></goes></there>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        XMLTypeAndOpsTest.assertStatementError("2200L", statement, "insert into xqInsert1 (i, x) values (  20,   (select    xmlquery('./notthere' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertStatementError("2200L", statement, " insert into xqInsert1 (i, x) values (  21,  (select    xmlquery('//@*' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertStatementError("2200L", statement, " insert into xqInsert1 (i, x) values (  22,  (select    xmlquery('. + 2' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertStatementError("2200L", statement, " insert into xqInsert1 (i, x) values (  23,  (select    xmlquery('//*' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertStatementError("2200L", statement, " insert into xqInsert1 (i, x) values (  24,  (select    xmlquery('//*[//@*]' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertStatementError("2200L", statement, " insert into xqInsert1 (i, x) values (  25,  (select    xmlquery('//is' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertStatementError("2200L", statement, " insert into xqInsert1 (i, x) values (  26,  (select    xmlquery('//*[@*]' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, "insert into xqInsert1 (i, x) values (  27,  (select    xmlquery('.' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into xqInsert1 (i, x) values (  28,  (select    xmlquery('/here/..' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 9  ))");
        resultSet = statement.executeQuery("select i, xmlserialize(x as char(75)) from xqInsert1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "<should> work as planned </should>"}, {"27", "<here><is><my height=\"4.4\">attribute</my></is></here>"}, {"28", "<here><is><my height=\"4.4\">attribute</my></is></here>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, "insert into xqInsert2 (i, x) values (  29,  (select    xmlquery('2+2' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 100  ))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into xqInsert2 (i, x) values (  30,  (select    xmlquery('.' passing by ref x returning sequence empty on empty)    from xqInsert2 where i = 100  ))");
        resultSet = statement.executeQuery("select i, xmlserialize(x as char(75)) from xqInsert2");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"9", "<here><is><my height=\"4.4\">attribute</my></is></here>"}, {"0", "<there><goes><my weight=\"180\">attribute</my></goes></there>"}, {"29", null}, {"30", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table xqInsert1");
        statement.executeUpdate("drop table xqInsert2");
        statement.close();
    }

    public void testXMLQueryUpdate() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table xqUpdate (i int, x xml default null)");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 2, "insert into xqUpdate (i) values 29, 30");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, "insert into xqUpdate values (  9,  xmlparse(document '<here><is><my height=\"4.4\">attribute</my></is></here>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, "update xqUpdate  set x =     xmlquery('.' passing by ref      xmlparse(document '<none><here/></none>' preserve whitespace)    returning sequence empty on empty)where i = 29");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " update xqUpdate  set x =     xmlquery('self::node()[//@height]' passing by ref      (select        xmlquery('.' passing by ref x empty on empty)        from xqUpdate        where i = 9      )    empty on empty)where i = 30");
        XMLTypeAndOpsTest.assertStatementError("2200L", statement, "update xqUpdate  set x = xmlquery('.//*' passing by ref x empty on empty)where i = 29");
        XMLTypeAndOpsTest.assertStatementError("2200L", statement, " update xqUpdate  set x = xmlquery('./notthere' passing by ref x empty on empty)where i = 30");
        XMLTypeAndOpsTest.assertStatementError("2200L", statement, " update xqUpdate  set x =    xmlquery('//*[@weight]' passing by ref      (select        xmlquery('.' passing by ref x empty on empty)        from xqUpdate        where i = 9      )    empty on empty)where i = 30");
        XMLTypeAndOpsTest.assertStatementError("2200L", statement, " update xqUpdate  set x =    xmlquery('//*/@height' passing by ref      (select        xmlquery('.' passing by ref x empty on empty)        from xqUpdate        where i = 9      )    empty on empty)where i = 30");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 0, "update xqUpdate  set x = xmlquery('//*' passing by ref x empty on empty)where i = 100");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 0, " update xqUpdate  set x = xmlquery('4+4' passing by ref x empty on empty)where i = 100");
        ResultSet resultSet = statement.executeQuery("select i, xmlserialize(x as char(75)) from xqUpdate");
        String[] stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"29", "<none><here/></none>"}, {"30", "<here><is><my height=\"4.4\">attribute</my></is></here>"}, {"9", "<here><is><my height=\"4.4\">attribute</my></is></here>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table xqUpdate");
        statement.close();
    }

    public void testNestedXMLQuery() throws Exception {
        Statement statement = this.createStatement();
        XMLTypeAndOpsTest.assertStatementError("2200V", statement, "select i,  xmlserialize(    xmlquery('//lets/@*' passing by ref      xmlquery('/okay/text()' passing by ref        xmlparse(document '<okay><lets boki=\"inigo\"/></okay>' preserve whitespace)      empty on empty)    empty on empty)  as char(100))from t1 where i > 5");
        XMLTypeAndOpsTest.assertStatementError("2200V", statement, " select i,  xmlserialize(    xmlquery('.' passing by ref      xmlquery('//lets' passing by ref        xmlparse(document '<okay><lets boki=\"inigo\"/></okay>' preserve whitespace)      empty on empty)    empty on empty)  as char(100))from t1 where i > 5");
        XMLTypeAndOpsTest.assertStatementError("2200V", statement, " select i,  xmlexists('.' passing by ref    xmlquery('/okay' passing by ref      xmlparse(document '<okay><lets boki=\"inigo\"/></okay>' preserve whitespace)    empty on empty)  )from t1 where i > 5");
        ResultSet resultSet = statement.executeQuery("select i,  xmlserialize(    xmlquery('/not' passing by ref      xmlquery('.' passing by ref        xmlparse(document '<okay><lets boki=\"inigo\"/></okay>' preserve whitespace)      empty on empty)    empty on empty)  as char(100))from t1 where i > 5");
        String[] stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"6", ""}, {"7", ""}, {"8", ""}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i,  xmlserialize(    xmlquery('//lets' passing by ref      xmlquery('.' passing by ref        xmlparse(document '<okay><lets boki=\"inigo\"/></okay>' preserve whitespace)      empty on empty)    empty on empty)  as char(100))from t1 where i > 5");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"6", "<lets boki=\"inigo\"/>"}, {"7", "<lets boki=\"inigo\"/>"}, {"8", "<lets boki=\"inigo\"/>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i,  xmlserialize(    xmlquery('string(//@boki)' passing by ref      xmlquery('/okay/..' passing by ref        xmlparse(document '<okay><lets boki=\"inigo\"/></okay>' preserve whitespace)      empty on empty)    empty on empty)  as char(100))from t1 where i > 5");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"6", "inigo"}, {"7", "inigo"}, {"8", "inigo"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i,  xmlserialize(    xmlquery('/half/masted/text()' passing by ref      xmlquery('.' passing by ref x empty on empty)    empty on empty)  as char(100))from t1 where i = 6");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"6", "bass"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i,  xmlexists('/half/masted/text()' passing by ref    xmlquery('.' passing by ref x empty on empty)  )from t1 where i = 6");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"6", "true"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.close();
    }

    public void testAttrSerialization() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table attserTable (i int, x xml)");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, "insert into attserTable values (0, null)");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, "insert into attserTable values (10,  xmlparse(document    '<threeatts first=\"1\" second=\"two\" third=\"le 3 trois\"/>'    preserve whitespace  ))");
        ResultSet resultSet = statement.executeQuery("select i, xmlserialize(x as char(75)) from attserTable");
        String[] stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"0", null}, {"10", "<threeatts first=\"1\" second=\"two\" third=\"le 3 trois\"/>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        XMLTypeAndOpsTest.assertStatementError("2200W", statement, "select  xmlserialize(    xmlquery(      '//@*' passing by ref x empty on empty    )  as char(50)) from attserTable where xmlexists('//@*' passing by ref x)");
        resultSet = statement.executeQuery("select  xmlserialize(    xmlquery(      'string(//@*)'      passing by ref x empty on empty    )  as char(50)) from attserTable where xmlexists('//@*' passing by ref x)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select  max(    cast(      xmlserialize(        xmlquery('count(//@*)' passing by ref x empty on empty)      as char(50))    as int)  ) from attserTable");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true, false);
        if (XMLTypeAndOpsTest.usingEmbedded()) {
            SQLWarning sQLWarning = resultSet.getWarnings();
            if (sQLWarning == null) {
                sQLWarning = statement.getWarnings();
            }
            if (sQLWarning == null) {
                sQLWarning = this.getConnection().getWarnings();
            }
            XMLTypeAndOpsTest.assertTrue((String)"Expected warning but found none.", (sQLWarning != null ? 1 : 0) != 0);
            XMLTypeAndOpsTest.assertSQLState("01003", sQLWarning);
        }
        resultSet.close();
        resultSet = statement.executeQuery("select  xmlserialize(    xmlquery(      'concat(string(//@*[1]), \" \",        string(//@*[2]), \" \",        string(//@*[3]))'      passing by ref x empty on empty    )  as char(50)) from attserTable where xmlexists('//@*' passing by ref x)");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1 two le 3 trois"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table attserTable");
        statement.close();
    }

    public void testTriggerSPSWithXML() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table trigSPS1 (i int, x xml)");
        statement.executeUpdate("create table trigSPS2 (i int, x xml)");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into trigSPS1 values (1, xmlparse(document '<name> john </name>' preserve whitespace))");
        statement.executeUpdate("create trigger tx after insert on trigSPS1 for each statement mode db2sql insert into trigSPS2 values (1, xmlparse(document '<name> jane </name>' preserve whitespace))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into trigSPS1 values (2, xmlparse(document '<name> ally </name>' preserve whitespace))");
        ResultSet resultSet = statement.executeQuery("select i, xmlserialize(x as varchar(20)) from trigSPS1");
        String[] stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "<name> john </name>"}, {"2", "<name> ally </name>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i, xmlserialize(x as varchar(20)) from trigSPS2");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "<name> jane </name>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        XMLTypeAndOpsTest.assertUpdateCount(statement, 2, "insert into trigSPS1 select * from trigSPS1");
        resultSet = statement.executeQuery("select i, xmlserialize(x as varchar(20)) from trigSPS1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "<name> john </name>"}, {"2", "<name> ally </name>"}, {"1", "<name> john </name>"}, {"2", "<name> ally </name>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i, xmlserialize(x as varchar(20)) from trigSPS2");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "<name> jane </name>"}, {"1", "<name> jane </name>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop trigger tx");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 4, "delete from trigSPS1");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 2, "delete from trigSPS2");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into trigSPS1 values (1, xmlparse(document '<name> john </name>' preserve whitespace))");
        statement.executeUpdate("create trigger tx after insert on trigSPS1 for each statement mode db2sql insert into trigSPS2 values (1, (select xmlquery('.' passing by ref x returning sequence empty on empty) from trigSPS1 where i = 1))");
        XMLTypeAndOpsTest.assertUpdateCount(statement, 1, " insert into trigSPS1 values (2, xmlparse(document '<name> ally </name>' preserve whitespace))");
        resultSet = statement.executeQuery("select i, xmlserialize(x as varchar(20)) from trigSPS1");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "<name> john </name>"}, {"2", "<name> ally </name>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select i, xmlserialize(x as varchar(20)) from trigSPS2");
        stringArray = new String[]{"I", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "<name> john </name>"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop trigger tx");
        statement.executeUpdate("drop table trigSPS1");
        statement.executeUpdate("drop table trigSPS2");
        statement.close();
    }

    public void testNumericReturnValues() throws SQLException {
        String[][] stringArrayArray = new String[][]{{"9223372036854775807", "9223372036854776000"}, {"9223372036854775807123456789", "9223372036854776000000000000"}, {"123 div 1000000000000", "0.000000000123"}, {"1", "1"}, {"1.0", "1"}, {"1.000", "1"}, {"1.00010", "1.0001"}, {"-0", "0"}, {"-0.0", "0"}, {"-0.00", "0"}, {"0 div 0", "NaN"}, {"3.14 div 0", "Infinity"}, {"-3.14 div 0", "-Infinity"}, {"1=1", "true"}, {"1=2", "false"}};
        Statement statement = this.createStatement();
        for (int i = 0; i < stringArrayArray.length; ++i) {
            String string = stringArrayArray[i][0];
            String string2 = stringArrayArray[i][1];
            String string3 = "select xmlserialize(xmlquery('" + string + "' passing by ref x empty on empty) as clob) from t1 where i = 1";
            JDBC.assertSingleValueResultSet(statement.executeQuery(string3), string2);
        }
    }

    private static class XMLTestSetup
    extends BaseJDBCTestSetup {
        public XMLTestSetup(BaseTestSuite baseTestSuite) {
            super((Test)baseTestSuite);
        }

        public void setUp() throws Exception {
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement();
            statement.executeUpdate("create table t1 (i int, x xml)");
            statement.executeUpdate("create table t2 (x2 xml not null)");
            statement.executeUpdate("alter table t2 add column x1 xml");
            BaseJDBCTestCase.assertUpdateCount(statement, 1, "insert into t1 values (1, null)");
            BaseJDBCTestCase.assertUpdateCount(statement, 1, "insert into t1 values (2, cast (null as xml))");
            BaseJDBCTestCase.assertUpdateCount(statement, 1, "insert into t1 (i) values (4)");
            BaseJDBCTestCase.assertUpdateCount(statement, 1, "insert into t1 values (3, default)");
            BaseJDBCTestCase.assertUpdateCount(statement, 1, "insert into t1 values (5, xmlparse(document '<hmm/>' preserve whitespace))");
            BaseJDBCTestCase.assertUpdateCount(statement, 1, " insert into t1 values (6, xmlparse(document '<half> <masted> bass </masted> boosted. </half>' preserve whitespace))");
            BaseJDBCTestCase.assertUpdateCount(statement, 1, " insert into t2 (x1, x2) values (null, xmlparse(document '<notnull/>' preserve whitespace))");
            BaseJDBCTestCase.assertUpdateCount(statement, 1, " insert into t1 values (7, xmlparse(document '<?xml version=\"1.0\" encoding= \"UTF-8\"?><umm> decl check </umm>' preserve whitespace))");
            BaseJDBCTestCase.assertUpdateCount(statement, 1, "insert into t1 values (8, xmlparse(document '<lets> <try> this out </try> </lets>' preserve whitespace))");
            BaseJDBCTestCase.assertUpdateCount(statement, 1, " update t1 set x = xmlparse(document '<update> document was inserted as part of an UPDATE </update>' preserve whitespace) where i = 1");
            BaseJDBCTestCase.assertUpdateCount(statement, 1, " update t1 set x = xmlparse(document '<update2> document was inserted as part of an UPDATE </update2>' preserve whitespace) where xmlexists('/update' passing by ref x)");
            statement.close();
            connection.close();
            statement = null;
            connection = null;
        }

        @Override
        public void tearDown() throws Exception {
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement();
            statement.executeUpdate("drop table t1");
            statement.executeUpdate("drop table t2");
            statement.close();
            connection.close();
            statement = null;
            connection = null;
            super.tearDown();
        }
    }
}

