/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.sql.DatabaseMetaData;
import java.util.Hashtable;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derbyTesting.functionTests.tests.management.MBeanTest;

public class JDBCMBeanTest
extends MBeanTest {
    public JDBCMBeanTest(String string) {
        super(string);
    }

    public static Test suite() {
        return MBeanTest.suite(JDBCMBeanTest.class, "JDBCMBeanTest");
    }

    private ObjectName getJdbcMBeanObjectName() throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", "JDBC");
        return this.getDerbyMBeanName(hashtable);
    }

    public void testAttributeCompliantDriver() throws Exception {
        this.assertBooleanAttribute(true, this.getJdbcMBeanObjectName(), "CompliantDriver");
    }

    public void testAttributeDriverLevel() throws Exception {
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        String string = databaseMetaData.getJDBCMajorVersion() + "." + databaseMetaData.getJDBCMinorVersion();
        String string2 = (String)this.getAttribute(this.getJdbcMBeanObjectName(), "DriverLevel");
        JDBCMBeanTest.println("DatabaseMetaDataJDBCLevel = " + string);
        JDBCMBeanTest.println("MBean driverLevel  = " + string2);
        JDBCMBeanTest.assertEquals((String)("Unexpected driver level string: " + string2 + " JDBCVersion: " + string), (int)-1, (int)string2.indexOf(63));
        JDBCMBeanTest.assertTrue((String)("Unexpected driver level string: " + string2 + " JDBCVersion: " + string), (boolean)string2.matches("^J.*SE.* - JDBC .*" + string));
    }

    public void testAttributeMajorVersion() throws Exception {
        EmbeddedDriver embeddedDriver = new EmbeddedDriver();
        int n = embeddedDriver.getMajorVersion();
        this.assertIntAttribute(n, this.getJdbcMBeanObjectName(), "MajorVersion");
    }

    public void testAttributeMinorVersion() throws Exception {
        EmbeddedDriver embeddedDriver = new EmbeddedDriver();
        int n = embeddedDriver.getMinorVersion();
        this.assertIntAttribute(n, this.getJdbcMBeanObjectName(), "MinorVersion");
    }

    public void testOperationAcceptsURL() throws Exception {
        String string = "acceptsURL";
        ObjectName objectName = this.getJdbcMBeanObjectName();
        Object[] objectArray = new Object[1];
        String[] stringArray = new String[]{"java.lang.String"};
        objectArray[0] = "jdbc:derby:testDatabase";
        Boolean bl = (Boolean)this.invokeOperation(objectName, string, objectArray, stringArray);
        JDBCMBeanTest.assertTrue((String)("URL: " + String.valueOf(objectArray[0])), (boolean)bl);
        objectArray[0] = "jdbc:derby:testDB;create=true;user=tester;password=mypass";
        bl = (Boolean)this.invokeOperation(objectName, string, objectArray, stringArray);
        JDBCMBeanTest.assertTrue((String)("URL: " + String.valueOf(objectArray[0])), (boolean)bl);
        objectArray[0] = "jdbc:invalidProtocol:newDatabase";
        bl = (Boolean)this.invokeOperation(objectName, string, objectArray, stringArray);
        JDBCMBeanTest.assertFalse((String)("URL: " + String.valueOf(objectArray[0])), (boolean)bl);
    }
}

