/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.management.JMXConnectionDecorator;
import org.apache.derbyTesting.functionTests.tests.management.JMXConnectionGetter;
import org.apache.derbyTesting.functionTests.tests.management.PlatformConnectionGetter;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

abstract class MBeanTest
extends BaseJDBCTestCase {
    private MBeanServerConnection jmxConnection;

    public MBeanTest(String string) {
        super(string);
    }

    protected static Test suite(Class<? extends MBeanTest> clazz, String string) {
        NetworkServerTestSetup networkServerTestSetup;
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        BaseTestSuite baseTestSuite2 = new BaseTestSuite(clazz, string + ":platform");
        baseTestSuite2 = TestConfiguration.clientServerDecorator((Test)baseTestSuite2);
        baseTestSuite2 = JMXConnectionDecorator.platformMBeanServer((Test)baseTestSuite2);
        baseTestSuite.addTest((Test)baseTestSuite2);
        BaseTestSuite baseTestSuite3 = new BaseTestSuite(clazz, string + ":client");
        baseTestSuite3 = JMXConnectionDecorator.remoteNoSecurity((Test)baseTestSuite3);
        NetworkServerTestSetup networkServerTestSetup2 = networkServerTestSetup = new NetworkServerTestSetup((Test)baseTestSuite3, MBeanTest.getCommandLineProperties(false), new String[0], true);
        baseTestSuite.addTest(TestConfiguration.defaultServerDecorator((Test)networkServerTestSetup2));
        return baseTestSuite;
    }

    protected static String[] getCommandLineProperties(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("com.sun.management.jmxremote.port=" + TestConfiguration.getCurrent().getJmxPort());
        arrayList.add("com.sun.management.jmxremote.authenticate=" + Boolean.toString(bl));
        arrayList.add("com.sun.management.jmxremote.ssl=false");
        arrayList.add("com.sun.management.jmxremote.serial.filter.pattern=");
        if (bl) {
            arrayList.add("com.sun.management.jmxremote.password.file=extin/jmx.password");
            arrayList.add("com.sun.management.jmxremote.access.file=extin/jmx.access");
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.enableManagement();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.jmxConnection != null) {
            JMXConnectionGetter.mbeanServerConnector.get().close(this.jmxConnection);
            this.jmxConnection = null;
        }
    }

    protected MBeanServerConnection getMBeanServerConnection() throws Exception {
        if (this.jmxConnection == null) {
            this.jmxConnection = JMXConnectionGetter.mbeanServerConnector.get().getMBeanServerConnection(null, null);
        }
        return this.jmxConnection;
    }

    protected MBeanServerConnection getMBeanServerConnection(String string, String string2) throws Exception {
        return JMXConnectionGetter.mbeanServerConnector.get().getMBeanServerConnection(string, string2);
    }

    protected boolean isPlatformJMXClient() {
        return JMXConnectionGetter.mbeanServerConnector.get() instanceof PlatformConnectionGetter;
    }

    protected void enableManagement() throws Exception {
        ObjectName objectName = this.getApplicationManagementMBean();
        Boolean bl = (Boolean)this.getAttribute(objectName, "ManagementActive");
        if (!bl.booleanValue()) {
            this.invokeOperation(objectName, "startManagement");
            bl = (Boolean)this.getAttribute(objectName, "ManagementActive");
        }
        MBeanTest.assertTrue((String)"Failed to activate Derby's JMX management", (boolean)bl);
    }

    protected Set<ObjectName> getDerbyDomainMBeans() throws Exception {
        ObjectName objectName = new ObjectName("org.apache.derby:*");
        return this.queryMBeans(objectName);
    }

    Set<ObjectName> queryMBeans(ObjectName objectName) throws Exception {
        MBeanServerConnection mBeanServerConnection = this.getMBeanServerConnection();
        return mBeanServerConnection.queryNames(objectName, null);
    }

    protected ObjectName getApplicationManagementMBean() throws Exception {
        ObjectName objectName = new ObjectName("org.apache.derby", "type", "Management");
        MBeanServerConnection mBeanServerConnection = this.getMBeanServerConnection();
        if (!mBeanServerConnection.isRegistered(objectName)) {
            mBeanServerConnection.createMBean("org.apache.derby.mbeans.Management", objectName);
        }
        return objectName;
    }

    protected ObjectName getDerbyMBeanName(Hashtable<String, String> hashtable) throws Exception {
        String string = (String)this.getAttribute(this.getApplicationManagementMBean(), "SystemIdentifier");
        if (string != null) {
            hashtable.put("system", string);
        }
        return new ObjectName("org.apache.derby", hashtable);
    }

    protected Object invokeOperation(ObjectName objectName, String string) throws Exception {
        return this.invokeOperation(objectName, string, new Object[0], new String[0]);
    }

    protected Object invokeOperation(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws Exception {
        MBeanServerConnection mBeanServerConnection = this.getMBeanServerConnection();
        return mBeanServerConnection.invoke(objectName, string, objectArray, stringArray);
    }

    void setAttribute(ObjectName objectName, String string, Object object) throws Exception {
        MBeanServerConnection mBeanServerConnection = this.getMBeanServerConnection();
        Attribute attribute = new Attribute(string, object);
        mBeanServerConnection.setAttribute(objectName, attribute);
    }

    protected Object getAttribute(ObjectName objectName, String string) throws Exception {
        MBeanServerConnection mBeanServerConnection = this.getMBeanServerConnection();
        return mBeanServerConnection.getAttribute(objectName, string);
    }

    protected void assertBooleanAttribute(boolean bl, ObjectName objectName, String string) throws Exception {
        Boolean bl2 = (Boolean)this.getAttribute(objectName, string);
        MBeanTest.assertNotNull((Object)bl2);
        MBeanTest.assertEquals((boolean)bl, (boolean)bl2);
    }

    protected void assertIntAttribute(int n, ObjectName objectName, String string) throws Exception {
        Integer n2 = (Integer)this.getAttribute(objectName, string);
        MBeanTest.assertNotNull((Object)n2);
        MBeanTest.assertEquals((int)n, (int)n2);
    }

    protected void assertLongAttribute(int n, ObjectName objectName, String string) throws Exception {
        Long l = (Long)this.getAttribute(objectName, string);
        MBeanTest.assertNotNull((Object)l);
        MBeanTest.assertEquals((long)n, (long)l);
    }

    protected void assertStringAttribute(String string, ObjectName objectName, String string2) throws Exception {
        String string3 = (String)this.getAttribute(objectName, string2);
        MBeanTest.assertNotNull((Object)string3);
        MBeanTest.assertEquals((String)string, (String)string3);
    }

    protected void checkBooleanAttributeValue(ObjectName objectName, String string) throws Exception {
        Object object = this.getAttribute(objectName, string);
        boolean bl = (Boolean)object;
        MBeanTest.println(string + " = " + bl);
    }

    protected void checkIntAttributeValue(ObjectName objectName, String string) throws Exception {
        Object object = this.getAttribute(objectName, string);
        int n = (Integer)object;
        MBeanTest.println(string + " = " + n);
    }

    protected void checkLongAttributeValue(ObjectName objectName, String string) throws Exception {
        Object object = this.getAttribute(objectName, string);
        long l = (Long)object;
        MBeanTest.println(string + " = " + l);
    }

    protected void checkStringAttributeValue(ObjectName objectName, String string) throws Exception {
        String string2 = (String)this.getAttribute(objectName, string);
        MBeanTest.println(string + " = " + string2);
    }
}

