/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ImportExportTest
extends BaseJDBCTestCase {
    public ImportExportTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ImportExportTest");
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite();
        }
        baseTestSuite.addTest(ImportExportTest.baseSuite("ImportExportTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ImportExportTest.baseSuite("ImportExportTest:client")));
        return baseTestSuite;
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(ImportExportTest.class, string);
        SupportFilesSetup supportFilesSetup = new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/testData/ImportExport/TwoLineBadEOF.dat"});
        return new CleanDatabaseTestSetup((Test)supportFilesSetup){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create type Price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
                statement.execute("create type hashmap external name 'java.util.HashMap' language java");
                statement.execute("create function makePrice( ) returns price language java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'");
                statement.execute("create function makeHashMap( ) returns hashmap language java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.UDTTest.makeHashMap'");
                statement.execute("CREATE TABLE T1 (COLUMN1 VARCHAR(5) , COLUMN2 VARCHAR(8) , COLUMN3 SMALLINT , COLUMN4 CHAR(11) , COLUMN5 DATE , COLUMN6 DECIMAL(5,1) , COLUMN7 DOUBLE PRECISION , COLUMN8 INT , COLUMN9 BIGINT , COLUMN10 NUMERIC , COLUMN11 REAL , COLUMN12 SMALLINT , COLUMN13 TIME , COLUMN14 TIMESTAMP , COLUMN15 SMALLINT , COLUMN16 VARCHAR(1), COLUMN17 PRICE)");
                statement.execute("CREATE TABLE T2 (COLUMN1 VARCHAR(5) , COLUMN2 VARCHAR(8) , COLUMN3 SMALLINT, COLUMN4 CHAR(11) , COLUMN5 DATE , COLUMN6 DECIMAL(5,1) , COLUMN7 DOUBLE PRECISION , COLUMN8 INT , COLUMN9 BIGINT , COLUMN10 NUMERIC , COLUMN11 REAL , COLUMN12 SMALLINT , COLUMN13 TIME , COLUMN14 TIMESTAMP , COLUMN15 SMALLINT , COLUMN16 VARCHAR(1), COLUMN17 PRICE)");
                statement.execute("create table T4 (   Account int,    Name   char(30), Jobdesc char(40), Company varchar(35), Address1 varchar(40), Address2 varchar(40), City    varchar(20), State   char(5), Zip char(10), Country char(10), Phone1  char(20), Phone2  char(20), email   char(30), web     char(30), Fname   char(30), Lname   char(30), Comment char(30), AccDate char(30), Payment decimal(8,2), Balance decimal(8,2))");
                statement.execute("create table t5( a int, b price )");
                statement.execute("create table t6( a int, b hashmap )");
            }
        };
    }

    protected void setUp() throws Exception {
        this.resetTables();
    }

    public void testImportFromNonExistantFile() {
        try {
            this.doImport("Z", null, "T1", null, null, null, 0);
            ImportExportTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportTest.assertSQLState("XIE04", sQLException);
        }
    }

    public void testNullDataFile() {
        try {
            this.doImport(null, null, "T1", null, null, null, 0);
            ImportExportTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportTest.assertSQLState("XIE05", sQLException);
        }
    }

    public void testEmptyTable() throws SQLException {
        this.doImportAndExport(null, "T1", null, null, null);
    }

    public void testEmptyTableWithDelimitedFormat() throws SQLException {
        this.doImportAndExport(null, "T1", null, null, "8859_1");
    }

    public void testEmptyTableWithFieldCharDelimiters() throws SQLException {
        this.doImportAndExport(null, "T1", "\t", "|", "8859_1");
    }

    public void testWithDefaultOptions() throws Exception {
        this.doImportAndExport(null, "T1", null, null, null);
    }

    public void testWithCodeset() throws Exception {
        this.doImportAndExport(null, "T1", null, null, "8859_1");
    }

    public void testDelimiterAndCodeset() throws Exception {
        this.doImportAndExport(null, "T1", "\t", "|", "8859_1");
    }

    public void testSpecialDelimitersAndCodeset() throws Exception {
        this.doImportAndExport(null, "T1", "%", "&", "Cp1252");
    }

    public void testSpecialDelimitersAndUTF16() throws Exception {
        this.doImportAndExport(null, "T1", "%", "&", "UTF-16");
    }

    public void testInvalidEncoding() throws Exception {
        try {
            this.doImportAndExport(null, "T1", "^", "#", "INAVALID ENCODING");
            ImportExportTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportTest.assertSQLState("XIE0I", sQLException);
        }
    }

    public void testEarlyEndOfFile() throws Exception {
        try {
            this.doImportFromFile("extin/TwoLineBadEOF.dat", null, "T4", null, null, "US-ASCII", 0);
            ImportExportTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportTest.assertSQLState("XIE0E", sQLException);
        }
    }

    public void testImportWithSameNameInDifferentSchema() throws Exception {
        this.doExport(null, "T1", null, null, null);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table otherschema.t2(x int)");
        this.doImport("T1", null, "T2", null, null, null, 0);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from app.t2"), "4");
        this.setAutoCommit(false);
        JDBC.dropSchema(this.getConnection().getMetaData(), "OTHERSCHEMA");
    }

    public void testQuotesInArguments() throws Exception {
        String string = JDBC.escape("s'\"", "t'\"");
        Statement statement = this.createStatement();
        statement.execute("create table " + string + " as select * from T1 with no data");
        statement.execute("insert into " + string + " select * from t1");
        String string2 = SupportFilesSetup.getReadWrite("please don't fail.dat").getPath();
        this.doExportToFile(string2, "s'\"", "t'\"", "'", "\"", "US-ASCII");
        int n = statement.executeUpdate("delete from " + string);
        this.doImportFromFile(string2, "s'\"", "t'\"", "'", "\"", "US-ASCII", 0);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from " + string), Integer.toString(n));
    }

    public void testQuotesInColumnNames() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table table_with_funny_cols_src (x int, \"Let's try this! \"\" :)\" int)");
        statement.execute("insert into table_with_funny_cols_src values (1,2), (3,4)");
        this.doExport(null, "TABLE_WITH_FUNNY_COLS_SRC", null, null, null);
        statement.execute("create table table_with_funny_cols_dest as select * from table_with_funny_cols_src with no data");
        this.doImport("TABLE_WITH_FUNNY_COLS_SRC", null, "TABLE_WITH_FUNNY_COLS_DEST", null, null, null, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select * from table_with_funny_cols_dest order by x"), new String[][]{{"1", "2"}, {"3", "4"}});
    }

    public void testCastingProblem() throws Exception {
        String string = SupportFilesSetup.getReadWrite("castCheck.dat").getPath();
        this.doExportToFile(string, null, "T6", null, null, null);
        try {
            this.doImportFromFile(string, null, "T5", null, null, null, 0);
            ImportExportTest.fail();
        }
        catch (SQLException sQLException) {
            ImportExportTest.assertSQLState("XJ001", sQLException);
        }
    }

    private void doImport(String string, String string2, String string3, String string4, String string5, String string6, int n) throws SQLException {
        String string7 = string == null ? null : SupportFilesSetup.getReadWrite(string + ".dat").getPath();
        this.doImportFromFile(string7, string2, string3, string4, string5, string6, n);
    }

    private void doImportFromFile(String string, String string2, String string3, String string4, String string5, String string6, int n) throws SQLException {
        String string7 = "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (? , ? , ? , ?, ? , ?, ?)";
        PreparedStatement preparedStatement = this.prepareStatement(string7);
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, string);
        preparedStatement.setString(4, string4);
        preparedStatement.setString(5, string5);
        preparedStatement.setString(6, string6);
        preparedStatement.setInt(7, n);
        preparedStatement.execute();
        preparedStatement.close();
    }

    private void doImportAndExport(String string, String string2, String string3, String string4, String string5) throws SQLException {
        this.doExport(string, string2, string3, string4, string5);
        this.doImportAndVerify(string, string2, string3, string4, string5, 0);
        this.doImportAndVerify(string, string2, string3, string4, string5, 1);
    }

    private void doExport(String string, String string2, String string3, String string4, String string5) throws SQLException {
        String string6 = string2 == null ? null : SupportFilesSetup.getReadWrite(string2 + ".dat").getPath();
        this.doExportToFile(string6, string, string2, string3, string4, string5);
    }

    private void doExportToFile(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (string != null) {
            SupportFilesSetup.deleteFile(string);
        }
        String string7 = "call SYSCS_UTIL.SYSCS_EXPORT_TABLE (? , ? , ? , ?, ? , ?)";
        PreparedStatement preparedStatement = this.prepareStatement(string7);
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        preparedStatement.setString(3, string);
        preparedStatement.setString(4, string4);
        preparedStatement.setString(5, string5);
        preparedStatement.setString(6, string6);
        preparedStatement.execute();
        preparedStatement.close();
    }

    private void doImportAndVerify(String string, String string2, String string3, String string4, String string5, int n) throws SQLException {
        this.doImport(string2, null, "T2", string3, string4, string5, n);
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM " + (string == null ? JDBC.escape(string2) : JDBC.escape(string, string2)));
        resultSet.next();
        int n2 = resultSet.getInt(1);
        resultSet.close();
        resultSet = statement.executeQuery("SELECT COUNT(*) FROM t2");
        resultSet.next();
        int n3 = resultSet.getInt(1);
        resultSet.close();
        statement.close();
        ImportExportTest.assertEquals((int)n2, (int)n3);
        this.doExport(null, "T2", string3, string4, string5);
        ImportExportTest.assertEquals(SupportFilesSetup.getReadWrite(string2 + ".dat"), SupportFilesSetup.getReadWrite("T2.dat"));
    }

    private void resetTables() throws Exception {
        this.runSQLCommands("delete from t1");
        this.runSQLCommands("delete from t2");
        this.runSQLCommands("delete from t5");
        this.runSQLCommands("delete from t6");
        this.runSQLCommands("INSERT INTO T1 VALUES (null,'aa',1,'a',DATE('1998-06-30'),1,1,1,1,1,1,1,TIME('12:00:00'),TIMESTAMP('1998-06-30 12:00:00.0'),1,'a', makePrice() )");
        this.runSQLCommands("INSERT INTO T1 VALUES (null,'bb',1,'b',DATE('1998-06-30'),2,2,2,2,2,2,2,TIME('12:00:00'),TIMESTAMP('1998-06-30 12:00:00.0'),2,'b', makePrice() )");
        this.runSQLCommands("INSERT INTO T1 VALUES (null,'cc',1,'c',DATE('1998-06-30'),3,3,3,3,3,3,3,TIME('12:00:00'),TIMESTAMP('1998-06-30 12:00:00.0'),3,'c', makePrice())");
        this.runSQLCommands("INSERT INTO T1 VALUES (null,'dd',1,'d',DATE('1998-06-30'),4,4,4,4,4,4,4,TIME('12:00:00'),TIMESTAMP('1998-06-30 12:00:00.0'),4,'d', makePrice())");
        this.runSQLCommands("insert into t6 values( 1, makeHashMap() )");
    }
}

