/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.harness;

import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiIterations;

public abstract class T_MultiThreadedIterations
extends T_MultiIterations
implements Runnable {
    protected int threadNumber = 0;
    static volatile boolean inError = false;
    static int numThreads = 1;
    static int iterations = 1;
    Throwable error = null;
    static Thread[] TestThreads;
    static T_MultiThreadedIterations[] TestObjects;

    protected T_MultiThreadedIterations() {
    }

    @Override
    protected void runTests() throws T_Fail {
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        String string3 = "derby." + string2 + ".numThreads";
        String string4 = PropertyUtil.getSystemProperty((String)string3);
        if (string4 != null) {
            try {
                numThreads = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                numThreads = 1;
            }
            if (numThreads <= 0) {
                numThreads = 1;
            }
        }
        if (numThreads == 1) {
            super.runTests();
        } else {
            int n;
            int n2;
            TestThreads = new Thread[numThreads];
            TestObjects = new T_MultiThreadedIterations[numThreads];
            inError = false;
            for (n2 = 0; n2 < numThreads; ++n2) {
                T_MultiThreadedIterations.TestObjects[n2] = this.newTestObject();
                T_MultiThreadedIterations.TestObjects[n2].out = this.out;
                T_MultiThreadedIterations.TestThreads[n2] = new Thread((Runnable)TestObjects[n2], "Thread_" + n2);
            }
            TestObjects[0].setupTest();
            T_MultiThreadedIterations.TestObjects[0].threadNumber = 0;
            for (n2 = 1; n2 < numThreads; ++n2) {
                T_MultiThreadedIterations.TestObjects[n2].threadNumber = n2;
                TestObjects[n2].joinSetupTest();
            }
            string3 = "derby." + string2 + ".iterations";
            String string5 = PropertyUtil.getSystemProperty((String)string3);
            if (string5 != null) {
                try {
                    iterations = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (iterations <= 0) {
                    iterations = 1;
                }
            }
            for (n = 0; n < numThreads; ++n) {
                TestThreads[n].start();
            }
            try {
                for (n = 0; n < numThreads; ++n) {
                    TestThreads[n].join();
                }
            }
            catch (InterruptedException interruptedException) {
                throw T_Fail.exceptionFail(interruptedException);
            }
            for (n = 0; n < numThreads; ++n) {
                if (T_MultiThreadedIterations.TestObjects[n].error == null) continue;
                throw T_Fail.exceptionFail(T_MultiThreadedIterations.TestObjects[n].error);
            }
        }
    }

    @Override
    public void run() {
        int n;
        String string = "[" + Thread.currentThread().getName() + "] ";
        this.out.println(string + "started");
        try {
            for (n = 0; n < iterations; ++n) {
                Runtime.getRuntime().gc();
                long l = Runtime.getRuntime().totalMemory();
                long l2 = Runtime.getRuntime().freeMemory();
                long l3 = l - l2;
                long l4 = System.currentTimeMillis();
                this.runTestSet();
                long l5 = System.currentTimeMillis();
                Runtime.getRuntime().gc();
                long l6 = Runtime.getRuntime().totalMemory();
                long l7 = Runtime.getRuntime().freeMemory();
                long l8 = l6 - l7;
                this.out.println(string + "Iteration " + n + " took " + (l5 - l4) + "ms");
                this.out.println(string + "Total memory increased by " + (l6 - l) + " is " + l6);
                this.out.println(string + "Used  memory increased by " + (l8 - l3) + " is " + l8);
            }
        }
        catch (ThreadDeath threadDeath) {
            this.out.println(string + "caught thread death, printing stack");
            threadDeath.printStackTrace(this.out.getPrintWriter());
            Thread.dumpStack();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.error = throwable;
        }
        if (this.error == null) {
            this.out.println(string + "finished with no error");
        } else if (!inError) {
            inError = true;
            this.error.printStackTrace(this.out.getPrintWriter());
            for (n = 0; n < numThreads; ++n) {
                if (this == TestObjects[n]) continue;
                TestThreads[n].interrupt();
            }
        }
    }

    protected abstract void joinSetupTest() throws T_Fail;

    protected abstract T_MultiThreadedIterations newTestObject();

    protected int getNumThreads() {
        return numThreads;
    }
}

