/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.app.event.EventHandlerUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTExpression;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTText;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.introspection.Info;

public class ASTSetDirective
extends SimpleNode {
    private String leftReference = "";
    private Node right = null;
    private ASTReference left = null;
    private boolean isInitialized;
    private String prefix = "";
    private String postfix = "";
    private String morePrefix = "";
    protected Info uberInfo;
    protected boolean strictRef = false;

    public ASTSetDirective(int n) {
        super(n);
    }

    public ASTSetDirective(Parser parser, int n) {
        super(parser, n);
    }

    @Override
    public Object jjtAccept(ParserVisitor parserVisitor, Object object) {
        return parserVisitor.visit(this, object);
    }

    @Override
    public synchronized Object init(InternalContextAdapter internalContextAdapter, Object object) throws TemplateInitException {
        if (!this.isInitialized) {
            super.init(internalContextAdapter, object);
            Token token = this.getFirstToken();
            int n = -1;
            while (token != null && (n = token.image.lastIndexOf(35)) == -1) {
                token = token.next;
            }
            if (token != null && n > 0) {
                this.morePrefix = token.image.substring(0, n);
            }
            this.uberInfo = new Info(this.getTemplateName(), this.getLine(), this.getColumn());
            this.right = this.getRightHandSide();
            this.left = this.getLeftHandSide();
            this.strictRef = this.rsvc.getBoolean("runtime.references.strict", false);
            this.leftReference = this.left.firstImage.substring(1);
            if (this.rsvc.getSpaceGobbling() == RuntimeConstants.SpaceGobbling.BC) {
                Node node;
                Node node2 = null;
                for (int i = 0; i < this.parent.jjtGetNumChildren() && (node = this.parent.jjtGetChild(i)) != this; ++i) {
                    node2 = node;
                }
                if (node2 == null) {
                    this.prefix = "";
                } else if (node2 instanceof ASTText) {
                    ASTText aSTText = (ASTText)node2;
                    if (aSTText.getCtext().matches("[ \t]*")) {
                        aSTText.setCtext("");
                    }
                } else {
                    this.prefix = "";
                }
            }
            this.isInitialized = true;
            this.cleanupParserAndTokens();
        }
        return object;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPostfix(String string) {
        this.postfix = string;
    }

    public String getPostfix() {
        return this.postfix;
    }

    @Override
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer) throws IOException, MethodInvocationException {
        RuntimeConstants.SpaceGobbling spaceGobbling = this.rsvc.getSpaceGobbling();
        if (this.morePrefix.length() > 0 || spaceGobbling.compareTo(RuntimeConstants.SpaceGobbling.LINES) < 0) {
            writer.write(this.prefix);
        }
        writer.write(this.morePrefix);
        Object object = this.right.value(internalContextAdapter);
        if (object == null && !this.strictRef) {
            String string = null;
            if (this.right instanceof ASTExpression) {
                string = ((ASTExpression)this.right).lastImage;
            }
            EventHandlerUtil.invalidSetMethod(this.rsvc, internalContextAdapter, this.leftReference, string, this.uberInfo);
        }
        if (this.morePrefix.length() > 0 || spaceGobbling == RuntimeConstants.SpaceGobbling.NONE) {
            writer.write(this.postfix);
        }
        return this.left.setValue(internalContextAdapter, object);
    }

    private ASTReference getLeftHandSide() {
        return (ASTReference)this.jjtGetChild(0);
    }

    private Node getRightHandSide() {
        return this.jjtGetChild(1);
    }
}

