/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.controller;

import org.apache.torque.generator.configuration.controller.Log4j2LoggingAdapter;
import org.apache.torque.generator.configuration.controller.LoggingAdapter;

public enum Loglevel {
    TRACE("trace"),
    DEBUG("debug"),
    INFO("info"),
    WARN("warn"),
    ERROR("error");

    private String key;
    private static LoggingAdapter loggingAdapter;

    private Loglevel(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void apply() {
        loggingAdapter.setLoglevel(this);
    }

    public static Loglevel getByKey(String key) {
        for (Loglevel loglevel : Loglevel.values()) {
            if (!loglevel.getKey().equals(key)) continue;
            return loglevel;
        }
        throw new IllegalArgumentException("Key " + key + " does not exist");
    }

    public static Loglevel getCurrentLoglevel() {
        return loggingAdapter.getCurrentLoglevel();
    }

    public static LoggingAdapter getLoggingAdapter() {
        return loggingAdapter;
    }

    public static void setLoggingAdapter(LoggingAdapter loggingAdapter) {
        if (loggingAdapter == null) {
            throw new NullPointerException("loggingAdapter must not be null");
        }
        Loglevel.loggingAdapter = loggingAdapter;
    }

    static {
        loggingAdapter = new Log4j2LoggingAdapter();
    }
}

