/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.AbstractConfigurationProvider;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.PackageResources;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.configuration.paths.TorqueGeneratorPaths;

public class JarConfigurationProvider
extends AbstractConfigurationProvider {
    private static Log log = LogFactory.getLog(JarConfigurationProvider.class);
    private final ProjectPaths projectPaths;
    private final TorqueGeneratorPaths configurationPaths;
    private JarFile jarFile;

    public JarConfigurationProvider(ProjectPaths projectPaths, TorqueGeneratorPaths configurationPaths) throws ConfigurationException {
        super(configurationPaths);
        if (projectPaths == null) {
            throw new NullPointerException("projectPaths is null");
        }
        this.projectPaths = projectPaths;
        this.configurationPaths = configurationPaths;
        try {
            this.jarFile = new JarFile(projectPaths.getConfigurationPath());
        }
        catch (IOException e) {
            log.error((Object)("Could not open jar File " + projectPaths.getConfigurationPath().getAbsolutePath()));
            throw new ConfigurationException(e);
        }
    }

    @Override
    public String getControlConfigurationLocation() throws ConfigurationException {
        return String.valueOf(this.projectPaths.getConfigurationPath()) + ":" + this.configurationPaths.getConfigurationDirectory() + "/" + this.configurationPaths.getControlConfigurationFile();
    }

    @Override
    protected InputStream getInputStream(String name, String directory, String description) throws ConfigurationException {
        String fileName = directory + "/" + name;
        InputStream inputStream = null;
        try {
            JarEntry jarEntry = this.jarFile.getJarEntry(fileName);
            inputStream = this.jarFile.getInputStream(jarEntry);
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not read " + description + " file " + fileName + " in jar file " + String.valueOf(this.projectPaths.getConfigurationPath()), e);
        }
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading " + description + " file: '" + String.valueOf(this.projectPaths.getConfigurationPath()) + "' in jar file " + String.valueOf(this.projectPaths.getConfigurationPath())));
        }
        return bis;
    }

    @Override
    public Collection<String> getOutletConfigurationNames() throws ConfigurationException {
        return PackageResources.getFilesInJarDirectoryWithSuffix(this.configurationPaths.getOutletDirectory(), this.jarFile, ".xml", false);
    }

    @Override
    public Collection<String> getTemplateNames() throws ConfigurationException {
        JarFile templatesConfigurationFile;
        try {
            templatesConfigurationFile = new JarFile(this.projectPaths.getConfigurationPath());
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        return PackageResources.getFilesInJarDirectoryWithSuffix(this.configurationPaths.getTemplateDirectory(), templatesConfigurationFile, null, true);
    }
}

