package a.b;


/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Example predefined Enum
 *
 */
public enum SomeEnum {

    /** Represents the database value x. */
    A("a"),
    /** Represents the database value y. */
    B("b"),
    /** Represents the database value z. */
    C("c");

    /** The database value represented by the enum value. */
    private final String value;

    /**
     * Constructor.
     *
     * @param value The database value represented by the enum value.
     */
    SomeEnum(String value)
    {
        this.value = value;
    }


    public String getValue()
    {
        return value;
    }

    public static SomeEnum getByValue(String arg)
    {
        if (arg == null)
        {
            return null;
        }
        for (SomeEnum candidate : values())
        {
            if (arg.equals(candidate.getValue()))
            {
                return candidate;
            }
        }
        throw new IllegalArgumentException("Value " + arg + " is not defined in enum SomeEnum");
    }
}
