/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.controls;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreControlValue
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreControlValue.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreControlValue() {
        super("Store the control value");
    }

    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        MessageDecorator<? extends Message> message = container.getMessage();
        CodecControl<Control> control = message.getCurrentControl();
        BerValue value = tlv.getValue();
        if (tlv.getLength() == 0) {
            control.setValue(Strings.EMPTY_BYTES);
        } else {
            control.setValue(value.getData());
            control.decode(value.getData());
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Control value : " + Strings.dumpBytes((byte[])control.getValue()));
        }
    }
}

