/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.search.entryChange;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.controls.EntryChange;
import org.apache.directory.api.ldap.model.message.controls.EntryChangeImpl;

public class EntryChangeFactory
extends AbstractControlFactory<EntryChange> {
    public static final int UNDEFINED_CHANGE_NUMBER = -1;

    public EntryChangeFactory(LdapApiService codec) {
        super(codec, "2.16.840.1.113730.3.4.7");
    }

    public EntryChange newControl() {
        return new EntryChangeImpl();
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        int start = buffer.getPos();
        EntryChange entryChange = (EntryChange)control;
        if (entryChange.getChangeNumber() != -1L) {
            BerValue.encodeInteger((Asn1Buffer)buffer, (long)entryChange.getChangeNumber());
        }
        if (entryChange.getPreviousDn() != null) {
            BerValue.encodeOctetString((Asn1Buffer)buffer, (String)entryChange.getPreviousDn().getName());
        }
        BerValue.encodeEnumerated((Asn1Buffer)buffer, (int)entryChange.getChangeType().getValue());
        BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new EntryChangeContainer(control), control, controlBytes);
    }
}

