/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schema.converter;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.schema.converter.SchemaElementImpl;

public class ObjectClassHolder
extends SchemaElementImpl {
    private List<String> superiors = new ArrayList<String>();
    private List<String> must = new ArrayList<String>();
    private List<String> may = new ArrayList<String>();
    private ObjectClassTypeEnum classType = ObjectClassTypeEnum.STRUCTURAL;

    public ObjectClassHolder(String oid) {
        this.oid = oid;
    }

    public List<String> getSuperiors() {
        return this.superiors;
    }

    public void setSuperiors(List<String> superiors) {
        this.superiors = superiors;
    }

    public List<String> getMust() {
        return this.must;
    }

    public void setMust(List<String> must) {
        this.must = must;
    }

    public List<String> getMay() {
        return this.may;
    }

    public void setMay(List<String> may) {
        this.may = may;
    }

    public ObjectClassTypeEnum getClassType() {
        return this.classType;
    }

    public void setClassType(ObjectClassTypeEnum classType) {
        this.classType = classType;
    }

    @Override
    public String toLdif(String schemaName) throws LdapException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.schemaToLdif(schemaName, "metaObjectClass"));
        if (!this.superiors.isEmpty()) {
            for (String superior : this.superiors) {
                sb.append("m-supObjectClass: ").append(superior).append('\n');
            }
        }
        if (this.classType != ObjectClassTypeEnum.STRUCTURAL) {
            sb.append("m-typeObjectClass: ").append(this.classType).append('\n');
        }
        if (!this.must.isEmpty()) {
            for (String attr : this.must) {
                sb.append("m-must: ").append(attr).append('\n');
            }
        }
        if (!this.may.isEmpty()) {
            for (String attr : this.may) {
                sb.append("m-may: ").append(attr).append('\n');
            }
        }
        if (!this.extensions.isEmpty()) {
            this.extensionsToLdif("m-extensionObjectClass");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getOid();
    }

    @Override
    public String dnToLdif(String schemaName) throws LdapException {
        StringBuilder sb = new StringBuilder();
        String dn = "m-oid=" + this.oid + ", " + "ou=objectclasses" + ", cn=" + Rdn.escapeValue((String)schemaName) + ", ou=schema";
        DefaultEntry entry = new DefaultEntry(dn);
        sb.append(LdifUtils.convertToLdif((Entry)entry));
        return sb.toString();
    }
}

