/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import com.inmethod.grid.column.PropertyColumn;
import com.inmethod.grid.treegrid.TreeGrid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.PwPolicy;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.event.SaveModelEvent;
import org.apache.directory.fortress.web.model.PwPolicyListModel;
import org.apache.directory.fortress.web.panel.PwPolicyListPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PwPolicyListPanel
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)PwPolicyListPanel.class.getName());
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode node;
    private TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid;
    private DefaultMutableTreeNode rootNode;
    private String searchVal;

    public PwPolicyListPanel(String id) {
        super(id);
        PwPolicyListModel policyListModel = new PwPolicyListModel(new PwPolicy(""), SecUtils.getSession((Component)this));
        this.setDefaultModel((IModel)policyListModel);
        ArrayList<PropertyColumn> columns = new ArrayList<PropertyColumn>();
        columns.add(new PropertyColumn((IModel)Model.of((Serializable)((Object)"Policy Name")), "userObject.name"));
        PropertyColumn minAge = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Min Age")), "userObject.minAge");
        minAge.setInitialSize(60);
        columns.add(minAge);
        PropertyColumn maxAge = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Max Age")), "userObject.maxAge");
        maxAge.setInitialSize(75);
        columns.add(maxAge);
        PropertyColumn inHistory = new PropertyColumn((IModel)Model.of((Serializable)((Object)"History")), "userObject.inHistory");
        inHistory.setInitialSize(50);
        columns.add(inHistory);
        PropertyColumn minLength = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Min Len")), "userObject.minLength");
        minLength.setInitialSize(60);
        columns.add(minLength);
        PropertyColumn expireWarning = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Expire Warning")), "userObject.expireWarning");
        expireWarning.setInitialSize(115);
        columns.add(expireWarning);
        PropertyColumn graceLoginLimit = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Grace")), "userObject.graceLoginLimit");
        graceLoginLimit.setInitialSize(50);
        columns.add(graceLoginLimit);
        PropertyColumn lockout = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Lockout")), "userObject.lockout");
        lockout.setInitialSize(60);
        columns.add(lockout);
        PropertyColumn lockoutDuration = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Lockout Duration")), "userObject.lockoutDuration");
        lockoutDuration.setInitialSize(125);
        columns.add(lockoutDuration);
        PropertyColumn maxFailure = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Max Failure")), "userObject.maxFailure");
        maxFailure.setInitialSize(80);
        columns.add(maxFailure);
        PropertyColumn failureCountInterval = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Interval")), "userObject.failureCountInterval");
        failureCountInterval.setInitialSize(60);
        columns.add(failureCountInterval);
        PropertyColumn mustChange = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Must Change")), "userObject.mustChange");
        mustChange.setInitialSize(90);
        columns.add(mustChange);
        PropertyColumn allowUserChange = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Allow Change")), "userObject.allowUserChange");
        allowUserChange.setInitialSize(95);
        columns.add(allowUserChange);
        PropertyColumn safeModify = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Safe Modify")), "userObject.safeModify");
        safeModify.setInitialSize(90);
        columns.add(safeModify);
        List policies = (List)this.getDefaultModel().getObject();
        this.treeModel = this.createTreeModel(policies);
        this.grid = new /* Unavailable Anonymous Inner Class!! */;
        this.grid.setAllowSelectMultiple(false);
        this.grid.setClickRowToSelect(true);
        this.grid.setClickRowToDeselect(false);
        this.grid.setSelectToEdit(false);
        this.grid.getTreeState().expandAll();
        Form listForm = new Form("form");
        listForm.add(new Component[]{this.grid});
        this.grid.setOutputMarkupId(true);
        TextField searchValFld = new TextField("searchVal", (IModel)new PropertyModel((Object)this, "searchVal"));
        listForm.add(new Component[]{searchValFld});
        listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{listForm});
    }

    public void onEvent(IEvent event) {
        if (event.getPayload() instanceof SaveModelEvent) {
            SaveModelEvent modelEvent = (SaveModelEvent)event.getPayload();
            switch (3.$SwitchMap$org$apache$directory$fortress$web$event$SaveModelEvent$Operations[modelEvent.getOperation().ordinal()]) {
                case 1: {
                    this.add(modelEvent.getEntity());
                    break;
                }
                case 2: {
                    this.modelChanged();
                    break;
                }
                case 3: {
                    this.prune();
                    break;
                }
            }
            AjaxRequestTarget target = ((SaveModelEvent)event.getPayload()).getAjaxRequestTarget();
            target.add(new Component[]{this.grid});
            LOG.debug(".onEvent SaveModelEvent: " + target.toString());
        }
    }

    private void removeSelectedItems(TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid) {
        Collection selected = grid.getSelectedItems();
        for (IModel model : selected) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getObject();
            this.treeModel.removeNodeFromParent(node);
            PwPolicy policy = (PwPolicy)node.getUserObject();
            LOG.debug(".removeSelectedItems policy node: " + policy.getName());
            List policies = (List)this.getDefaultModel().getObject();
            policies.remove(policy);
        }
    }

    private DefaultTreeModel createTreeModel(List<PwPolicy> policies) {
        this.rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel model = new DefaultTreeModel(this.rootNode);
        if (policies == null) {
            LOG.debug("no Policies found");
        } else {
            LOG.debug("Policies found:" + policies.size());
            for (PwPolicy policy : policies) {
                this.rootNode.add(new DefaultMutableTreeNode(policy));
            }
        }
        return model;
    }

    public void add(FortEntity entity) {
        if (this.getDefaultModelObject() != null) {
            List policies = (List)this.getDefaultModelObject();
            policies.add((PwPolicy)entity);
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(entity), this.rootNode, policies.size());
        }
    }

    public void prune() {
        this.removeSelectedItems(this.grid);
    }
}

