/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.realm;

import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;
import org.apache.directory.fortress.realm.J2eePolicyMgr;
import org.apache.directory.fortress.realm.J2eePolicyMgrImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class J2eePolicyMgrFactory {
    private static final String J2EE_POLICYMGR_IMPLEMENTATION = "realmImplementation";
    private static final String J2EE_POLICYMGR_DEFAULT_CLASS = J2eePolicyMgrImpl.class.getName();
    private static final String CLS_NM = J2eePolicyMgrFactory.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static String j2eeClassName = Config.getInstance().getProperty("realmImplementation");

    private J2eePolicyMgrFactory() {
    }

    public static J2eePolicyMgr createInstance() throws SecurityException {
        return J2eePolicyMgrFactory.createInstance("HOME");
    }

    public static J2eePolicyMgr createInstance(String contextId) throws SecurityException {
        VUtil.assertNotNull((Object)contextId, (int)101, (String)(CLS_NM + ".createInstance"));
        String j2eeClassName = Config.getInstance().getProperty(J2EE_POLICYMGR_IMPLEMENTATION);
        J2eePolicyMgr policyMgr = StringUtils.isEmpty((CharSequence)j2eeClassName) ? new J2eePolicyMgrImpl() : (J2eePolicyMgr)ClassUtil.createInstance((String)J2EE_POLICYMGR_DEFAULT_CLASS);
        policyMgr.setContextId(contextId);
        return policyMgr;
    }
}

