/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.Schema;

public class SchemaHandler {
    private List<Schema> schemasList = new ArrayList<Schema>();
    private List<AttributeType> attributeTypesList = new ArrayList<AttributeType>();
    private List<MatchingRule> matchingRulesList = new ArrayList<MatchingRule>();
    private List<ObjectClass> objectClassesList = new ArrayList<ObjectClass>();
    private List<LdapSyntax> syntaxesList = new ArrayList<LdapSyntax>();
    private MultiValuedMap<String, Schema> schemasMap = new ArrayListValuedHashMap();
    private MultiValuedMap<String, AttributeType> attributeTypesMap = new ArrayListValuedHashMap();
    private MultiValuedMap<String, MatchingRule> matchingRulesMap = new ArrayListValuedHashMap();
    private MultiValuedMap<String, ObjectClass> objectClassesMap = new ArrayListValuedHashMap();
    private MultiValuedMap<String, LdapSyntax> syntaxesMap = new ArrayListValuedHashMap();
    private List<SchemaHandlerListener> schemaHandlerListeners = new ArrayList<SchemaHandlerListener>();

    public List<AttributeType> getAttributeTypes() {
        return this.attributeTypesList;
    }

    public List<MatchingRule> getMatchingRules() {
        return this.matchingRulesList;
    }

    public List<ObjectClass> getObjectClasses() {
        return this.objectClassesList;
    }

    public List<Schema> getSchemas() {
        return this.schemasList;
    }

    public List<LdapSyntax> getSyntaxes() {
        return this.syntaxesList;
    }

    public AttributeType getAttributeType(String id) {
        List<?> list = this.getAttributeTypeList(Strings.toLowerCase((String)id));
        if (list != null && list.size() >= 1) {
            return (AttributeType)list.get(0);
        }
        return null;
    }

    public List<?> getAttributeTypeList(String id) {
        return (List)this.attributeTypesMap.get((Object)Strings.toLowerCase((String)id));
    }

    public MatchingRule getMatchingRule(String id) {
        List<?> list = this.getMatchingRuleList(Strings.toLowerCase((String)id));
        if (list != null && list.size() >= 1) {
            return (MatchingRule)list.get(0);
        }
        return null;
    }

    public List<?> getMatchingRuleList(String id) {
        return (List)this.matchingRulesMap.get((Object)Strings.toLowerCase((String)id));
    }

    public ObjectClass getObjectClass(String id) {
        List<?> list = this.getObjectClassList(Strings.toLowerCase((String)id));
        if (list != null && list.size() >= 1) {
            return (ObjectClass)list.get(0);
        }
        return null;
    }

    public List<?> getObjectClassList(String id) {
        return (List)this.objectClassesMap.get((Object)Strings.toLowerCase((String)id));
    }

    public Schema getSchema(String name) {
        List<?> list = this.getSchemaList(Strings.toLowerCase((String)name));
        if (list != null && list.size() >= 1) {
            return (Schema)((Object)list.get(0));
        }
        return null;
    }

    public List<?> getSchemaList(String name) {
        return (List)this.schemasMap.get((Object)Strings.toLowerCase((String)name));
    }

    public LdapSyntax getSyntax(String id) {
        List<?> list = this.getSyntaxList(Strings.toLowerCase((String)id));
        if (list != null && list.size() >= 1) {
            return (LdapSyntax)list.get(0);
        }
        return null;
    }

    public List<?> getSyntaxList(String id) {
        return (List)this.syntaxesMap.get((Object)Strings.toLowerCase((String)id));
    }

    public void addListener(SchemaHandlerListener listener) {
        if (!this.schemaHandlerListeners.contains(listener)) {
            this.schemaHandlerListeners.add(listener);
        }
    }

    public void removeListener(SchemaHandlerListener listener) {
        this.schemaHandlerListeners.remove(listener);
    }

    public void addSchema(Schema schema) {
        this.schemasList.add(schema);
        this.schemasMap.put((Object)Strings.toLowerCase((String)schema.getSchemaName()), (Object)schema);
        for (AttributeType at : schema.getAttributeTypes()) {
            this.addSchemaObject((SchemaObject)at);
        }
        for (MatchingRule mr : schema.getMatchingRules()) {
            this.addSchemaObject((SchemaObject)mr);
        }
        for (ObjectClass oc : schema.getObjectClasses()) {
            this.addSchemaObject((SchemaObject)oc);
        }
        for (LdapSyntax syntax : schema.getSyntaxes()) {
            this.addSchemaObject((SchemaObject)syntax);
        }
        this.notifySchemaAdded(schema);
    }

    private void addSchemaObject(SchemaObject object) {
        if (object instanceof AttributeType) {
            AttributeType at = (AttributeType)object;
            this.attributeTypesList.add(at);
            List names = at.getNames();
            if (names != null) {
                for (String name : names) {
                    this.attributeTypesMap.put((Object)Strings.toLowerCase((String)name), (Object)at);
                }
            }
            this.attributeTypesMap.put((Object)at.getOid(), (Object)at);
        } else if (object instanceof MatchingRule) {
            MatchingRule mr = (MatchingRule)object;
            this.matchingRulesList.add(mr);
            List names = mr.getNames();
            if (names != null) {
                for (String name : names) {
                    this.matchingRulesMap.put((Object)Strings.toLowerCase((String)name), (Object)mr);
                }
            }
            this.matchingRulesMap.put((Object)mr.getOid(), (Object)mr);
        } else if (object instanceof ObjectClass) {
            ObjectClass oc = (ObjectClass)object;
            this.objectClassesList.add(oc);
            List names = oc.getNames();
            if (names != null) {
                for (String name : names) {
                    this.objectClassesMap.put((Object)Strings.toLowerCase((String)name), (Object)oc);
                }
            }
            this.objectClassesMap.put((Object)oc.getOid(), (Object)oc);
        } else if (object instanceof LdapSyntax) {
            LdapSyntax syntax = (LdapSyntax)object;
            this.syntaxesList.add(syntax);
            List names = syntax.getNames();
            if (names != null) {
                for (String name : names) {
                    this.syntaxesMap.put((Object)Strings.toLowerCase((String)name), (Object)syntax);
                }
            }
            this.syntaxesMap.put((Object)syntax.getOid(), (Object)syntax);
        }
    }

    public void removeSchema(Schema schema) {
        this.schemasList.remove((Object)schema);
        this.schemasMap.remove((Object)Strings.toLowerCase((String)schema.getSchemaName()));
        for (AttributeType at : schema.getAttributeTypes()) {
            this.removeSchemaObject((SchemaObject)at);
        }
        for (MatchingRule mr : schema.getMatchingRules()) {
            this.removeSchemaObject((SchemaObject)mr);
        }
        for (ObjectClass oc : schema.getObjectClasses()) {
            this.removeSchemaObject((SchemaObject)oc);
        }
        for (LdapSyntax syntax : schema.getSyntaxes()) {
            this.removeSchemaObject((SchemaObject)syntax);
        }
        this.notifySchemaRemoved(schema);
    }

    private void removeSchemaObject(SchemaObject object) {
        if (object instanceof AttributeType) {
            AttributeType at = (AttributeType)object;
            this.attributeTypesList.remove(at);
            List names = at.getNames();
            if (names != null) {
                for (String name : names) {
                    this.attributeTypesMap.remove((Object)Strings.toLowerCase((String)name));
                }
            }
            this.attributeTypesMap.remove((Object)at.getOid());
        } else if (object instanceof MatchingRule) {
            MatchingRule mr = (MatchingRule)object;
            this.matchingRulesList.remove(mr);
            List names = mr.getNames();
            if (names != null) {
                for (String name : names) {
                    this.matchingRulesMap.remove((Object)Strings.toLowerCase((String)name));
                }
            }
            this.matchingRulesMap.remove((Object)mr.getOid());
        } else if (object instanceof ObjectClass) {
            ObjectClass oc = (ObjectClass)object;
            this.objectClassesList.remove(oc);
            List names = oc.getNames();
            if (names != null) {
                for (String name : names) {
                    this.objectClassesMap.remove((Object)Strings.toLowerCase((String)name));
                }
            }
            this.objectClassesMap.remove((Object)oc.getOid());
        } else if (object instanceof LdapSyntax) {
            LdapSyntax syntax = (LdapSyntax)object;
            this.syntaxesList.remove(syntax);
            List names = syntax.getNames();
            if (names != null) {
                for (String name : names) {
                    this.syntaxesMap.remove((Object)Strings.toLowerCase((String)name));
                }
            }
            this.syntaxesMap.remove((Object)syntax.getOid());
        }
    }

    public void renameSchema(Schema schema, String newName) {
        this.schemasMap.remove((Object)Strings.toLowerCase((String)schema.getSchemaName()));
        schema.setSchemaName(newName);
        this.schemasMap.put((Object)Strings.toLowerCase((String)schema.getSchemaName()), (Object)schema);
        for (AttributeType at : schema.getAttributeTypes()) {
            at.setSchemaName(newName);
        }
        for (MatchingRule mr : schema.getMatchingRules()) {
            mr.setSchemaName(newName);
        }
        for (ObjectClass oc : schema.getObjectClasses()) {
            oc.setSchemaName(newName);
        }
        for (LdapSyntax syntax : schema.getSyntaxes()) {
            syntax.setSchemaName(newName);
        }
        this.notifySchemaRenamed(schema);
    }

    public void addAttributeType(AttributeType at) {
        Schema schema = this.getSchema(at.getSchemaName());
        schema.addAttributeType(at);
        this.addSchemaObject((SchemaObject)at);
        this.notifyAttributeTypeAdded(at);
    }

    public void modifyAttributeType(AttributeType at1, AttributeType at2) {
        this.removeSchemaObject((SchemaObject)at1);
        at1.setNames(at2.getNames());
        at1.setOid(at2.getOid());
        at1.setDescription(at2.getDescription());
        at1.setSuperiorOid(at2.getSuperiorOid());
        at1.setUsage(at2.getUsage());
        at1.setSyntaxOid(at2.getSyntaxOid());
        at1.setSyntaxLength(at2.getSyntaxLength());
        at1.setObsolete(at2.isObsolete());
        at1.setSingleValued(at2.isSingleValued());
        at1.setCollective(at2.isCollective());
        at1.setUserModifiable(at2.isUserModifiable());
        at1.setEqualityOid(at2.getEqualityOid());
        at1.setOrderingOid(at2.getOrderingOid());
        at1.setSubstringOid(at2.getSubstringOid());
        this.addSchemaObject((SchemaObject)at1);
        this.notifyAttributeTypeModified(at1);
    }

    public void removeAttributeType(AttributeType at) {
        Schema schema = this.getSchema(at.getSchemaName());
        schema.removeAttributeType(at);
        this.removeSchemaObject((SchemaObject)at);
        this.notifyAttributeTypeRemoved(at);
    }

    public void addObjectClass(ObjectClass oc) {
        Schema schema = this.getSchema(oc.getSchemaName());
        schema.addObjectClass(oc);
        this.addSchemaObject((SchemaObject)oc);
        this.notifyObjectClassAdded(oc);
    }

    public void modifyObjectClass(ObjectClass oc1, ObjectClass oc2) {
        this.removeSchemaObject((SchemaObject)oc1);
        oc1.setNames(oc2.getNames());
        oc1.setOid(oc2.getOid());
        oc1.setDescription(oc2.getDescription());
        oc1.setSuperiorOids(oc2.getSuperiorOids());
        oc1.setType(oc2.getType());
        oc1.setObsolete(oc2.isObsolete());
        oc1.setMustAttributeTypeOids(oc2.getMustAttributeTypeOids());
        oc1.setMayAttributeTypeOids(oc2.getMayAttributeTypeOids());
        this.addSchemaObject((SchemaObject)oc1);
        this.notifyObjectClassModified(oc1);
    }

    public void removeObjectClass(ObjectClass oc) {
        Schema schema = this.getSchema(oc.getSchemaName());
        schema.removeObjectClass(oc);
        this.removeSchemaObject((SchemaObject)oc);
        this.notifyObjectClassRemoved(oc);
    }

    private void notifySchemaAdded(Schema schema) {
        SchemaHandlerListener[] schemaHandlerListenerArray = this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0]);
        int n = schemaHandlerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SchemaHandlerListener listener = schemaHandlerListenerArray[n2];
            listener.schemaAdded(schema);
            ++n2;
        }
    }

    private void notifySchemaRemoved(Schema schema) {
        SchemaHandlerListener[] schemaHandlerListenerArray = this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0]);
        int n = schemaHandlerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SchemaHandlerListener listener = schemaHandlerListenerArray[n2];
            listener.schemaRemoved(schema);
            ++n2;
        }
    }

    private void notifySchemaRenamed(Schema schema) {
        SchemaHandlerListener[] schemaHandlerListenerArray = this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0]);
        int n = schemaHandlerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SchemaHandlerListener listener = schemaHandlerListenerArray[n2];
            listener.schemaRenamed(schema);
            ++n2;
        }
    }

    private void notifyAttributeTypeAdded(AttributeType at) {
        SchemaHandlerListener[] schemaHandlerListenerArray = this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0]);
        int n = schemaHandlerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SchemaHandlerListener listener = schemaHandlerListenerArray[n2];
            listener.attributeTypeAdded(at);
            ++n2;
        }
    }

    private void notifyAttributeTypeModified(AttributeType at) {
        SchemaHandlerListener[] schemaHandlerListenerArray = this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0]);
        int n = schemaHandlerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SchemaHandlerListener listener = schemaHandlerListenerArray[n2];
            listener.attributeTypeModified(at);
            ++n2;
        }
    }

    private void notifyAttributeTypeRemoved(AttributeType at) {
        SchemaHandlerListener[] schemaHandlerListenerArray = this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0]);
        int n = schemaHandlerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SchemaHandlerListener listener = schemaHandlerListenerArray[n2];
            listener.attributeTypeRemoved(at);
            ++n2;
        }
    }

    private void notifyObjectClassAdded(ObjectClass oc) {
        SchemaHandlerListener[] schemaHandlerListenerArray = this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0]);
        int n = schemaHandlerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SchemaHandlerListener listener = schemaHandlerListenerArray[n2];
            listener.objectClassAdded(oc);
            ++n2;
        }
    }

    private void notifyObjectClassModified(ObjectClass oc) {
        SchemaHandlerListener[] schemaHandlerListenerArray = this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0]);
        int n = schemaHandlerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SchemaHandlerListener listener = schemaHandlerListenerArray[n2];
            listener.objectClassModified(oc);
            ++n2;
        }
    }

    private void notifyObjectClassRemoved(ObjectClass oc) {
        SchemaHandlerListener[] schemaHandlerListenerArray = this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0]);
        int n = schemaHandlerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SchemaHandlerListener listener = schemaHandlerListenerArray[n2];
            listener.objectClassRemoved(oc);
            ++n2;
        }
    }

    public boolean isOidAlreadyTaken(String oid) {
        String lowerCasedOid = Strings.toLowerCase((String)oid);
        if (this.attributeTypesMap.containsKey((Object)lowerCasedOid)) {
            return true;
        }
        if (this.objectClassesMap.containsKey((Object)lowerCasedOid)) {
            return true;
        }
        if (this.matchingRulesMap.containsKey((Object)lowerCasedOid)) {
            return true;
        }
        return this.syntaxesMap.containsKey((Object)lowerCasedOid);
    }

    public boolean isAliasAlreadyTakenForAttributeType(String alias) {
        return this.attributeTypesMap.containsKey((Object)Strings.toLowerCase((String)alias));
    }

    public boolean isAliasAlreadyTakenForObjectClass(String alias) {
        return this.objectClassesMap.containsKey((Object)Strings.toLowerCase((String)alias));
    }

    public boolean isSchemaNameAlreadyTaken(String name) {
        return this.schemasMap.containsKey((Object)Strings.toLowerCase((String)name));
    }
}

