/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view;

import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaChecker;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.Folder;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;

public class SchemaEditorSchemaCheckerLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        SchemaChecker schemaChecker = Activator.getDefault().getSchemaChecker();
        ElementState state = ElementState.NONE;
        if (element instanceof AttributeTypeWrapper) {
            AttributeType at = ((AttributeTypeWrapper)element).getAttributeType();
            if (schemaChecker.hasErrors((SchemaObject)at)) {
                this.decorateState(ElementState.ERROR, decoration);
                return;
            }
            if (schemaChecker.hasWarnings((SchemaObject)at)) {
                state = ElementState.WARNING;
            }
        } else if (element instanceof ObjectClassWrapper) {
            ObjectClass oc = ((ObjectClassWrapper)element).getObjectClass();
            if (schemaChecker.hasErrors((SchemaObject)oc)) {
                this.decorateState(ElementState.ERROR, decoration);
                return;
            }
            if (schemaChecker.hasWarnings((SchemaObject)oc)) {
                state = ElementState.WARNING;
            }
        } else if (element instanceof SchemaWrapper) {
            Schema schema = ((SchemaWrapper)element).getSchema();
            for (AttributeType at : schema.getAttributeTypes()) {
                if (schemaChecker.hasErrors((SchemaObject)at)) {
                    this.decorateState(ElementState.ERROR, decoration);
                    return;
                }
                if (!schemaChecker.hasWarnings((SchemaObject)at)) continue;
                state = ElementState.WARNING;
            }
            for (ObjectClass oc : schema.getObjectClasses()) {
                if (schemaChecker.hasErrors((SchemaObject)oc)) {
                    this.decorateState(ElementState.ERROR, decoration);
                    return;
                }
                if (!schemaChecker.hasWarnings((SchemaObject)oc)) continue;
                state = ElementState.WARNING;
            }
        } else if (element instanceof Folder) {
            Folder folder = (Folder)element;
            if (this.childrenHasErrors(folder.getChildren(), schemaChecker)) {
                this.decorateState(ElementState.ERROR, decoration);
                return;
            }
            if (this.childrenHasWarnings(folder.getChildren(), schemaChecker)) {
                state = ElementState.WARNING;
            }
        }
        this.decorateState(state, decoration);
    }

    private void decorateState(ElementState state, IDecoration decoration) {
        switch (state) {
            case WARNING: {
                decoration.addOverlay(Activator.getDefault().getImageDescriptor("resources/icons/overlay_warning.gif"), 2);
                break;
            }
            case ERROR: {
                decoration.addOverlay(Activator.getDefault().getImageDescriptor("resources/icons/overlay_error.gif"), 2);
                break;
            }
        }
    }

    public boolean childrenHasWarnings(List<TreeNode> children, SchemaChecker schemaChecker) {
        if (children != null) {
            for (TreeNode child : children) {
                if (child instanceof AttributeTypeWrapper) {
                    AttributeType at = ((AttributeTypeWrapper)child).getAttributeType();
                    if (schemaChecker.hasWarnings((SchemaObject)at)) {
                        return true;
                    }
                    if (!this.childrenHasWarnings(child.getChildren(), schemaChecker)) continue;
                    return true;
                }
                if (!(child instanceof ObjectClassWrapper)) continue;
                ObjectClass oc = ((ObjectClassWrapper)child).getObjectClass();
                if (schemaChecker.hasWarnings((SchemaObject)oc)) {
                    return true;
                }
                if (!this.childrenHasWarnings(child.getChildren(), schemaChecker)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean childrenHasErrors(List<TreeNode> children, SchemaChecker schemaChecker) {
        if (children != null) {
            for (TreeNode child : children) {
                if (child instanceof AttributeTypeWrapper) {
                    AttributeType at = ((AttributeTypeWrapper)child).getAttributeType();
                    if (schemaChecker.hasErrors((SchemaObject)at)) {
                        return true;
                    }
                    if (!this.childrenHasErrors(child.getChildren(), schemaChecker)) continue;
                    return true;
                }
                if (!(child instanceof ObjectClassWrapper)) continue;
                ObjectClass oc = ((ObjectClassWrapper)child).getObjectClass();
                if (schemaChecker.hasErrors((SchemaObject)oc)) {
                    return true;
                }
                if (!this.childrenHasErrors(child.getChildren(), schemaChecker)) continue;
                return true;
            }
        }
        return false;
    }

    private static enum ElementState {
        NONE,
        WARNING,
        ERROR;

    }
}

