/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.LdifParserConstants;
import org.apache.directory.studio.ldifparser.model.LdifInvalidPart;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.lines.LdifLineBase;

public abstract class LdifContainer
implements LdifPart {
    protected List<LdifPart> ldifParts = new ArrayList<LdifPart>();

    protected LdifContainer(LdifPart part) {
        if (part == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(part);
    }

    @Override
    public final int getOffset() {
        return this.ldifParts.get(0).getOffset();
    }

    @Override
    public final int getLength() {
        LdifPart lastPart = this.getLastPart();
        return lastPart.getOffset() + lastPart.getLength() - this.getOffset();
    }

    public final void addInvalid(LdifInvalidPart invalid) {
        if (invalid == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(invalid);
    }

    public final LdifPart getLastPart() {
        return this.ldifParts.get(this.ldifParts.size() - 1);
    }

    public final LdifPart[] getParts() {
        return this.ldifParts.toArray(new LdifPart[this.ldifParts.size()]);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(":");
        sb.append(LdifParserConstants.LINE_SEPARATOR);
        for (LdifPart part : this.ldifParts) {
            sb.append("    ");
            sb.append(part.toString());
            sb.append(LdifParserConstants.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    @Override
    public final String toRawString() {
        StringBuilder sb = new StringBuilder();
        for (LdifPart part : this.ldifParts) {
            sb.append(part.toRawString());
        }
        return sb.toString();
    }

    @Override
    public final String toFormattedString(LdifFormatParameters formatParameters) {
        StringBuilder sb = new StringBuilder();
        for (LdifPart part : this.ldifParts) {
            sb.append(part.toFormattedString(formatParameters));
        }
        return sb.toString();
    }

    @Override
    public abstract boolean isValid();

    protected boolean isAbstractValid() {
        if (this.ldifParts.isEmpty()) {
            return false;
        }
        for (LdifPart ldifPart : this.ldifParts) {
            if (ldifPart instanceof LdifInvalidPart || !ldifPart.isValid()) {
                return false;
            }
            if (!(ldifPart instanceof LdifLineBase)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getInvalidString() {
        if (this.ldifParts.isEmpty()) {
            return "Empty Container";
        }
        for (LdifPart ldifPart : this.ldifParts) {
            if (ldifPart.isValid()) continue;
            return ldifPart.getInvalidString();
        }
        return null;
    }

    @Override
    public final void adjustOffset(int adjust) {
        for (LdifPart ldifPart : this.ldifParts) {
            ldifPart.adjustOffset(adjust);
        }
    }
}

