/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolderManager;
import org.apache.directory.studio.connection.core.ConnectionManager;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;

public class ConnectionFolder
implements Cloneable {
    private String id;
    private String name;
    private List<String> subFolderIds = new ArrayList<String>();
    private List<String> connectionIds = new ArrayList<String>();

    public ConnectionFolder() {
    }

    public ConnectionFolder(String name) {
        this();
        this.id = this.createId();
        this.name = name;
    }

    public Object clone() {
        ConnectionFolder folder = new ConnectionFolder(this.getName());
        ConnectionManager connectionManager = ConnectionCorePlugin.getDefault().getConnectionManager();
        for (String id : this.connectionIds) {
            Connection connection = connectionManager.getConnectionById(id);
            if (connection == null) continue;
            Connection newConnection = (Connection)connection.clone();
            connectionManager.addConnection(newConnection);
            folder.addConnectionId(newConnection.getId());
        }
        ConnectionFolderManager connectionFolderManager = ConnectionCorePlugin.getDefault().getConnectionFolderManager();
        for (String id : this.subFolderIds) {
            ConnectionFolder subFolder = connectionFolderManager.getConnectionFolderById(id);
            if (subFolder == null) continue;
            ConnectionFolder newFolder = (ConnectionFolder)subFolder.clone();
            connectionFolderManager.addConnectionFolder(newFolder);
            folder.addSubFolderId(newFolder.getId());
        }
        return folder;
    }

    public void addConnectionId(String connectionId) {
        this.connectionIds.add(connectionId);
        ConnectionEventRegistry.fireConnectonFolderModified(this, this);
    }

    public void removeConnectionId(String connectionId) {
        this.connectionIds.remove(connectionId);
        ConnectionEventRegistry.fireConnectonFolderModified(this, this);
    }

    public void addSubFolderId(String folderId) {
        this.subFolderIds.add(folderId);
        ConnectionEventRegistry.fireConnectonFolderModified(this, this);
    }

    public void removeSubFolderId(String folderId) {
        this.subFolderIds.remove(folderId);
        ConnectionEventRegistry.fireConnectonFolderModified(this, this);
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.createId();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        ConnectionEventRegistry.fireConnectonFolderModified(this, this);
    }

    public List<String> getSubFolderIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : this.subFolderIds) {
            if (ConnectionCorePlugin.getDefault().getConnectionFolderManager().getConnectionFolderById(id) == null) continue;
            ids.add(id);
        }
        return ids;
    }

    public void setSubFolderIds(List<String> subFolderIds) {
        this.subFolderIds = subFolderIds;
        ConnectionEventRegistry.fireConnectonFolderModified(this, this);
    }

    public List<String> getConnectionIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : this.connectionIds) {
            if (ConnectionCorePlugin.getDefault().getConnectionManager().getConnectionById(id) == null) continue;
            ids.add(id);
        }
        return ids;
    }

    public void setConnectionIds(List<String> connectionIds) {
        this.connectionIds = connectionIds;
        ConnectionEventRegistry.fireConnectonFolderModified(this, this);
    }

    private String createId() {
        return UUID.randomUUID().toString();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionFolder) {
            ConnectionFolder other = (ConnectionFolder)obj;
            return this.getId().equals(other.getId());
        }
        return false;
    }
}

