/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.entryeditors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateAdapter;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.entryeditors.EntryEditorExtension;
import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.entryeditors.EntryEditorUtils;
import org.apache.directory.studio.entryeditors.IEntryEditor;
import org.apache.directory.studio.entryeditors.Messages;
import org.apache.directory.studio.entryeditors.OpenEntryEditorRunnable;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.ValueAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueModifiedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueMultiModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueRenamedEvent;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.jobs.UpdateEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.CompoundModification;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EntryEditorManager {
    private static final String ID_ATTR = "id";
    private static final String NAME_ATTR = "name";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String ICON_ATTR = "icon";
    private static final String CLASS_ATTR = "class";
    private static final String EDITOR_ID_ATTR = "editorId";
    private static final String MULTI_WINDOW_ATTR = "multiWindow";
    private static final String PRIORITY_ATTR = "priority";
    public static final String PRIORITIES_SEPARATOR = ",";
    private Map<String, EntryEditorExtension> entryEditorExtensions = new HashMap<String, EntryEditorExtension>();
    private Map<IEntry, IEntry> oscSharedReferenceCopies = new HashMap<IEntry, IEntry>();
    private Map<IEntry, IEntry> oscSharedWorkingCopies = new HashMap<IEntry, IEntry>();
    private Map<IEntry, IEntry> autoSaveSharedReferenceCopies = new HashMap<IEntry, IEntry>();
    private Map<IEntry, IEntry> autoSaveSharedWorkingCopies = new HashMap<IEntry, IEntry>();
    private Comparator<EntryEditorExtension> entryEditorComparator = new Comparator<EntryEditorExtension>(){

        @Override
        public int compare(EntryEditorExtension o1, EntryEditorExtension o2) {
            int o2Priority;
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            int o1Priority = o1.getPriority();
            if (o1Priority != (o2Priority = o2.getPriority())) {
                return o1Priority > o2Priority ? -1 : 1;
            }
            String o1Name = o1.getName();
            String o2Name = o2.getName();
            if (o1Name == null) {
                return o2Name == null ? 0 : -1;
            }
            return o1Name.compareTo(o2Name);
        }
    };
    private IPartListener2 partListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
            EntryEditorManager.this.cleanupCopies(partRef.getPage());
            IEntryEditor editor = EntryEditorManager.this.getEntryEditor(partRef);
            if (editor != null) {
                LdifFile workDiff;
                LdifFile refDiff;
                EntryEditorInput eei = editor.getEntryEditorInput();
                IEntry originalEntry = eei.getResolvedEntry();
                IEntry oscSharedReferenceCopy = (IEntry)EntryEditorManager.this.oscSharedReferenceCopies.get(originalEntry);
                IEntry oscSharedWorkingCopy = (IEntry)EntryEditorManager.this.oscSharedWorkingCopies.get(originalEntry);
                if (editor.isAutoSave()) {
                    MessageDialog dialog;
                    int result;
                    LdifFile diff;
                    if (oscSharedReferenceCopy != null && oscSharedWorkingCopy != null && (diff = Utils.computeDiff((IEntry)oscSharedReferenceCopy, (IEntry)oscSharedWorkingCopy)) != null && (result = (dialog = new MessageDialog(partRef.getPart(false).getSite().getShell(), Messages.getString("EntryEditorManager.SaveChanges"), null, Messages.getString("EntryEditorManager.SaveChangesDescription"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0)).open()) == 0) {
                        EntryEditorManager.this.saveSharedWorkingCopy(originalEntry, true, null);
                    }
                } else if (oscSharedReferenceCopy != null && oscSharedWorkingCopy != null && (refDiff = Utils.computeDiff((IEntry)originalEntry, (IEntry)oscSharedReferenceCopy)) != null && (workDiff = Utils.computeDiff((IEntry)oscSharedReferenceCopy, (IEntry)oscSharedWorkingCopy)) != null) {
                    EntryEditorManager.this.askUpdateSharedWorkingCopy(partRef, originalEntry, oscSharedWorkingCopy, null);
                }
            }
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            EntryEditorManager.this.cleanupCopies(partRef.getPage());
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            EntryEditorManager.this.cleanupCopies(partRef.getPage());
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    };
    private EntryUpdateListener entryUpdateListener = new EntryUpdateListener(){

        public void entryUpdated(EntryModificationEvent event) {
            block25: {
                IEntry originalEntry;
                IEntry modifiedEntry;
                block24: {
                    LdifFile diff;
                    IBrowserConnection browserConnection;
                    modifiedEntry = event.getModifiedEntry();
                    if (modifiedEntry != (originalEntry = (browserConnection = modifiedEntry.getBrowserConnection()).getEntryFromCache(modifiedEntry.getDn()))) break block24;
                    IEntry oscSharedReferenceCopy = (IEntry)EntryEditorManager.this.oscSharedReferenceCopies.get(originalEntry);
                    IEntry oscSharedWorkingCopy = (IEntry)EntryEditorManager.this.oscSharedWorkingCopies.get(originalEntry);
                    if (oscSharedReferenceCopy != null && oscSharedWorkingCopy != null) {
                        IWorkbenchPartReference reference;
                        LdifFile workDiff;
                        LdifFile refDiff = Utils.computeDiff((IEntry)originalEntry, (IEntry)oscSharedReferenceCopy);
                        if (refDiff != null) {
                            workDiff = Utils.computeDiff((IEntry)oscSharedReferenceCopy, (IEntry)oscSharedWorkingCopy);
                            if (workDiff == null) {
                                EntryEditorManager.this.updateOscSharedReferenceCopy(originalEntry);
                                EntryEditorManager.this.updateOscSharedWorkingCopy(originalEntry);
                                List oscEditors = EntryEditorManager.this.getOscEditors(oscSharedWorkingCopy);
                                for (IEntryEditor editor : oscEditors) {
                                    editor.workingCopyModified(event.getSource());
                                }
                            } else {
                                reference = EntryEditorManager.this.getActivePartRef(EntryEditorManager.this.getOscEditors(oscSharedWorkingCopy));
                                if (reference != null) {
                                    EntryEditorManager.this.askUpdateSharedWorkingCopy(reference, originalEntry, oscSharedWorkingCopy, event.getSource());
                                }
                            }
                        } else {
                            workDiff = Utils.computeDiff((IEntry)oscSharedReferenceCopy, (IEntry)oscSharedWorkingCopy);
                            if (workDiff != null && (reference = EntryEditorManager.this.getActivePartRef(EntryEditorManager.this.getOscEditors(oscSharedWorkingCopy))) != null) {
                                EntryEditorManager.this.askUpdateSharedWorkingCopy(reference, originalEntry, oscSharedWorkingCopy, event.getSource());
                            }
                        }
                    }
                    IEntry autoSaveSharedReferenceCopy = (IEntry)EntryEditorManager.this.autoSaveSharedReferenceCopies.get(originalEntry);
                    IEntry autoSaveSharedWorkingCopy2 = (IEntry)EntryEditorManager.this.autoSaveSharedWorkingCopies.get(originalEntry);
                    if (autoSaveSharedReferenceCopy != null && autoSaveSharedWorkingCopy2 != null && (diff = Utils.computeDiff((IEntry)originalEntry, (IEntry)autoSaveSharedReferenceCopy)) != null) {
                        EntryEditorManager.this.updateAutoSaveSharedReferenceCopy(originalEntry);
                        EntryEditorManager.this.updateAutoSaveSharedWorkingCopy(originalEntry);
                        List editors = EntryEditorManager.this.getAutoSaveEditors(autoSaveSharedWorkingCopy2);
                        for (IEntryEditor editor : editors) {
                            editor.workingCopyModified(event.getSource());
                        }
                    }
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    ArrayList<IEditorReference> editorReferences = new ArrayList<IEditorReference>();
                    IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
                    int n = iEditorReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EntryEditorInput entryEditorInput;
                        IEditorReference ref = iEditorReferenceArray[n2];
                        IEntryEditor editor = EntryEditorManager.this.getEntryEditor((IWorkbenchPartReference)ref);
                        if (editor != null && (entryEditorInput = editor.getEntryEditorInput()) != null) {
                            Dn dn;
                            IBrowserConnection bc;
                            IEntry resolvedEntry = entryEditorInput.getResolvedEntry();
                            if (editor != null && resolvedEntry != null && (bc = resolvedEntry.getBrowserConnection()).getEntryFromCache(dn = resolvedEntry.getDn()) == null) {
                                editorReferences.add(ref);
                            }
                        }
                        ++n2;
                    }
                    if (editorReferences.isEmpty()) break block25;
                    activePage.closeEditors(editorReferences.toArray(new IEditorReference[0]), false);
                    break block25;
                }
                if (EntryEditorManager.this.oscSharedWorkingCopies.containsKey(originalEntry) && EntryEditorManager.this.oscSharedWorkingCopies.get(originalEntry) == modifiedEntry) {
                    IEntry oscSharedWorkingCopy = (IEntry)EntryEditorManager.this.oscSharedWorkingCopies.get(originalEntry);
                    List oscEditors = EntryEditorManager.this.getOscEditors(oscSharedWorkingCopy);
                    for (IEntryEditor editor : oscEditors) {
                        editor.workingCopyModified(event.getSource());
                    }
                } else if (EntryEditorManager.this.autoSaveSharedWorkingCopies.containsValue(originalEntry) && EntryEditorManager.this.autoSaveSharedWorkingCopies.get(originalEntry) == modifiedEntry) {
                    IEntry autoSaveSharedReferenceCopy = (IEntry)EntryEditorManager.this.autoSaveSharedReferenceCopies.get(originalEntry);
                    IEntry autoSaveSharedWorkingCopy = (IEntry)EntryEditorManager.this.autoSaveSharedWorkingCopies.get(originalEntry);
                    if (event.getSource() instanceof EntryEditorManager) {
                        return;
                    }
                    if (!(event instanceof ValueAddedEvent || event instanceof ValueDeletedEvent || event instanceof ValueModifiedEvent || event instanceof ValueRenamedEvent || event instanceof ValueMultiModificationEvent)) {
                        return;
                    }
                    IAttribute[] editorReferences = autoSaveSharedWorkingCopy.getAttributes();
                    int activePage = editorReferences.length;
                    int autoSaveSharedWorkingCopy2 = 0;
                    while (autoSaveSharedWorkingCopy2 < activePage) {
                        IAttribute attribute = editorReferences[autoSaveSharedWorkingCopy2];
                        IValue[] iValueArray = attribute.getValues();
                        int n = iValueArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            IValue value = iValueArray[n3];
                            if (value.isEmpty()) {
                                return;
                            }
                            ++n3;
                        }
                        ++autoSaveSharedWorkingCopy2;
                    }
                    LdifFile diff = Utils.computeDiff((IEntry)autoSaveSharedReferenceCopy, (IEntry)autoSaveSharedWorkingCopy);
                    if (diff != null) {
                        EntryEditorManager.this.autoSaveSharedReferenceCopies.remove(originalEntry);
                        EntryEditorManager.this.autoSaveSharedWorkingCopies.remove(originalEntry);
                        UpdateEntryRunnable runnable = new UpdateEntryRunnable(originalEntry, diff.toFormattedString(LdifFormatParameters.DEFAULT));
                        RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, null, (boolean)true);
                        EntryEditorManager.this.autoSaveSharedReferenceCopies.put(originalEntry, autoSaveSharedReferenceCopy);
                        EntryEditorManager.this.autoSaveSharedWorkingCopies.put(originalEntry, autoSaveSharedWorkingCopy);
                        EntryEditorManager.this.updateAutoSaveSharedReferenceCopy(originalEntry);
                        EntryEditorManager.this.updateAutoSaveSharedWorkingCopy(originalEntry);
                        List editors = EntryEditorManager.this.getAutoSaveEditors(autoSaveSharedWorkingCopy);
                        for (IEntryEditor editor : editors) {
                            editor.workingCopyModified(event.getSource());
                        }
                    }
                }
            }
        }
    };
    private ConnectionUpdateListener connectionUpdateListener = new ConnectionUpdateAdapter(){

        public void connectionClosed(Connection connection) {
            EntryEditorManager.this.closeEditorsBelongingToConnection(connection);
        }

        public void connectionRemoved(Connection connection) {
            EntryEditorManager.this.closeEditorsBelongingToConnection(connection);
        }
    };

    public EntryEditorManager() {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            this.getEditorManager();
        }
    }

    public void getEditorManager() {
        this.initEntryEditorExtensions();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener(this.partListener);
        EventRegistry.addEntryUpdateListener((EntryUpdateListener)this.entryUpdateListener, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        ConnectionEventRegistry.addConnectionUpdateListener((ConnectionUpdateListener)this.connectionUpdateListener, (EventRunner)ConnectionUIPlugin.getDefault().getEventRunner());
    }

    private void initEntryEditorExtensions() {
        IConfigurationElement[] members;
        this.entryEditorExtensions = new HashMap<String, EntryEditorExtension>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.apache.directory.studio.entryeditors");
        IConfigurationElement[] iConfigurationElementArray = members = extensionPoint.getConfigurationElements();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement member = iConfigurationElementArray[n2];
            EntryEditorExtension bean = new EntryEditorExtension();
            IExtension extension = member.getDeclaringExtension();
            String extendingPluginId = extension.getNamespaceIdentifier();
            bean.setId(member.getAttribute(ID_ATTR));
            bean.setName(member.getAttribute(NAME_ATTR));
            bean.setDescription(member.getAttribute(DESCRIPTION_ATTR));
            String iconPath = member.getAttribute(ICON_ATTR);
            ImageDescriptor icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)extendingPluginId, (String)iconPath);
            if (icon == null) {
                icon = ImageDescriptor.getMissingImageDescriptor();
            }
            bean.setIcon(icon);
            bean.setClassName(member.getAttribute(CLASS_ATTR));
            bean.setEditorId(member.getAttribute(EDITOR_ID_ATTR));
            bean.setMultiWindow("true".equalsIgnoreCase(member.getAttribute(MULTI_WINDOW_ATTR)));
            bean.setPriority(Integer.parseInt(member.getAttribute(PRIORITY_ATTR)));
            try {
                bean.setEditorInstance((IEntryEditor)member.createExecutableExtension(CLASS_ATTR));
            }
            catch (CoreException coreException) {}
            this.entryEditorExtensions.put(bean.getId(), bean);
            ++n2;
        }
    }

    public void dispose() {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww != null) {
            ww.getPartService().removePartListener(this.partListener);
            EventRegistry.removeEntryUpdateListener((EntryUpdateListener)this.entryUpdateListener);
        }
    }

    public Collection<EntryEditorExtension> getEntryEditorExtensions() {
        return this.entryEditorExtensions.values();
    }

    public EntryEditorExtension getEntryEditorExtension(String id) {
        return this.entryEditorExtensions.get(id);
    }

    public Collection<EntryEditorExtension> getSortedEntryEditorExtensions() {
        boolean useUserPriority = BrowserUIPlugin.getDefault().getPluginPreferences().getBoolean("useUserPriorities");
        if (useUserPriority) {
            return this.getEntryEditorExtensionsSortedByUserPriority();
        }
        return this.getEntryEditorExtensionsSortedByDefaultPriority();
    }

    public Collection<EntryEditorExtension> getEntryEditorExtensionsSortedByDefaultPriority() {
        Collection<EntryEditorExtension> entryEditorExtensions = this.getEntryEditorExtensions();
        ArrayList<EntryEditorExtension> sortedEntryEditorsList = new ArrayList<EntryEditorExtension>(entryEditorExtensions.size());
        for (EntryEditorExtension entryEditorExtension : entryEditorExtensions) {
            sortedEntryEditorsList.add(entryEditorExtension);
        }
        Collections.sort(sortedEntryEditorsList, this.entryEditorComparator);
        return sortedEntryEditorsList;
    }

    public Collection<EntryEditorExtension> getEntryEditorExtensionsSortedByUserPriority() {
        Collection<EntryEditorExtension> entryEditorExtensions = BrowserUIPlugin.getDefault().getEntryEditorManager().getEntryEditorExtensions();
        ArrayList<EntryEditorExtension> sortedEntryEditorsList = new ArrayList<EntryEditorExtension>(entryEditorExtensions.size());
        String userPriorities = BrowserUIPlugin.getDefault().getPluginPreferences().getString("userPriorities");
        if (userPriorities != null && !"".equals(userPriorities)) {
            String[] splittedUserPriorities = userPriorities.split(PRIORITIES_SEPARATOR);
            if (splittedUserPriorities != null && splittedUserPriorities.length > 0) {
                HashMap<String, EntryEditorExtension> entryEditorsMap = new HashMap<String, EntryEditorExtension>();
                for (EntryEditorExtension entryEditorExtension : entryEditorExtensions) {
                    entryEditorsMap.put(entryEditorExtension.getId(), entryEditorExtension);
                }
                String[] stringArray = splittedUserPriorities;
                int n = splittedUserPriorities.length;
                int n2 = 0;
                while (n2 < n) {
                    String entryEditorId = stringArray[n2];
                    if (entryEditorsMap.containsKey(entryEditorId)) {
                        sortedEntryEditorsList.add((EntryEditorExtension)entryEditorsMap.get(entryEditorId));
                    }
                    ++n2;
                }
            }
            ArrayList<EntryEditorExtension> remainingEntryEditors = new ArrayList<EntryEditorExtension>();
            for (EntryEditorExtension entryEditorExtension : entryEditorExtensions) {
                if (sortedEntryEditorsList.contains(entryEditorExtension)) continue;
                remainingEntryEditors.add(entryEditorExtension);
            }
            Collections.sort(remainingEntryEditors, this.entryEditorComparator);
            for (EntryEditorExtension entryEditorExtension : remainingEntryEditors) {
                sortedEntryEditorsList.add(entryEditorExtension);
            }
        }
        return sortedEntryEditorsList;
    }

    private void closeEditorsBelongingToConnection(Connection connection) {
        if (connection != null) {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            ArrayList<IEditorReference> editorReferences = new ArrayList<IEditorReference>();
            IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBrowserConnection bc;
                IEditorReference ref = iEditorReferenceArray[n2];
                IEntryEditor editor = this.getEntryEditor((IWorkbenchPartReference)ref);
                if (editor != null && editor.getEntryEditorInput().getResolvedEntry() != null && connection.equals((bc = editor.getEntryEditorInput().getResolvedEntry().getBrowserConnection()).getConnection())) {
                    editorReferences.add(ref);
                }
                ++n2;
            }
            if (!editorReferences.isEmpty()) {
                activePage.closeEditors(editorReferences.toArray(new IEditorReference[0]), false);
            }
        }
    }

    public void openEntryEditor(EntryEditorExtension extension, IEntry[] entries, ISearchResult[] searchResults, IBookmark[] bookmarks) {
        OpenEntryEditorRunnable runnable = new OpenEntryEditorRunnable(extension, entries, searchResults, bookmarks);
        StudioBrowserJob job = new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{runnable});
        job.setPriority(10);
        job.execute();
    }

    public void openEntryEditor(IEntry[] entries, ISearchResult[] searchResults, IBookmark[] bookmarks) {
        this.openEntryEditor(null, entries, searchResults, bookmarks);
    }

    private void updateOscSharedReferenceCopy(IEntry entry) {
        IEntry referenceCopy = this.oscSharedReferenceCopies.remove(entry);
        if (referenceCopy != null) {
            EventRegistry.suspendEventFiringInCurrentThread();
            EntryEditorUtils.ensureAttributesInitialized(entry);
            new CompoundModification().replaceAttributes(entry, referenceCopy, (Object)this);
            EventRegistry.resumeEventFiringInCurrentThread();
            this.oscSharedReferenceCopies.put(entry, referenceCopy);
        }
    }

    private void updateOscSharedWorkingCopy(IEntry entry) {
        IEntry workingCopy = this.oscSharedWorkingCopies.get(entry);
        if (workingCopy != null) {
            EntryEditorUtils.ensureAttributesInitialized(entry);
            new CompoundModification().replaceAttributes(entry, workingCopy, (Object)this);
        }
    }

    private void updateAutoSaveSharedReferenceCopy(IEntry entry) {
        EventRegistry.suspendEventFiringInCurrentThread();
        EntryEditorUtils.ensureAttributesInitialized(entry);
        IEntry workingCopy = this.autoSaveSharedReferenceCopies.get(entry);
        new CompoundModification().replaceAttributes(entry, workingCopy, (Object)this);
        EventRegistry.resumeEventFiringInCurrentThread();
    }

    private void updateAutoSaveSharedWorkingCopy(IEntry entry) {
        EntryEditorUtils.ensureAttributesInitialized(entry);
        IEntry workingCopy = this.autoSaveSharedWorkingCopies.get(entry);
        new CompoundModification().replaceAttributes(entry, workingCopy, (Object)this);
    }

    private List<IEntryEditor> getOscEditors(IEntry workingCopy) {
        IEditorReference[] editorReferences;
        ArrayList<IEntryEditor> oscEditors = new ArrayList<IEntryEditor>();
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEntryEditor editor = this.getEntryEditor((IWorkbenchPartReference)ref);
            if (!(editor == null || editor.isAutoSave() || workingCopy != null && editor.getEntryEditorInput().getSharedWorkingCopy(editor) != workingCopy)) {
                oscEditors.add(editor);
            }
            ++n2;
        }
        return oscEditors;
    }

    private List<IEntryEditor> getAutoSaveEditors(IEntry workingCopy) {
        IEditorReference[] editorReferences;
        ArrayList<IEntryEditor> autoSaveEditors = new ArrayList<IEntryEditor>();
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEntryEditor editor = this.getEntryEditor((IWorkbenchPartReference)ref);
            if (editor != null && editor.isAutoSave() && editor.getEntryEditorInput().getSharedWorkingCopy(editor) == workingCopy) {
                autoSaveEditors.add(editor);
            }
            ++n2;
        }
        return autoSaveEditors;
    }

    private IEntryEditor getEntryEditor(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof IEntryEditor) {
            return (IEntryEditor)part;
        }
        return null;
    }

    private IWorkbenchPartReference getActivePartRef(List<IEntryEditor> editors) {
        for (IEntryEditor editor : editors) {
            IEditorPart activeEditor;
            IWorkbenchPart part = (IWorkbenchPart)editor;
            if (part != (activeEditor = part.getSite().getPage().getActiveEditor())) continue;
            return part.getSite().getPage().getReference(part);
        }
        return null;
    }

    IEntry getSharedWorkingCopy(IEntry originalEntry, IEntryEditor editor) {
        this.cleanupCopies(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
        EntryEditorUtils.ensureAttributesInitialized(originalEntry);
        if (editor.isAutoSave()) {
            if (!this.autoSaveSharedReferenceCopies.containsKey(originalEntry)) {
                this.autoSaveSharedReferenceCopies.put(originalEntry, new CompoundModification().cloneEntry(originalEntry));
            }
            if (!this.autoSaveSharedWorkingCopies.containsKey(originalEntry)) {
                IEntry referenceCopy = this.autoSaveSharedReferenceCopies.get(originalEntry);
                this.autoSaveSharedWorkingCopies.put(originalEntry, new CompoundModification().cloneEntry(referenceCopy));
            }
            return this.autoSaveSharedWorkingCopies.get(originalEntry);
        }
        if (!this.oscSharedReferenceCopies.containsKey(originalEntry)) {
            this.oscSharedReferenceCopies.put(originalEntry, new CompoundModification().cloneEntry(originalEntry));
        }
        if (!this.oscSharedWorkingCopies.containsKey(originalEntry)) {
            IEntry referenceCopy = this.oscSharedReferenceCopies.get(originalEntry);
            this.oscSharedWorkingCopies.put(originalEntry, new CompoundModification().cloneEntry(referenceCopy));
        }
        return this.oscSharedWorkingCopies.get(originalEntry);
    }

    boolean isSharedWorkingCopyDirty(IEntry originalEntry, IEntryEditor editor) {
        if (editor.isAutoSave()) {
            return false;
        }
        IEntry referenceCopy = this.oscSharedReferenceCopies.get(originalEntry);
        IEntry workingCopy = this.oscSharedWorkingCopies.get(originalEntry);
        if (referenceCopy != null && workingCopy != null) {
            LdifFile diff = Utils.computeDiff((IEntry)referenceCopy, (IEntry)workingCopy);
            return diff != null;
        }
        return false;
    }

    IStatus saveSharedWorkingCopy(IEntry originalEntry, boolean handleError, IEntryEditor editor) {
        if (editor == null || !editor.isAutoSave()) {
            IEntry referenceCopy = this.oscSharedReferenceCopies.get(originalEntry);
            IEntry workingCopy = this.oscSharedWorkingCopies.get(originalEntry);
            if (referenceCopy != null && workingCopy != null) {
                IAttribute[] iAttributeArray = workingCopy.getAttributes();
                int n = iAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAttribute attribute = iAttributeArray[n2];
                    IValue[] iValueArray = attribute.getValues();
                    int n3 = iValueArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IValue value = iValueArray[n4];
                        if (value.isEmpty()) {
                            throw new RuntimeException(NLS.bind((String)Messages.getString("EntryEditorManager.EmptyValueInAttribute"), (Object)attribute.getDescription()));
                        }
                        ++n4;
                    }
                    ++n2;
                }
                LdifFile diff = Utils.computeDiff((IEntry)referenceCopy, (IEntry)workingCopy);
                if (diff != null) {
                    this.oscSharedReferenceCopies.remove(originalEntry);
                    this.oscSharedWorkingCopies.remove(originalEntry);
                    UpdateEntryRunnable runnable = new UpdateEntryRunnable(originalEntry, diff.toFormattedString(LdifFormatParameters.DEFAULT));
                    IStatus status = RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, null, (boolean)handleError);
                    this.oscSharedReferenceCopies.put(originalEntry, referenceCopy);
                    this.oscSharedWorkingCopies.put(originalEntry, workingCopy);
                    if (status.isOK()) {
                        this.updateOscSharedReferenceCopy(originalEntry);
                        this.updateOscSharedWorkingCopy(originalEntry);
                    }
                    return status;
                }
            }
        }
        return null;
    }

    void resetSharedWorkingCopy(IEntry originalEntry, IEntryEditor editor) {
        if (editor == null || !editor.isAutoSave()) {
            IEntry referenceCopy = this.oscSharedReferenceCopies.get(originalEntry);
            IEntry workingCopy = this.oscSharedWorkingCopies.get(originalEntry);
            if (referenceCopy != null && workingCopy != null) {
                this.updateOscSharedReferenceCopy(originalEntry);
                this.updateOscSharedWorkingCopy(originalEntry);
            }
        }
    }

    private void askUpdateSharedWorkingCopy(IWorkbenchPartReference partRef, IEntry originalEntry, IEntry oscSharedWorkingCopy, Object source) {
        MessageDialog dialog = new MessageDialog(partRef.getPart(false).getSite().getShell(), Messages.getString("EntryEditorManager.EntryChanged"), null, Messages.getString("EntryEditorManager.EntryChangedDescription"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        int result = dialog.open();
        if (result == 0) {
            this.updateOscSharedReferenceCopy(originalEntry);
            this.updateOscSharedWorkingCopy(originalEntry);
            List<IEntryEditor> oscEditors = this.getOscEditors(oscSharedWorkingCopy);
            for (IEntryEditor oscEditor : oscEditors) {
                oscEditor.workingCopyModified(source);
            }
        }
    }

    private void cleanupCopies(IWorkbenchPage page) {
        IEditorReference[] editorReferences;
        HashSet<IEntry> oscEntries = new HashSet<IEntry>();
        HashSet<IEntry> autoSaveEntries = new HashSet<IEntry>();
        IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            EntryEditorInput input;
            IEditorReference ref = iEditorReferenceArray[n2];
            IEntryEditor editor = this.getEntryEditor((IWorkbenchPartReference)ref);
            if (editor != null && (input = editor.getEntryEditorInput()) != null && input.getResolvedEntry() != null) {
                IEntry entry = input.getResolvedEntry();
                if (editor.isAutoSave()) {
                    autoSaveEntries.add(entry);
                } else {
                    oscEntries.add(entry);
                }
            }
            ++n2;
        }
        Iterator<IEntry> it = this.oscSharedReferenceCopies.keySet().iterator();
        while (it.hasNext()) {
            IEntry entry = it.next();
            if (oscEntries.contains(entry)) continue;
            it.remove();
            this.oscSharedWorkingCopies.remove(entry);
        }
        it = this.oscSharedWorkingCopies.keySet().iterator();
        while (it.hasNext()) {
            IEntry entry = it.next();
            if (oscEntries.contains(entry)) continue;
            it.remove();
        }
        it = this.autoSaveSharedReferenceCopies.keySet().iterator();
        while (it.hasNext()) {
            IEntry entry = it.next();
            if (autoSaveEntries.contains(entry)) continue;
            it.remove();
        }
        it = this.autoSaveSharedWorkingCopies.keySet().iterator();
        while (it.hasNext()) {
            IEntry entry = it.next();
            if (autoSaveEntries.contains(entry)) continue;
            it.remove();
        }
    }
}

