/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.AttributeComparator;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyEntryAsAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;

public class CopyEntryAsLdifAction
extends CopyEntryAsAction {
    public CopyEntryAsLdifAction(int mode) {
        super(Messages.getString("CopyEntryAsLdifAction.LDIF"), mode);
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.mode == 1) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_ldif.gif");
        }
        if (this.mode == 2) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_ldif_searchresult.gif");
        }
        if (this.mode == 4) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_ldif_operational.gif");
        }
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_ldif_user.gif");
    }

    @Override
    public void serialializeEntries(IEntry[] entries, StringBuffer text) {
        String lineSeparator = BrowserCorePlugin.getDefault().getPluginPreferences().getString("ldifLineSeparator");
        HashSet<String> returningAttributesSet = null;
        if (this.mode == 2 && this.getSelectedSearchResults().length > 0 && this.getSelectedEntries().length + this.getSelectedBookmarks().length + this.getSelectedSearches().length == 0) {
            returningAttributesSet = new HashSet<String>(Arrays.asList(this.getSelectedSearchResults()[0].getSearch().getReturningAttributes()));
        } else if (this.mode == 2 && this.getSelectedSearches().length == 1) {
            returningAttributesSet = new HashSet<String>(Arrays.asList(this.getSelectedSearches()[0].getReturningAttributes()));
        }
        boolean isFirst = true;
        IEntry[] iEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IEntry entry = iEntryArray[n2];
            if (isFirst) {
                isFirst = false;
            } else {
                text.append(lineSeparator);
            }
            this.serializeDn(entry.getDn(), text);
            if (this.mode != 1) {
                ArrayList<IValue> valueList = new ArrayList<IValue>();
                IAttribute[] attributes = entry.getAttributes();
                if (attributes != null) {
                    IAttribute[] iAttributeArray = attributes;
                    int n3 = attributes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAttribute attribute = iAttributeArray[n4];
                        if (!(returningAttributesSet != null && !returningAttributesSet.contains(attribute.getType()) || attribute.isOperationalAttribute() && this.mode != 4)) {
                            IValue[] iValueArray = attribute.getValues();
                            int n5 = iValueArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IValue value = iValueArray[n6];
                                valueList.add(value);
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                IValue[] values = valueList.toArray(new IValue[valueList.size()]);
                AttributeComparator comparator = new AttributeComparator();
                Arrays.sort(values, comparator);
                IValue[] iValueArray = values;
                int n7 = values.length;
                int n8 = 0;
                while (n8 < n7) {
                    IValue value = iValueArray[n8];
                    this.serializeValue(value, text);
                    ++n8;
                }
            }
            ++n2;
        }
    }

    protected void serializeValue(IValue value, StringBuffer text) {
        text.append(ModelConverter.valueToLdifAttrValLine((IValue)value).toFormattedString(Utils.getLdifFormatParameters()));
    }

    protected void serializeDn(Dn dn, StringBuffer text) {
        text.append(ModelConverter.dnToLdifDnLine((Dn)dn).toFormattedString(Utils.getLdifFormatParameters()));
    }
}

