/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.browser;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.entryeditors.EntryEditorExtension;
import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.entryeditors.EntryEditorManager;
import org.apache.directory.studio.entryeditors.IEntryEditor;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserContentProvider;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserUniversalListener;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.events.AttributesInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.BookmarkUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.BookmarkUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.BulkModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ChildrenInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryMovedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryRenamedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IContinuation;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IQuickSearch;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditor;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorInput;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserView;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.ConnectionView;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class BrowserViewUniversalListener
extends BrowserUniversalListener
implements SearchUpdateListener,
BookmarkUpdateListener {
    private Map<IBrowserConnection, Object[]> connectionToExpandedElementsMap;
    private Map<IBrowserConnection, ISelection> connectionToSelectedElementMap;
    private BrowserView view;
    private IContextActivation contextActivation;
    private INullSelectionListener connectionSelectionListener = new INullSelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (BrowserViewUniversalListener.this.view != null && part != null && BrowserViewUniversalListener.this.view.getSite().getWorkbenchWindow() == part.getSite().getWorkbenchWindow()) {
                Connection[] connections = BrowserSelectionUtils.getConnections((ISelection)selection);
                if (connections.length == 1) {
                    IBrowserConnection connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connections[0]);
                    BrowserViewUniversalListener.this.setInput(connection);
                } else {
                    BrowserViewUniversalListener.this.setInput(null);
                }
            }
        }
    };
    private IPartListener2 partListener = new IPartListener2(){

        public void partDeactivated(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == BrowserViewUniversalListener.this.view && BrowserViewUniversalListener.this.contextActivation != null) {
                BrowserViewUniversalListener.this.view.getActionGroup().deactivateGlobalActionHandlers();
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                contextService.deactivateContext(BrowserViewUniversalListener.this.contextActivation);
                BrowserViewUniversalListener.this.contextActivation = null;
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == BrowserViewUniversalListener.this.view) {
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                BrowserViewUniversalListener.this.contextActivation = contextService.activateContext(BrowserCommonConstants.CONTEXT_WINDOWS);
                BrowserViewUniversalListener.this.view.getActionGroup().activateGlobalActionHandlers();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };
    private ISelectionChangedListener viewerSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            BrowserViewUniversalListener.this.openEditor(event.getSelection());
        }
    };
    private IPropertyChangeListener preferencePropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("openMode".equals(event.getProperty())) {
                BrowserViewUniversalListener.this.setupOpenModeListeners();
            }
        }
    };
    private IOpenListener openListener = new IOpenListener(){

        public void open(OpenEvent event) {
            BrowserViewUniversalListener.this.openEditor(event.getSelection());
        }
    };

    public BrowserViewUniversalListener(BrowserView view) {
        super(view.getMainWidget());
        this.view = view;
        this.connectionToExpandedElementsMap = new HashMap<IBrowserConnection, Object[]>();
        this.connectionToSelectedElementMap = new HashMap<IBrowserConnection, ISelection>();
        EventRegistry.addSearchUpdateListener((SearchUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        EventRegistry.addBookmarkUpdateListener((BookmarkUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        EventRegistry.addEntryUpdateListener((EntryUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        ConnectionEventRegistry.addConnectionUpdateListener((ConnectionUpdateListener)this, (EventRunner)ConnectionUIPlugin.getDefault().getEventRunner());
        view.getSite().getPage().addPartListener(this.partListener);
        view.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(ConnectionView.getId(), (ISelectionListener)this.connectionSelectionListener);
        BrowserUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencePropertyChangeListener);
        this.setupOpenModeListeners();
    }

    private void setupOpenModeListeners() {
        int openMode = BrowserUIPlugin.getDefault().getPluginPreferences().getInt("openMode");
        if (openMode == 0) {
            this.viewer.removeOpenListener(this.openListener);
            this.viewer.addSelectionChangedListener(this.viewerSelectionListener);
        } else if (openMode == 1) {
            this.viewer.removeSelectionChangedListener(this.viewerSelectionListener);
            this.viewer.addOpenListener(this.openListener);
        }
    }

    private void openEditor(ISelection selection) {
        if (this.view != null) {
            IEntry[] entries = BrowserSelectionUtils.getEntries((ISelection)selection);
            ISearchResult[] searchResults = BrowserSelectionUtils.getSearchResults((ISelection)selection);
            IBookmark[] bookmarks = BrowserSelectionUtils.getBookmarks((ISelection)selection);
            ISearch[] searches = BrowserSelectionUtils.getSearches((ISelection)selection);
            EntryEditorManager entryEditorManager = BrowserUIPlugin.getDefault().getEntryEditorManager();
            if (entries.length + searchResults.length + bookmarks.length == 1) {
                entryEditorManager.openEntryEditor(entries, searchResults, bookmarks);
            } else {
                this.blankSingleTabEntryEditors();
                if (searches.length == 1) {
                    try {
                        SearchResultEditorInput input = new SearchResultEditorInput(searches[0]);
                        this.view.getSite().getPage().openEditor((IEditorInput)input, SearchResultEditor.getId(), false);
                    }
                    catch (PartInitException partInitException) {}
                }
            }
        }
    }

    private void blankSingleTabEntryEditors() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEntryEditor editor;
            IEditorReference ref = iEditorReferenceArray[n2];
            IWorkbenchPart part = ref.getPart(false);
            if (part instanceof IEntryEditor && (editor = (IEntryEditor)part) != null && editor.getEntryEditorInput() != null && editor.getEntryEditorInput().getResolvedEntry() != null && editor.getEntryEditorInput().getExtension() != null && !editor.getEntryEditorInput().getExtension().isMultiWindow()) {
                EntryEditorExtension extension = editor.getEntryEditorInput().getExtension();
                String editorId = extension.getEditorId();
                EntryEditorInput input = new EntryEditorInput(null, extension);
                try {
                    this.view.getSite().getPage().openEditor((IEditorInput)input, editorId, false);
                }
                catch (PartInitException partInitException) {}
            }
            ++n2;
        }
    }

    public void dispose() {
        if (this.view != null) {
            EventRegistry.removeSearchUpdateListener((SearchUpdateListener)this);
            EventRegistry.removeBookmarkUpdateListener((BookmarkUpdateListener)this);
            EventRegistry.removeEntryUpdateListener((EntryUpdateListener)this);
            ConnectionEventRegistry.removeConnectionUpdateListener((ConnectionUpdateListener)this);
            this.view.getSite().getPage().removePartListener(this.partListener);
            this.view.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(ConnectionView.getId(), (ISelectionListener)this.connectionSelectionListener);
            this.viewer.removeOpenListener(this.openListener);
            this.viewer.removeSelectionChangedListener(this.viewerSelectionListener);
            this.view = null;
            this.connectionToExpandedElementsMap.clear();
            this.connectionToExpandedElementsMap = null;
            this.connectionToSelectedElementMap.clear();
            this.connectionToSelectedElementMap = null;
        }
        super.dispose();
    }

    void setInput(IBrowserConnection connection) {
        if (connection != this.viewer.getInput()) {
            IBrowserConnection currentConnection;
            IBrowserConnection iBrowserConnection = currentConnection = this.viewer.getInput() instanceof IBrowserConnection ? (IBrowserConnection)this.viewer.getInput() : null;
            if (currentConnection != null) {
                this.connectionToExpandedElementsMap.put(currentConnection, this.viewer.getExpandedElements());
                if (!this.viewer.getSelection().isEmpty()) {
                    this.connectionToSelectedElementMap.put(currentConnection, this.viewer.getSelection());
                }
            }
            this.viewer.setInput((Object)connection);
            this.view.getActionGroup().setInput(connection);
            this.view.getMainWidget().getQuickSearchWidget().setInput(connection);
            if (this.view != null && connection != null) {
                if (this.connectionToExpandedElementsMap.containsKey(connection)) {
                    this.viewer.setExpandedElements(this.connectionToExpandedElementsMap.get(connection));
                }
                if (this.connectionToSelectedElementMap.containsKey(connection) && this.view.getSite().getPage().isPartVisible((IWorkbenchPart)this.view)) {
                    this.viewer.setSelection(this.connectionToSelectedElementMap.get(connection), true);
                }
            }
        }
    }

    public void connectionOpened(Connection connection) {
        IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connection);
        if (browserConnection == null) {
            return;
        }
        this.viewer.refresh((Object)browserConnection);
        this.viewer.expandToLevel(2);
        IRootDSE rootDSE = browserConnection.getRootDSE();
        this.viewer.expandToLevel((Object)rootDSE, 1);
        if (this.view.getConfiguration().getPreferences().isExpandBaseEntries()) {
            this.viewer.expandToLevel((Object)rootDSE, 2);
        }
    }

    public void connectionClosed(Connection connection) {
        IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connection);
        if (browserConnection == null) {
            return;
        }
        this.viewer.collapseAll();
        this.connectionToExpandedElementsMap.remove(browserConnection);
        this.connectionToSelectedElementMap.remove(browserConnection);
        this.viewer.refresh((Object)browserConnection);
    }

    public void searchUpdated(SearchUpdateEvent searchUpdateEvent) {
        ISearch search = searchUpdateEvent.getSearch();
        if (search instanceof IQuickSearch && searchUpdateEvent.getDetail() == SearchUpdateEvent.EventDetail.SEARCH_REMOVED && search.getBrowserConnection().getQuickSearch() == search) {
            search.getBrowserConnection().setQuickSearch(null);
        }
        this.viewer.refresh();
        if (search instanceof IContinuation) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)search), true);
        } else if (search.getBrowserConnection().getSearchManager().getSearches().contains(search)) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)search), true);
        } else if (search instanceof IQuickSearch && searchUpdateEvent.getDetail() != SearchUpdateEvent.EventDetail.SEARCH_REMOVED) {
            if (search.getBrowserConnection().getQuickSearch() == search) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)search), true);
            }
        } else {
            Object searchCategory = ((ITreeContentProvider)this.viewer.getContentProvider()).getParent((Object)search);
            if (searchCategory != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection(searchCategory), true);
            }
        }
    }

    public void bookmarkUpdated(BookmarkUpdateEvent bookmarkUpdateEvent) {
        this.viewer.refresh();
    }

    public void entryUpdated(EntryModificationEvent event) {
        if (event instanceof AttributesInitializedEvent && !(event.getModifiedEntry() instanceof IRootDSE)) {
            return;
        }
        if (event instanceof EntryAddedEvent) {
            this.viewer.refresh((Object)event.getModifiedEntry(), true);
            this.viewer.refresh((Object)event.getModifiedEntry().getParententry(), true);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)event.getModifiedEntry()), true);
        } else if (event instanceof EntryRenamedEvent) {
            EntryRenamedEvent ere = (EntryRenamedEvent)event;
            this.viewer.refresh((Object)ere.getNewEntry().getParententry(), true);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)ere.getNewEntry()), true);
        } else if (event instanceof EntryMovedEvent) {
            EntryMovedEvent eme = (EntryMovedEvent)event;
            this.viewer.refresh((Object)eme.getOldEntry().getParententry(), true);
            this.viewer.refresh((Object)eme.getNewEntry().getParententry(), true);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)eme.getNewEntry()), true);
        } else if (event instanceof EntryDeletedEvent) {
            EntryDeletedEvent ede = (EntryDeletedEvent)event;
            if (ede.getModifiedEntry().getParententry() != null) {
                this.viewer.refresh((Object)ede.getModifiedEntry().getParententry(), true);
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)ede.getModifiedEntry().getParententry()), true);
            } else {
                this.viewer.refresh();
            }
        } else if (event instanceof BulkModificationEvent) {
            this.viewer.refresh();
        } else if (event instanceof ChildrenInitializedEvent) {
            Object[] children;
            Object[] objectArray = children = ((BrowserContentProvider)this.viewer.getContentProvider()).getChildren((Object)event.getModifiedEntry());
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (this.viewer.getExpandedState(child)) {
                    this.viewer.collapseToLevel(child, -1);
                    if (this.viewer.getExpandedState(child)) {
                        this.viewer.remove(child);
                    }
                }
                ++n2;
            }
            this.viewer.refresh((Object)event.getModifiedEntry(), true);
        } else if (!(event.getModifiedEntry() instanceof DummyEntry)) {
            this.viewer.refresh((Object)event.getModifiedEntry(), true);
        }
    }
}

